/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.trino.parquet.reader.ColumnReaderFactory;
import io.trino.plugin.hive.coercions.DecimalCoercers;
import io.trino.plugin.hive.coercions.DoubleToVarcharCoercers;
import io.trino.plugin.hive.coercions.FloatToVarcharCoercers;
import io.trino.plugin.hive.coercions.IntegerNumberToDoubleCoercer;
import io.trino.plugin.hive.coercions.IntegerNumberToVarcharCoercer;
import io.trino.plugin.hive.coercions.TimestampCoercer;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetTypeTranslator {
    private ParquetTypeTranslator() {
    }

    public static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercer(PrimitiveType.PrimitiveTypeName fromParquetType, LogicalTypeAnnotation typeAnnotation, Type toTrinoType) {
        if (toTrinoType instanceof DoubleType && ColumnReaderFactory.isIntegerAnnotationAndPrimitive((LogicalTypeAnnotation)typeAnnotation, (PrimitiveType.PrimitiveTypeName)fromParquetType)) {
            if (fromParquetType == PrimitiveType.PrimitiveTypeName.INT32) {
                return Optional.of(new IntegerNumberToDoubleCoercer<IntegerType>(IntegerType.INTEGER));
            }
            if (fromParquetType == PrimitiveType.PrimitiveTypeName.INT64) {
                return Optional.of(new IntegerNumberToDoubleCoercer<BigintType>(BigintType.BIGINT));
            }
        }
        if (toTrinoType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)toTrinoType;
            if (ColumnReaderFactory.isIntegerAnnotationAndPrimitive((LogicalTypeAnnotation)typeAnnotation, (PrimitiveType.PrimitiveTypeName)fromParquetType)) {
                if (fromParquetType == PrimitiveType.PrimitiveTypeName.INT32) {
                    return Optional.of(new IntegerNumberToVarcharCoercer<IntegerType>(IntegerType.INTEGER, varcharType));
                }
                if (fromParquetType == PrimitiveType.PrimitiveTypeName.INT64) {
                    return Optional.of(new IntegerNumberToVarcharCoercer<BigintType>(BigintType.BIGINT, varcharType));
                }
            }
            if (fromParquetType == PrimitiveType.PrimitiveTypeName.FLOAT) {
                return Optional.of(FloatToVarcharCoercers.createFloatToVarcharCoercer(varcharType, false));
            }
            if (fromParquetType == PrimitiveType.PrimitiveTypeName.DOUBLE) {
                return Optional.of(DoubleToVarcharCoercers.createDoubleToVarcharCoercer(varcharType, false));
            }
            if (typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation;
                return Optional.of(DecimalCoercers.createDecimalToVarcharCoercer(DecimalType.createDecimalType((int)decimalAnnotation.getPrecision(), (int)decimalAnnotation.getScale()), varcharType));
            }
            if (fromParquetType == PrimitiveType.PrimitiveTypeName.INT96) {
                return Optional.of(new TimestampCoercer.LongTimestampToVarcharCoercer(TimestampType.TIMESTAMP_NANOS, varcharType));
            }
        }
        return Optional.empty();
    }
}

