/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metastore.Column;
import io.trino.metastore.Table;
import io.trino.plugin.hive.HiveTableProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.projection.DateProjection;
import io.trino.plugin.hive.projection.EnumProjection;
import io.trino.plugin.hive.projection.InjectedProjection;
import io.trino.plugin.hive.projection.IntegerProjection;
import io.trino.plugin.hive.projection.InvalidProjectionException;
import io.trino.plugin.hive.projection.PartitionProjection;
import io.trino.plugin.hive.projection.Projection;
import io.trino.plugin.hive.projection.ProjectionType;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class PartitionProjectionProperties {
    private static final String COLUMN_PROJECTION_TYPE_SUFFIX = "type";
    private static final String COLUMN_PROJECTION_VALUES_SUFFIX = "values";
    private static final String COLUMN_PROJECTION_RANGE_SUFFIX = "range";
    private static final String COLUMN_PROJECTION_INTERVAL_SUFFIX = "interval";
    private static final String COLUMN_PROJECTION_DIGITS_SUFFIX = "digits";
    private static final String COLUMN_PROJECTION_FORMAT_SUFFIX = "format";
    private static final String METASTORE_PROPERTY_PROJECTION_INTERVAL_UNIT_SUFFIX = "interval.unit";
    private static final String METASTORE_PROPERTY_PROJECTION_ENABLED = "projection.enabled";
    private static final String METASTORE_PROPERTY_PROJECTION_LOCATION_TEMPLATE = "storage.location.template";
    private static final String METASTORE_PROPERTY_PROJECTION_IGNORE = "trino.partition_projection.ignore";
    private static final String PROPERTY_KEY_PREFIX = "partition_projection_";
    public static final String COLUMN_PROJECTION_FORMAT = "partition_projection_format";
    public static final String COLUMN_PROJECTION_DIGITS = "partition_projection_digits";
    public static final String COLUMN_PROJECTION_INTERVAL_UNIT = "partition_projection_interval_unit";
    public static final String COLUMN_PROJECTION_INTERVAL = "partition_projection_interval";
    public static final String COLUMN_PROJECTION_RANGE = "partition_projection_range";
    public static final String COLUMN_PROJECTION_VALUES = "partition_projection_values";
    public static final String COLUMN_PROJECTION_TYPE = "partition_projection_type";
    public static final String PARTITION_PROJECTION_IGNORE = "partition_projection_ignore";
    public static final String PARTITION_PROJECTION_LOCATION_TEMPLATE = "partition_projection_location_template";
    public static final String PARTITION_PROJECTION_ENABLED = "partition_projection_enabled";

    private PartitionProjectionProperties() {
    }

    public static Map<String, Object> getPartitionProjectionTrinoTableProperties(Table table) {
        String locationTemplate;
        String enabled;
        Map metastoreTableProperties = table.getParameters();
        ImmutableMap.Builder trinoTablePropertiesBuilder = ImmutableMap.builder();
        String ignore = (String)metastoreTableProperties.get(METASTORE_PROPERTY_PROJECTION_IGNORE);
        if (ignore != null) {
            trinoTablePropertiesBuilder.put((Object)PARTITION_PROJECTION_IGNORE, (Object)Boolean.valueOf(ignore));
        }
        if ((enabled = (String)metastoreTableProperties.get(METASTORE_PROPERTY_PROJECTION_ENABLED)) != null) {
            trinoTablePropertiesBuilder.put((Object)PARTITION_PROJECTION_ENABLED, (Object)Boolean.valueOf(enabled));
        }
        if ((locationTemplate = (String)metastoreTableProperties.get(METASTORE_PROPERTY_PROJECTION_LOCATION_TEMPLATE)) != null) {
            trinoTablePropertiesBuilder.put((Object)PARTITION_PROJECTION_LOCATION_TEMPLATE, (Object)locationTemplate);
        }
        return trinoTablePropertiesBuilder.buildOrThrow();
    }

    public static Map<String, Object> getPartitionProjectionTrinoColumnProperties(Table table, String columnName) {
        Map metastoreTableProperties = table.getParameters();
        return PartitionProjectionProperties.rewriteColumnProjectionProperties(metastoreTableProperties, columnName);
    }

    public static Map<String, String> getPartitionProjectionHiveTableProperties(ConnectorTableMetadata tableMetadata) {
        Object locationTemplate;
        Object enabled;
        ImmutableMap.Builder metastoreTablePropertiesBuilder = ImmutableMap.builder();
        Map trinoTableProperties = tableMetadata.getProperties();
        Object ignore = trinoTableProperties.get(PARTITION_PROJECTION_IGNORE);
        if (ignore != null) {
            metastoreTablePropertiesBuilder.put((Object)METASTORE_PROPERTY_PROJECTION_IGNORE, (Object)ignore.toString().toLowerCase(Locale.ROOT));
        }
        if ((enabled = trinoTableProperties.get(PARTITION_PROJECTION_ENABLED)) != null) {
            metastoreTablePropertiesBuilder.put((Object)METASTORE_PROPERTY_PROJECTION_ENABLED, (Object)enabled.toString().toLowerCase(Locale.ROOT));
        }
        if ((locationTemplate = trinoTableProperties.get(PARTITION_PROJECTION_LOCATION_TEMPLATE)) != null) {
            metastoreTablePropertiesBuilder.put((Object)METASTORE_PROPERTY_PROJECTION_LOCATION_TEMPLATE, (Object)locationTemplate.toString());
        }
        tableMetadata.getColumns().stream().filter(columnMetadata -> !columnMetadata.getProperties().isEmpty()).forEach(columnMetadata -> {
            Object patt6$temp;
            Object patt5$temp;
            Object patt4$temp;
            Object patt3$temp;
            Object patt2$temp;
            Object patt1$temp;
            Map columnProperties = columnMetadata.getProperties();
            String columnName = columnMetadata.getName();
            Object patt0$temp = columnProperties.get(COLUMN_PROJECTION_TYPE);
            if (patt0$temp instanceof ProjectionType) {
                ProjectionType projectionType = (ProjectionType)((Object)((Object)patt0$temp));
                metastoreTablePropertiesBuilder.put((Object)PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_TYPE_SUFFIX), (Object)projectionType.name().toLowerCase(Locale.ROOT));
            }
            if ((patt1$temp = columnProperties.get(COLUMN_PROJECTION_VALUES)) instanceof List) {
                List values = (List)patt1$temp;
                metastoreTablePropertiesBuilder.put((Object)PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_VALUES_SUFFIX), (Object)Joiner.on((String)",").join((Iterable)values));
            }
            if ((patt2$temp = columnProperties.get(COLUMN_PROJECTION_RANGE)) instanceof List) {
                List range = (List)patt2$temp;
                metastoreTablePropertiesBuilder.put((Object)PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_RANGE_SUFFIX), (Object)Joiner.on((String)",").join((Iterable)range));
            }
            if ((patt3$temp = columnProperties.get(COLUMN_PROJECTION_INTERVAL)) instanceof Integer) {
                Integer interval = (Integer)patt3$temp;
                metastoreTablePropertiesBuilder.put((Object)PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_INTERVAL_SUFFIX), (Object)interval.toString());
            }
            if ((patt4$temp = columnProperties.get(COLUMN_PROJECTION_INTERVAL_UNIT)) instanceof ChronoUnit) {
                ChronoUnit intervalUnit = (ChronoUnit)patt4$temp;
                metastoreTablePropertiesBuilder.put((Object)PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, METASTORE_PROPERTY_PROJECTION_INTERVAL_UNIT_SUFFIX), (Object)intervalUnit.name().toLowerCase(Locale.ROOT));
            }
            if ((patt5$temp = columnProperties.get(COLUMN_PROJECTION_DIGITS)) instanceof Integer) {
                Integer digits = (Integer)patt5$temp;
                metastoreTablePropertiesBuilder.put((Object)PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_DIGITS_SUFFIX), (Object)digits.toString());
            }
            if ((patt6$temp = columnProperties.get(COLUMN_PROJECTION_FORMAT)) instanceof String) {
                String format = (String)patt6$temp;
                metastoreTablePropertiesBuilder.put((Object)PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_FORMAT_SUFFIX), (Object)format);
            }
        });
        ImmutableMap metastoreTableProperties = metastoreTablePropertiesBuilder.buildOrThrow();
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        PartitionProjectionProperties.createPartitionProjection((List)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).filter(arg_0 -> PartitionProjectionProperties.lambda$getPartitionProjectionHiveTableProperties$2((Set)partitionColumnNames, arg_0)).collect(ImmutableList.toImmutableList()), (Map)tableMetadata.getColumns().stream().filter(arg_0 -> PartitionProjectionProperties.lambda$getPartitionProjectionHiveTableProperties$3((Set)partitionColumnNames, arg_0)).collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, ColumnMetadata::getType)), (Map<String, String>)metastoreTableProperties);
        return metastoreTableProperties;
    }

    public static boolean arePartitionProjectionPropertiesSet(ConnectorTableMetadata tableMetadata) {
        if (tableMetadata.getProperties().keySet().stream().anyMatch(propertyKey -> propertyKey.startsWith(PROPERTY_KEY_PREFIX))) {
            return true;
        }
        return tableMetadata.getColumns().stream().map(columnMetadata -> columnMetadata.getProperties().keySet()).flatMap(Collection::stream).anyMatch(propertyKey -> propertyKey.startsWith(PROPERTY_KEY_PREFIX));
    }

    public static Optional<PartitionProjection> getPartitionProjectionFromTable(Table table, TypeManager typeManager) {
        Map tableProperties = table.getParameters();
        if (Boolean.parseBoolean((String)tableProperties.get(METASTORE_PROPERTY_PROJECTION_IGNORE)) || !Boolean.parseBoolean((String)tableProperties.get(METASTORE_PROPERTY_PROJECTION_ENABLED))) {
            return Optional.empty();
        }
        Set partitionColumnNames = table.getPartitionColumns().stream().map(Column::getName).collect(Collectors.toSet());
        return PartitionProjectionProperties.createPartitionProjection((List)table.getDataColumns().stream().map(Column::getName).filter(partitionColumnNames::contains).collect(ImmutableList.toImmutableList()), (Map)table.getPartitionColumns().stream().collect(ImmutableMap.toImmutableMap(Column::getName, column -> HiveTypeUtil.getType(column.getType(), typeManager, HiveTimestampPrecision.DEFAULT_PRECISION))), tableProperties);
    }

    private static Optional<PartitionProjection> createPartitionProjection(List<String> dataColumns, Map<String, Type> partitionColumns, Map<String, String> tableProperties) {
        boolean enabled = Boolean.parseBoolean(tableProperties.get(METASTORE_PROPERTY_PROJECTION_ENABLED));
        if (!tableProperties.containsKey(METASTORE_PROPERTY_PROJECTION_ENABLED) && partitionColumns.keySet().stream().anyMatch(columnName -> !PartitionProjectionProperties.rewriteColumnProjectionProperties(tableProperties, columnName).isEmpty())) {
            throw new InvalidProjectionException("Columns partition projection properties cannot be set when '%s' is not set".formatted(PARTITION_PROJECTION_ENABLED));
        }
        if (enabled && partitionColumns.isEmpty()) {
            throw new InvalidProjectionException("Partition projection cannot be enabled on a table that is not partitioned");
        }
        for (String columnName2 : dataColumns) {
            if (PartitionProjectionProperties.rewriteColumnProjectionProperties(tableProperties, columnName2).isEmpty()) continue;
            throw new InvalidProjectionException("Partition projection cannot be defined for non-partition column: '" + columnName2 + "'");
        }
        HashMap<String, Projection> columnProjections = new HashMap<String, Projection>();
        partitionColumns.forEach((columnName, type) -> {
            Map<String, Object> columnProperties = PartitionProjectionProperties.rewriteColumnProjectionProperties(tableProperties, columnName);
            if (enabled) {
                columnProjections.put((String)columnName, PartitionProjectionProperties.parseColumnProjection(columnName, type, columnProperties));
            }
        });
        Optional<String> storageLocationTemplate = Optional.ofNullable(tableProperties.get(METASTORE_PROPERTY_PROJECTION_LOCATION_TEMPLATE));
        storageLocationTemplate.ifPresent(locationTemplate -> {
            for (String columnName : partitionColumns.keySet()) {
                if (locationTemplate.contains("${" + columnName + "}")) continue;
                throw new InvalidProjectionException(String.format("Partition projection location template: %s is missing partition column: '%s' placeholder", locationTemplate, columnName));
            }
        });
        if (!enabled) {
            return Optional.empty();
        }
        return Optional.of(new PartitionProjection(storageLocationTemplate, columnProjections));
    }

    private static Map<String, Object> rewriteColumnProjectionProperties(Map<String, String> metastoreTableProperties, String columnName) {
        String format;
        String digits;
        String intervalUnit;
        String interval;
        String range;
        String values;
        ImmutableMap.Builder trinoTablePropertiesBuilder = ImmutableMap.builder();
        String type = metastoreTableProperties.get(PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_TYPE_SUFFIX));
        if (type != null) {
            trinoTablePropertiesBuilder.put((Object)COLUMN_PROJECTION_TYPE, (Object)ProjectionType.valueOf(type.toUpperCase(Locale.ROOT)));
        }
        if ((values = metastoreTableProperties.get(PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_VALUES_SUFFIX))) != null) {
            trinoTablePropertiesBuilder.put((Object)COLUMN_PROJECTION_VALUES, PartitionProjectionProperties.splitCommaSeparatedString(values));
        }
        if ((range = metastoreTableProperties.get(PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_RANGE_SUFFIX))) != null) {
            trinoTablePropertiesBuilder.put((Object)COLUMN_PROJECTION_RANGE, PartitionProjectionProperties.splitCommaSeparatedString(range));
        }
        if ((interval = metastoreTableProperties.get(PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_INTERVAL_SUFFIX))) != null) {
            trinoTablePropertiesBuilder.put((Object)COLUMN_PROJECTION_INTERVAL, (Object)Integer.valueOf(interval));
        }
        if ((intervalUnit = metastoreTableProperties.get(PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, METASTORE_PROPERTY_PROJECTION_INTERVAL_UNIT_SUFFIX))) != null) {
            trinoTablePropertiesBuilder.put((Object)COLUMN_PROJECTION_INTERVAL_UNIT, (Object)ChronoUnit.valueOf(intervalUnit.toUpperCase(Locale.ROOT)));
        }
        if ((digits = metastoreTableProperties.get(PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_DIGITS_SUFFIX))) != null) {
            trinoTablePropertiesBuilder.put((Object)COLUMN_PROJECTION_DIGITS, (Object)Integer.valueOf(digits));
        }
        if ((format = metastoreTableProperties.get(PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, COLUMN_PROJECTION_FORMAT_SUFFIX))) != null) {
            trinoTablePropertiesBuilder.put((Object)COLUMN_PROJECTION_FORMAT, (Object)format);
        }
        return trinoTablePropertiesBuilder.buildOrThrow();
    }

    private static Projection parseColumnProjection(String columnName, Type columnType, Map<String, Object> columnProperties) {
        ProjectionType projectionType = (ProjectionType)((Object)columnProperties.get(COLUMN_PROJECTION_TYPE));
        if (projectionType == null) {
            throw new InvalidProjectionException(columnName, "Projection type property missing");
        }
        return switch (projectionType) {
            default -> throw new MatchException(null, null);
            case ProjectionType.ENUM -> new EnumProjection(columnName, columnType, columnProperties);
            case ProjectionType.INTEGER -> new IntegerProjection(columnName, columnType, columnProperties);
            case ProjectionType.DATE -> new DateProjection(columnName, columnType, columnProperties);
            case ProjectionType.INJECTED -> new InjectedProjection(columnName, columnType);
        };
    }

    private static List<String> splitCommaSeparatedString(String value) {
        return Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)value);
    }

    private static String getMetastoreProjectionPropertyKey(String columnName, String propertyKeySuffix) {
        return "projection." + columnName + "." + propertyKeySuffix;
    }

    static <T, I> T getProjectionPropertyRequiredValue(String columnName, Map<String, I> columnProjectionProperties, String propertyKey, Function<I, T> decoder) {
        return PartitionProjectionProperties.getProjectionPropertyValue(columnProjectionProperties, propertyKey, decoder).orElseThrow(() -> new InvalidProjectionException(columnName, String.format("Missing required property: '%s'", propertyKey)));
    }

    static <T, I> Optional<T> getProjectionPropertyValue(Map<String, I> columnProjectionProperties, String propertyKey, Function<I, T> decoder) {
        return Optional.ofNullable(columnProjectionProperties.get(propertyKey)).map(decoder);
    }

    private static /* synthetic */ boolean lambda$getPartitionProjectionHiveTableProperties$3(Set partitionColumnNames, ColumnMetadata columnMetadata) {
        return partitionColumnNames.contains(columnMetadata.getName());
    }

    private static /* synthetic */ boolean lambda$getPartitionProjectionHiveTableProperties$2(Set partitionColumnNames, String name) {
        return !partitionColumnNames.contains(name);
    }
}

