/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.plugin.base.security.AllowAllSecurityModule;
import io.trino.plugin.base.security.ConnectorAccessControlModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.security.AccessControlMetadataFactory;
import io.trino.plugin.hive.security.SecurityConfig;
import io.trino.plugin.hive.security.SqlStandardSecurityModule;
import io.trino.plugin.hive.security.UsingSystemSecurity;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new ConnectorAccessControlModule());
        this.install(switch (((SecurityConfig)this.buildConfigObject(SecurityConfig.class)).getSecuritySystem().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ConfigurationAwareModule.combine((Module[])new Module[]{new AllowAllSecurityModule(), new StaticAccessControlMetadataModule(), HiveSecurityModule.usingSystemSecurity(false)});
            case 1 -> ConfigurationAwareModule.combine((Module[])new Module[]{new ReadOnlySecurityModule(), new StaticAccessControlMetadataModule(), HiveSecurityModule.usingSystemSecurity(false)});
            case 2 -> ConfigurationAwareModule.combine((Module[])new Module[]{new FileBasedAccessControlModule(), new StaticAccessControlMetadataModule(), HiveSecurityModule.usingSystemSecurity(false)});
            case 3 -> ConfigurationAwareModule.combine((Module[])new Module[]{new SqlStandardSecurityModule(), HiveSecurityModule.usingSystemSecurity(false)});
            case 4 -> ConfigurationAwareModule.combine((Module[])new Module[]{new StaticAccessControlMetadataModule(), HiveSecurityModule.usingSystemSecurity(true)});
        });
    }

    private static Module usingSystemSecurity(boolean system) {
        return binder -> binder.bind(Boolean.TYPE).annotatedWith(UsingSystemSecurity.class).toInstance((Object)system);
    }

    public static enum HiveSecurity {
        ALLOW_ALL,
        READ_ONLY,
        FILE,
        SQL_STANDARD,
        SYSTEM;

    }

    private static class StaticAccessControlMetadataModule
    implements Module {
        private StaticAccessControlMetadataModule() {
        }

        public void configure(Binder binder) {
            binder.bind(AccessControlMetadataFactory.class).toInstance(sqlStandardAccessControlMetadataMetastore -> new AccessControlMetadata(this){});
        }
    }
}

