/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.trino.hive.formats.UnionToRowCoercionUtils;
import io.trino.metastore.HiveType;
import io.trino.metastore.type.CharTypeInfo;
import io.trino.metastore.type.DecimalTypeInfo;
import io.trino.metastore.type.ListTypeInfo;
import io.trino.metastore.type.MapTypeInfo;
import io.trino.metastore.type.PrimitiveCategory;
import io.trino.metastore.type.PrimitiveTypeInfo;
import io.trino.metastore.type.StructTypeInfo;
import io.trino.metastore.type.TypeInfo;
import io.trino.metastore.type.TypeInfoFactory;
import io.trino.metastore.type.UnionTypeInfo;
import io.trino.metastore.type.VarcharTypeInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public final class HiveTypeTranslator {
    private HiveTypeTranslator() {
    }

    public static HiveType toHiveType(Type type) {
        return HiveType.fromTypeInfo((TypeInfo)HiveTypeTranslator.toTypeInfo(type));
    }

    private static TypeInfo toTypeInfo(Type type) {
        Objects.requireNonNull(type, "type is null");
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return HiveType.HIVE_BOOLEAN.getTypeInfo();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return HiveType.HIVE_LONG.getTypeInfo();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return HiveType.HIVE_INT.getTypeInfo();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return HiveType.HIVE_SHORT.getTypeInfo();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return HiveType.HIVE_BYTE.getTypeInfo();
        }
        if (RealType.REAL.equals((Object)type)) {
            return HiveType.HIVE_FLOAT.getTypeInfo();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return HiveType.HIVE_DOUBLE.getTypeInfo();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return HiveType.HIVE_STRING.getTypeInfo();
            }
            if (varcharType.getBoundedLength() <= 65535) {
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharType.getBoundedLength());
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported VARCHAR types: VARCHAR(<=%d), VARCHAR.", type, 65535));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            if (charLength <= 255) {
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported CHAR types: CHAR(<=%d).", type, 255));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return HiveType.HIVE_BINARY.getTypeInfo();
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveType.HIVE_DATE.getTypeInfo();
        }
        if (type instanceof TimestampType) {
            return HiveType.HIVE_TIMESTAMP.getTypeInfo();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            TypeInfo elementType = HiveTypeTranslator.toTypeInfo(arrayType.getElementType());
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            TypeInfo keyType = HiveTypeTranslator.toTypeInfo(mapType.getKeyType());
            TypeInfo valueType = HiveTypeTranslator.toTypeInfo(mapType.getValueType());
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType, (TypeInfo)valueType);
        }
        if (type instanceof RowType) {
            ImmutableList.Builder fieldNames = ImmutableList.builder();
            for (TypeSignatureParameter parameter : type.getTypeSignature().getParameters()) {
                if (!parameter.isNamedTypeSignature()) {
                    throw new IllegalArgumentException(String.format("Expected all parameters to be named type, but got %s", parameter));
                }
                fieldNames.add((Object)((String)parameter.getNamedTypeSignature().getName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Anonymous row type is not supported in Hive. Please give each field a name: %s", type)))));
            }
            return TypeInfoFactory.getStructTypeInfo((List)fieldNames.build(), (List)((List)type.getTypeParameters().stream().map(HiveTypeTranslator::toTypeInfo).collect(ImmutableList.toImmutableList())));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
    }

    public static TypeSignature toTypeSignature(TypeInfo typeInfo, HiveTimestampPrecision timestampPrecision) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                Type primitiveType = HiveTypeTranslator.fromPrimitiveType((PrimitiveTypeInfo)typeInfo, timestampPrecision);
                if (primitiveType == null) break;
                return primitiveType.getTypeSignature();
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return TypeSignature.mapType((TypeSignature)HiveTypeTranslator.toTypeSignature(mapTypeInfo.getMapKeyTypeInfo(), timestampPrecision), (TypeSignature)HiveTypeTranslator.toTypeSignature(mapTypeInfo.getMapValueTypeInfo(), timestampPrecision));
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                TypeSignature elementType = HiveTypeTranslator.toTypeSignature(listTypeInfo.getListElementTypeInfo(), timestampPrecision);
                return TypeSignature.arrayType((TypeSignatureParameter)TypeSignatureParameter.typeParameter((TypeSignature)elementType));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                List fieldTypes = structTypeInfo.getAllStructFieldTypeInfos();
                List fieldNames = structTypeInfo.getAllStructFieldNames();
                if (fieldTypes.size() != fieldNames.size()) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid Hive struct type: %s", typeInfo));
                }
                return TypeSignature.rowType(Streams.zip(fieldNames.stream().map(s -> s.toLowerCase(Locale.US)), fieldTypes.stream().map(type -> HiveTypeTranslator.toTypeSignature(type, timestampPrecision)), TypeSignatureParameter::namedField).collect(Collectors.toList()));
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List unionObjectTypes = unionTypeInfo.getAllUnionObjectTypeInfos();
                return UnionToRowCoercionUtils.rowTypeSignatureForUnionOfTypes((List)((List)unionObjectTypes.stream().map(unionObjectType -> HiveTypeTranslator.toTypeSignature(unionObjectType, timestampPrecision)).collect(ImmutableList.toImmutableList())));
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", typeInfo));
    }

    @Deprecated
    @Nullable
    public static Type fromPrimitiveType(PrimitiveTypeInfo typeInfo) {
        return HiveTypeTranslator.fromPrimitiveType(typeInfo, HiveTimestampPrecision.DEFAULT_PRECISION);
    }

    @Nullable
    private static Type fromPrimitiveType(PrimitiveTypeInfo typeInfo, HiveTimestampPrecision timestampPrecision) {
        return switch (typeInfo.getPrimitiveCategory()) {
            case PrimitiveCategory.BOOLEAN -> BooleanType.BOOLEAN;
            case PrimitiveCategory.BYTE -> TinyintType.TINYINT;
            case PrimitiveCategory.SHORT -> SmallintType.SMALLINT;
            case PrimitiveCategory.INT -> IntegerType.INTEGER;
            case PrimitiveCategory.LONG -> BigintType.BIGINT;
            case PrimitiveCategory.FLOAT -> RealType.REAL;
            case PrimitiveCategory.DOUBLE -> DoubleType.DOUBLE;
            case PrimitiveCategory.STRING -> VarcharType.createUnboundedVarcharType();
            case PrimitiveCategory.VARCHAR -> VarcharType.createVarcharType((int)((VarcharTypeInfo)typeInfo).getLength());
            case PrimitiveCategory.CHAR -> CharType.createCharType((int)((CharTypeInfo)typeInfo).getLength());
            case PrimitiveCategory.DATE -> DateType.DATE;
            case PrimitiveCategory.TIMESTAMP -> TimestampType.createTimestampType((int)timestampPrecision.getPrecision());
            case PrimitiveCategory.TIMESTAMPLOCALTZ -> TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)timestampPrecision.getPrecision());
            case PrimitiveCategory.BINARY -> VarbinaryType.VARBINARY;
            case PrimitiveCategory.DECIMAL -> {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                yield DecimalType.createDecimalType((int)decimalTypeInfo.precision(), (int)decimalTypeInfo.scale());
            }
            default -> null;
        };
    }
}

