/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.trino.plugin.hive.util.SortBuffer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MergingPageIterator
extends AbstractIterator<Page> {
    private final List<Integer> sortFields;
    private final List<MethodHandle> orderingOperators;
    private final PageBuilder pageBuilder;
    private final Iterator<PagePosition> pagePositions;

    public MergingPageIterator(Collection<Iterator<Page>> iterators, List<Type> types, List<Integer> sortFields, List<SortOrder> sortOrders, TypeOperators typeOperators) {
        Objects.requireNonNull(sortFields, "sortFields is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        Preconditions.checkArgument((sortFields.size() == sortOrders.size() ? 1 : 0) != 0, (Object)"sortFields and sortOrders size must match");
        this.sortFields = ImmutableList.copyOf(sortFields);
        ImmutableList.Builder orderingOperators = ImmutableList.builder();
        for (int index = 0; index < sortFields.size(); ++index) {
            Type type = types.get(sortFields.get(index));
            SortOrder sortOrder = sortOrders.get(index);
            orderingOperators.add((Object)typeOperators.getOrderingOperator(type, sortOrder, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION})));
        }
        this.orderingOperators = orderingOperators.build();
        this.pageBuilder = new PageBuilder(types);
        this.pagePositions = Iterators.mergeSorted((Iterable)iterators.stream().map(pages -> Iterators.concat((Iterator)Iterators.transform((Iterator)pages, x$0 -> new PagePositionIterator((Page)x$0)))).collect(Collectors.toList()), Comparator.naturalOrder());
    }

    protected Page computeNext() {
        while (!this.pageBuilder.isFull() && this.pagePositions.hasNext()) {
            this.pagePositions.next().appendTo(this.pageBuilder);
        }
        if (this.pageBuilder.isEmpty()) {
            return (Page)this.endOfData();
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private class PagePosition
    implements Comparable<PagePosition> {
        private final Page page;
        private final int position;

        public PagePosition(Page page, int position) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.position = position;
        }

        public void appendTo(PageBuilder pageBuilder) {
            SortBuffer.appendPositionTo(this.page, this.position, pageBuilder);
        }

        public int hashCode() {
            throw new UnsupportedOperationException("equality checks are not supported, use compareTo");
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException("equality checks are not supported, use compareTo");
        }

        @Override
        public int compareTo(PagePosition other) {
            try {
                for (int i = 0; i < MergingPageIterator.this.sortFields.size(); ++i) {
                    Block otherBlock;
                    Block block;
                    int channel = MergingPageIterator.this.sortFields.get(i);
                    MethodHandle orderingOperator = MergingPageIterator.this.orderingOperators.get(i);
                    int result = orderingOperator.invokeExact(block = this.page.getBlock(channel), this.position, otherBlock = other.page.getBlock(channel), other.position);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
            }
        }
    }

    private class PagePositionIterator
    extends AbstractIterator<PagePosition> {
        private final Page page;
        private int position = -1;

        private PagePositionIterator(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        protected PagePosition computeNext() {
            ++this.position;
            if (this.position == this.page.getPositionCount()) {
                return (PagePosition)this.endOfData();
            }
            return new PagePosition(this.page, this.position);
        }
    }
}

