/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import io.trino.metastore.BooleanStatistics;
import io.trino.metastore.DateStatistics;
import io.trino.metastore.DecimalStatistics;
import io.trino.metastore.DoubleStatistics;
import io.trino.metastore.IntegerStatistics;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

@Immutable
public class HiveColumnStatistics {
    private static final HiveColumnStatistics EMPTY = HiveColumnStatistics.builder().build();
    private final Optional<IntegerStatistics> integerStatistics;
    private final Optional<DoubleStatistics> doubleStatistics;
    private final Optional<DecimalStatistics> decimalStatistics;
    private final Optional<DateStatistics> dateStatistics;
    private final Optional<BooleanStatistics> booleanStatistics;
    private final OptionalLong maxValueSizeInBytes;
    private final OptionalDouble averageColumnLength;
    private final OptionalLong nullsCount;
    private final OptionalLong distinctValuesWithNullCount;

    public static HiveColumnStatistics empty() {
        return EMPTY;
    }

    @JsonCreator
    public HiveColumnStatistics(@JsonProperty(value="integerStatistics") Optional<IntegerStatistics> integerStatistics, @JsonProperty(value="doubleStatistics") Optional<DoubleStatistics> doubleStatistics, @JsonProperty(value="decimalStatistics") Optional<DecimalStatistics> decimalStatistics, @JsonProperty(value="dateStatistics") Optional<DateStatistics> dateStatistics, @JsonProperty(value="booleanStatistics") Optional<BooleanStatistics> booleanStatistics, @JsonProperty(value="maxValueSizeInBytes") OptionalLong maxValueSizeInBytes, @JsonProperty(value="averageColumnLength") OptionalDouble averageColumnLength, @JsonProperty(value="nullsCount") OptionalLong nullsCount, @JsonProperty(value="distinctValuesWithNullCount") OptionalLong distinctValuesWithNullCount) {
        this.integerStatistics = Objects.requireNonNull(integerStatistics, "integerStatistics is null");
        this.doubleStatistics = Objects.requireNonNull(doubleStatistics, "doubleStatistics is null");
        this.decimalStatistics = Objects.requireNonNull(decimalStatistics, "decimalStatistics is null");
        this.dateStatistics = Objects.requireNonNull(dateStatistics, "dateStatistics is null");
        this.booleanStatistics = Objects.requireNonNull(booleanStatistics, "booleanStatistics is null");
        this.maxValueSizeInBytes = Objects.requireNonNull(maxValueSizeInBytes, "maxValueSizeInBytes is null");
        this.averageColumnLength = Objects.requireNonNull(averageColumnLength, "averageColumnLength is null");
        this.nullsCount = Objects.requireNonNull(nullsCount, "nullsCount is null");
        this.distinctValuesWithNullCount = Objects.requireNonNull(distinctValuesWithNullCount, "distinctValuesWithNullCount is null");
        ArrayList presentStatistics = new ArrayList();
        integerStatistics.ifPresent(s -> presentStatistics.add("integerStatistics"));
        doubleStatistics.ifPresent(s -> presentStatistics.add("doubleStatistics"));
        decimalStatistics.ifPresent(s -> presentStatistics.add("decimalStatistics"));
        dateStatistics.ifPresent(s -> presentStatistics.add("dateStatistics"));
        booleanStatistics.ifPresent(s -> presentStatistics.add("booleanStatistics"));
        Preconditions.checkArgument((presentStatistics.size() <= 1 ? 1 : 0) != 0, (String)"multiple type specific statistic objects are present: %s", presentStatistics);
    }

    @JsonProperty
    public Optional<IntegerStatistics> getIntegerStatistics() {
        return this.integerStatistics;
    }

    @JsonProperty
    public Optional<DoubleStatistics> getDoubleStatistics() {
        return this.doubleStatistics;
    }

    @JsonProperty
    public Optional<DecimalStatistics> getDecimalStatistics() {
        return this.decimalStatistics;
    }

    @JsonProperty
    public Optional<DateStatistics> getDateStatistics() {
        return this.dateStatistics;
    }

    @JsonProperty
    public Optional<BooleanStatistics> getBooleanStatistics() {
        return this.booleanStatistics;
    }

    @JsonProperty
    public OptionalLong getMaxValueSizeInBytes() {
        return this.maxValueSizeInBytes;
    }

    @JsonProperty
    public OptionalDouble getAverageColumnLength() {
        return this.averageColumnLength;
    }

    @JsonProperty
    public OptionalLong getNullsCount() {
        return this.nullsCount;
    }

    @JsonProperty
    public OptionalLong getDistinctValuesWithNullCount() {
        return this.distinctValuesWithNullCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveColumnStatistics that = (HiveColumnStatistics)o;
        return Objects.equals(this.integerStatistics, that.integerStatistics) && Objects.equals(this.doubleStatistics, that.doubleStatistics) && Objects.equals(this.decimalStatistics, that.decimalStatistics) && Objects.equals(this.dateStatistics, that.dateStatistics) && Objects.equals(this.booleanStatistics, that.booleanStatistics) && Objects.equals(this.maxValueSizeInBytes, that.maxValueSizeInBytes) && Objects.equals(this.averageColumnLength, that.averageColumnLength) && Objects.equals(this.nullsCount, that.nullsCount) && Objects.equals(this.distinctValuesWithNullCount, that.distinctValuesWithNullCount);
    }

    public int hashCode() {
        return Objects.hash(this.integerStatistics, this.doubleStatistics, this.decimalStatistics, this.dateStatistics, this.booleanStatistics, this.maxValueSizeInBytes, this.averageColumnLength, this.nullsCount, this.distinctValuesWithNullCount);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        this.integerStatistics.ifPresent(stats -> toStringHelper.add("integerStatistics", stats));
        this.doubleStatistics.ifPresent(stats -> toStringHelper.add("doubleStatistics", stats));
        this.decimalStatistics.ifPresent(stats -> toStringHelper.add("decimalStatistics", stats));
        this.dateStatistics.ifPresent(stats -> toStringHelper.add("dateStatistics", stats));
        this.booleanStatistics.ifPresent(stats -> toStringHelper.add("booleanStatistics", stats));
        this.maxValueSizeInBytes.ifPresent(stats -> toStringHelper.add("maxValueSizeInBytes", stats));
        this.averageColumnLength.ifPresent(stats -> toStringHelper.add("averageColumnLength", stats));
        this.nullsCount.ifPresent(stats -> toStringHelper.add("nullsCount", stats));
        this.distinctValuesWithNullCount.ifPresent(stats -> toStringHelper.add("distinctValuesWithNullCount", stats));
        return toStringHelper.toString();
    }

    public static HiveColumnStatistics createIntegerColumnStatistics(OptionalLong min, OptionalLong max, OptionalLong nullsCount, OptionalLong distinctValuesWithNullCount) {
        return HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(min, max)).setNullsCount(nullsCount).setDistinctValuesWithNullCount(distinctValuesWithNullCount).build();
    }

    public static HiveColumnStatistics createDoubleColumnStatistics(OptionalDouble min, OptionalDouble max, OptionalLong nullsCount, OptionalLong distinctValuesWithNullCount) {
        return HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(min, max)).setNullsCount(nullsCount).setDistinctValuesWithNullCount(distinctValuesWithNullCount).build();
    }

    public static HiveColumnStatistics createDecimalColumnStatistics(Optional<BigDecimal> min, Optional<BigDecimal> max, OptionalLong nullsCount, OptionalLong distinctValuesWithNullCount) {
        return HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(min, max)).setNullsCount(nullsCount).setDistinctValuesWithNullCount(distinctValuesWithNullCount).build();
    }

    public static HiveColumnStatistics createDateColumnStatistics(Optional<LocalDate> min, Optional<LocalDate> max, OptionalLong nullsCount, OptionalLong distinctValuesWithNullCount) {
        return HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(min, max)).setNullsCount(nullsCount).setDistinctValuesWithNullCount(distinctValuesWithNullCount).build();
    }

    public static HiveColumnStatistics createBooleanColumnStatistics(OptionalLong trueCount, OptionalLong falseCount, OptionalLong nullsCount) {
        return HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(trueCount, falseCount)).setNullsCount(nullsCount).build();
    }

    public static HiveColumnStatistics createStringColumnStatistics(OptionalLong maxValueSizeInBytes, OptionalDouble averageColumnLength, OptionalLong nullsCount, OptionalLong distinctValuesWithNullCount) {
        return HiveColumnStatistics.builder().setMaxValueSizeInBytes(maxValueSizeInBytes).setAverageColumnLength(averageColumnLength).setNullsCount(nullsCount).setDistinctValuesWithNullCount(distinctValuesWithNullCount).build();
    }

    public static HiveColumnStatistics createBinaryColumnStatistics(OptionalLong maxValueSizeInBytes, OptionalDouble averageColumnLength, OptionalLong nullsCount) {
        return HiveColumnStatistics.builder().setMaxValueSizeInBytes(maxValueSizeInBytes).setAverageColumnLength(averageColumnLength).setNullsCount(nullsCount).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<IntegerStatistics> integerStatistics = Optional.empty();
        private Optional<DoubleStatistics> doubleStatistics = Optional.empty();
        private Optional<DecimalStatistics> decimalStatistics = Optional.empty();
        private Optional<DateStatistics> dateStatistics = Optional.empty();
        private Optional<BooleanStatistics> booleanStatistics = Optional.empty();
        private OptionalLong maxValueSizeInBytes = OptionalLong.empty();
        private OptionalDouble averageColumnLength = OptionalDouble.empty();
        private OptionalLong nullsCount = OptionalLong.empty();
        private OptionalLong distinctValuesWithNullCount = OptionalLong.empty();

        private Builder() {
        }

        public Builder setIntegerStatistics(IntegerStatistics integerStatistics) {
            this.integerStatistics = Optional.of(integerStatistics);
            return this;
        }

        public Builder setDoubleStatistics(DoubleStatistics doubleStatistics) {
            this.doubleStatistics = Optional.of(doubleStatistics);
            return this;
        }

        public Builder setDecimalStatistics(DecimalStatistics decimalStatistics) {
            this.decimalStatistics = Optional.of(decimalStatistics);
            return this;
        }

        public Builder setDateStatistics(DateStatistics dateStatistics) {
            this.dateStatistics = Optional.of(dateStatistics);
            return this;
        }

        public Builder setBooleanStatistics(BooleanStatistics booleanStatistics) {
            this.booleanStatistics = Optional.of(booleanStatistics);
            return this;
        }

        public Builder setMaxValueSizeInBytes(long maxValueSizeInBytes) {
            this.maxValueSizeInBytes = OptionalLong.of(maxValueSizeInBytes);
            return this;
        }

        public Builder setMaxValueSizeInBytes(OptionalLong maxValueSizeInBytes) {
            this.maxValueSizeInBytes = maxValueSizeInBytes;
            return this;
        }

        public Builder setAverageColumnLength(double averageColumnLength) {
            this.averageColumnLength = OptionalDouble.of(averageColumnLength);
            return this;
        }

        public Builder setAverageColumnLength(OptionalDouble averageColumnLength) {
            this.averageColumnLength = averageColumnLength;
            return this;
        }

        public Builder setNullsCount(OptionalLong nullsCount) {
            this.nullsCount = nullsCount;
            return this;
        }

        public Builder setNullsCount(long nullsCount) {
            this.nullsCount = OptionalLong.of(nullsCount);
            return this;
        }

        public Builder setDistinctValuesWithNullCount(OptionalLong distinctValuesWithNullCount) {
            this.distinctValuesWithNullCount = distinctValuesWithNullCount;
            return this;
        }

        public Builder setDistinctValuesWithNullCount(long distinctValuesWithNullCount) {
            this.distinctValuesWithNullCount = OptionalLong.of(distinctValuesWithNullCount);
            return this;
        }

        public HiveColumnStatistics build() {
            return new HiveColumnStatistics(this.integerStatistics, this.doubleStatistics, this.decimalStatistics, this.dateStatistics, this.booleanStatistics, this.maxValueSizeInBytes, this.averageColumnLength, this.nullsCount, this.distinctValuesWithNullCount);
        }
    }
}

