/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.airlift.slice.SizeOf;
import io.trino.metastore.HiveType;
import java.util.Objects;

public final class HiveTypeName {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(HiveTypeName.class);
    private final String value;

    @JsonCreator
    public HiveTypeName(String value) {
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    public HiveType toHiveType() {
        return HiveType.valueOf(this.value);
    }

    public long getEstimatedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTypeName that = (HiveTypeName)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

