/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.google.common.collect.ImmutableMap;
import io.trino.metastore.HiveBasicStatistics;
import io.trino.metastore.HiveColumnStatistics;
import java.util.Map;
import java.util.Objects;

public record PartitionStatistics(HiveBasicStatistics basicStatistics, Map<String, HiveColumnStatistics> columnStatistics) {
    private static final PartitionStatistics EMPTY = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of());

    public PartitionStatistics {
        Objects.requireNonNull(basicStatistics, "basicStatistics is null");
        columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics cannot be null"));
    }

    public static PartitionStatistics empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public PartitionStatistics withBasicStatistics(HiveBasicStatistics basicStatistics) {
        return new PartitionStatistics(basicStatistics, this.columnStatistics);
    }

    public static class Builder {
        private HiveBasicStatistics basicStatistics = HiveBasicStatistics.createEmptyStatistics();
        private Map<String, HiveColumnStatistics> columnStatistics = ImmutableMap.of();

        public Builder setBasicStatistics(HiveBasicStatistics basicStatistics) {
            this.basicStatistics = Objects.requireNonNull(basicStatistics, "basicStatistics is null");
            return this;
        }

        public Builder setColumnStatistics(Map<String, HiveColumnStatistics> columnStatistics) {
            this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
            return this;
        }

        public PartitionStatistics build() {
            return new PartitionStatistics(this.basicStatistics, this.columnStatistics);
        }
    }
}

