/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore.cache;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.metastore.Partitions;
import io.trino.metastore.cache.HiveTableName;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class HivePartitionName {
    private final HiveTableName hiveTableName;
    private final List<String> partitionValues;
    private final Optional<String> partitionName;

    @JsonCreator
    public HivePartitionName(@JsonProperty(value="hiveTableName") HiveTableName hiveTableName, @JsonProperty(value="partitionValues") List<String> partitionValues, @JsonProperty(value="partitionName") Optional<String> partitionName) {
        this.hiveTableName = Objects.requireNonNull(hiveTableName, "hiveTableName is null");
        this.partitionValues = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionValues, "partitionValues is null"));
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
    }

    public static HivePartitionName hivePartitionName(HiveTableName hiveTableName, String partitionName) {
        return new HivePartitionName(hiveTableName, Partitions.toPartitionValues(partitionName), Optional.of(partitionName));
    }

    public static HivePartitionName hivePartitionName(HiveTableName hiveTableName, List<String> partitionValues) {
        return new HivePartitionName(hiveTableName, partitionValues, Optional.empty());
    }

    @JsonProperty
    public HiveTableName getHiveTableName() {
        return this.hiveTableName;
    }

    @JsonProperty
    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonProperty
    public Optional<String> getPartitionName() {
        return this.partitionName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("partitionValues", this.partitionValues).add("partitionName", this.partitionName).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePartitionName other = (HivePartitionName)o;
        return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.partitionValues, other.partitionValues);
    }

    public int hashCode() {
        return Objects.hash(this.hiveTableName, this.partitionValues);
    }
}

