/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.metastore.type.Category;
import io.trino.metastore.type.TypeInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public final class StructTypeInfo
extends TypeInfo {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(StructTypeInfo.class);
    private final List<String> names;
    private final List<TypeInfo> typeInfos;

    StructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        this.names = ImmutableList.copyOf((Collection)Objects.requireNonNull(names, "names is null"));
        this.typeInfos = ImmutableList.copyOf((Collection)Objects.requireNonNull(typeInfos, "typeInfos is null"));
        Preconditions.checkArgument((names.size() == typeInfos.size() ? 1 : 0) != 0, (Object)"mismatched sizes");
    }

    @Override
    public String getTypeName() {
        StringJoiner joiner = new StringJoiner(",", "struct<", ">");
        for (int i = 0; i < this.names.size(); ++i) {
            joiner.add(this.names.get(i) + ":" + this.typeInfos.get(i).getTypeName());
        }
        return joiner.toString();
    }

    @Override
    public Category getCategory() {
        return Category.STRUCT;
    }

    public List<String> getAllStructFieldNames() {
        return this.names;
    }

    public List<TypeInfo> getAllStructFieldTypeInfos() {
        return this.typeInfos;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructTypeInfo)) {
            return false;
        }
        StructTypeInfo o = (StructTypeInfo)other;
        Iterator<String> namesIterator = this.getAllStructFieldNames().iterator();
        Iterator<String> otherNamesIterator = o.getAllStructFieldNames().iterator();
        while (namesIterator.hasNext() && otherNamesIterator.hasNext()) {
            if (namesIterator.next().equalsIgnoreCase(otherNamesIterator.next())) continue;
            return false;
        }
        if (namesIterator.hasNext() || otherNamesIterator.hasNext()) {
            return false;
        }
        return o.getAllStructFieldTypeInfos().equals(this.getAllStructFieldTypeInfos());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.names, this.typeInfos);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.names, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.typeInfos, TypeInfo::getRetainedSizeInBytes);
    }
}

