/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.MoreObjects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MostAvailableFirstPolicy
implements BlockLocationPolicy {
    public MostAvailableFirstPolicy(AlluxioConfiguration ignoredConf) {
    }

    @Override
    public Optional<WorkerNetAddress> getWorker(GetWorkerOptions options) {
        long mostAvailableBytes = -1L;
        WorkerNetAddress result = null;
        for (BlockWorkerInfo workerInfo : options.getBlockWorkerInfos()) {
            if (workerInfo.getCapacityBytes() - workerInfo.getUsedBytes() <= mostAvailableBytes) continue;
            mostAvailableBytes = workerInfo.getCapacityBytes() - workerInfo.getUsedBytes();
            result = workerInfo.getNetAddress();
        }
        return Optional.ofNullable(result);
    }

    public boolean equals(Object o) {
        return o instanceof MostAvailableFirstPolicy;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

