/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.grpc.DataMessageMarshaller;
import alluxio.grpc.DataMessageMarshallerProvider;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DataMessageClientResponseObserver<ReqT, RespT>
extends DataMessageMarshallerProvider<ReqT, RespT>
implements ClientResponseObserver<ReqT, RespT> {
    private static final Logger LOG = LoggerFactory.getLogger(DataMessageClientResponseObserver.class);
    private final StreamObserver<RespT> mObserver;

    public DataMessageClientResponseObserver(StreamObserver<RespT> observer, DataMessageMarshaller<ReqT> requestMarshaller, DataMessageMarshaller<RespT> responseMarshaller) {
        super(requestMarshaller, responseMarshaller);
        Objects.requireNonNull(observer);
        this.mObserver = observer;
    }

    public void onNext(RespT value) {
        this.mObserver.onNext(value);
    }

    public void onError(Throwable t) {
        this.mObserver.onError(t);
    }

    public void onCompleted() {
        this.mObserver.onCompleted();
    }

    public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
        if (this.mObserver instanceof ClientResponseObserver) {
            ((ClientResponseObserver)this.mObserver).beforeStart(requestStream);
        } else {
            LOG.warn("{} does not implement ClientResponseObserver:beforeStart", this.mObserver);
        }
    }
}

