/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.block.stream.StreamSerializationClientInterceptor;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.BlockWorkerGrpc;
import alluxio.grpc.CacheRequest;
import alluxio.grpc.ClearMetricsRequest;
import alluxio.grpc.ClearMetricsResponse;
import alluxio.grpc.CreateLocalBlockRequest;
import alluxio.grpc.CreateLocalBlockResponse;
import alluxio.grpc.DataMessageMarshaller;
import alluxio.grpc.DataMessageMarshallerProvider;
import alluxio.grpc.FreeWorkerRequest;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelBuilder;
import alluxio.grpc.GrpcNetworkGroup;
import alluxio.grpc.GrpcSerializationUtils;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.LoadRequest;
import alluxio.grpc.LoadResponse;
import alluxio.grpc.MoveBlockRequest;
import alluxio.grpc.MoveBlockResponse;
import alluxio.grpc.OpenLocalBlockRequest;
import alluxio.grpc.OpenLocalBlockResponse;
import alluxio.grpc.ReadRequest;
import alluxio.grpc.ReadResponse;
import alluxio.grpc.RemoveBlockRequest;
import alluxio.grpc.RemoveBlockResponse;
import alluxio.grpc.WriteRequest;
import alluxio.grpc.WriteResponse;
import alluxio.resource.AlluxioResourceLeakDetectorFactory;
import alluxio.retry.RetryPolicy;
import alluxio.retry.RetryUtils;
import alluxio.security.user.UserState;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBlockWorkerClient
implements BlockWorkerClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)DefaultBlockWorkerClient.class.getName());
    private static final ResourceLeakDetector<DefaultBlockWorkerClient> DETECTOR = AlluxioResourceLeakDetectorFactory.instance().newResourceLeakDetector(DefaultBlockWorkerClient.class);
    private GrpcChannel mStreamingChannel;
    private GrpcChannel mRpcChannel;
    private final GrpcServerAddress mAddress;
    private final long mRpcTimeoutMs;
    private final BlockWorkerGrpc.BlockWorkerStub mStreamingAsyncStub;
    private final BlockWorkerGrpc.BlockWorkerBlockingStub mRpcBlockingStub;
    private final BlockWorkerGrpc.BlockWorkerFutureStub mRpcFutureStub;
    @Nullable
    private final ResourceLeakTracker<DefaultBlockWorkerClient> mTracker;

    public DefaultBlockWorkerClient(UserState userState, GrpcServerAddress address, AlluxioConfiguration alluxioConf) throws IOException {
        RetryPolicy retryPolicy = RetryUtils.defaultClientRetry();
        UnauthenticatedException lastException = null;
        while (retryPolicy.attempt()) {
            try {
                this.mStreamingChannel = GrpcChannelBuilder.newBuilder((GrpcServerAddress)address, (AlluxioConfiguration)alluxioConf).setSubject(userState.getSubject()).setNetworkGroup(GrpcNetworkGroup.STREAMING).build();
                this.mStreamingChannel.intercept((ClientInterceptor)new StreamSerializationClientInterceptor());
                this.mRpcChannel = GrpcChannelBuilder.newBuilder((GrpcServerAddress)address, (AlluxioConfiguration)alluxioConf).setSubject(userState.getSubject()).setNetworkGroup(GrpcNetworkGroup.RPC).build();
                lastException = null;
                break;
            }
            catch (StatusRuntimeException e) {
                this.close();
                throw AlluxioStatusException.fromStatusRuntimeException((StatusRuntimeException)e);
            }
            catch (UnauthenticatedException e) {
                this.close();
                userState.relogin();
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        this.mStreamingAsyncStub = BlockWorkerGrpc.newStub((Channel)this.mStreamingChannel);
        this.mRpcBlockingStub = BlockWorkerGrpc.newBlockingStub((Channel)this.mRpcChannel);
        this.mRpcFutureStub = BlockWorkerGrpc.newFutureStub((Channel)this.mRpcChannel);
        this.mAddress = address;
        this.mRpcTimeoutMs = alluxioConf.getMs(PropertyKey.USER_RPC_RETRY_MAX_DURATION);
        this.mTracker = DETECTOR.track((Object)this);
    }

    @Override
    public boolean isShutdown() {
        return this.mStreamingChannel.isShutdown() || this.mRpcChannel.isShutdown();
    }

    @Override
    public boolean isHealthy() {
        return !this.isShutdown() && this.mStreamingChannel.isHealthy() && this.mRpcChannel.isHealthy();
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> {
                if (this.mStreamingChannel != null) {
                    this.mStreamingChannel.shutdown();
                }
            });
            closer.register(() -> {
                if (this.mRpcChannel != null) {
                    this.mRpcChannel.shutdown();
                }
            });
            closer.register(() -> {
                if (this.mTracker != null) {
                    this.mTracker.close((Object)this);
                }
            });
        }
    }

    @Override
    public StreamObserver<WriteRequest> writeBlock(StreamObserver<WriteResponse> responseObserver) {
        if (responseObserver instanceof DataMessageMarshallerProvider) {
            DataMessageMarshaller marshaller = (DataMessageMarshaller)((DataMessageMarshallerProvider)responseObserver).getRequestMarshaller().orElseThrow(NullPointerException::new);
            return ((BlockWorkerGrpc.BlockWorkerStub)this.mStreamingAsyncStub.withOption(GrpcSerializationUtils.OVERRIDDEN_METHOD_DESCRIPTOR, (Object)BlockWorkerGrpc.getWriteBlockMethod().toBuilder().setRequestMarshaller((MethodDescriptor.Marshaller)marshaller).build())).writeBlock(responseObserver);
        }
        return this.mStreamingAsyncStub.writeBlock(responseObserver);
    }

    @Override
    public StreamObserver<ReadRequest> readBlock(StreamObserver<ReadResponse> responseObserver) {
        if (responseObserver instanceof DataMessageMarshallerProvider) {
            DataMessageMarshaller marshaller = (DataMessageMarshaller)((DataMessageMarshallerProvider)responseObserver).getResponseMarshaller().orElseThrow(NullPointerException::new);
            return ((BlockWorkerGrpc.BlockWorkerStub)this.mStreamingAsyncStub.withOption(GrpcSerializationUtils.OVERRIDDEN_METHOD_DESCRIPTOR, (Object)BlockWorkerGrpc.getReadBlockMethod().toBuilder().setResponseMarshaller((MethodDescriptor.Marshaller)marshaller).build())).readBlock(responseObserver);
        }
        return this.mStreamingAsyncStub.readBlock(responseObserver);
    }

    @Override
    public StreamObserver<CreateLocalBlockRequest> createLocalBlock(StreamObserver<CreateLocalBlockResponse> responseObserver) {
        return this.mStreamingAsyncStub.createLocalBlock(responseObserver);
    }

    @Override
    public StreamObserver<OpenLocalBlockRequest> openLocalBlock(StreamObserver<OpenLocalBlockResponse> responseObserver) {
        return this.mStreamingAsyncStub.openLocalBlock(responseObserver);
    }

    @Override
    public RemoveBlockResponse removeBlock(RemoveBlockRequest request) {
        return ((BlockWorkerGrpc.BlockWorkerBlockingStub)this.mRpcBlockingStub.withDeadlineAfter(this.mRpcTimeoutMs, TimeUnit.MILLISECONDS)).removeBlock(request);
    }

    @Override
    public MoveBlockResponse moveBlock(MoveBlockRequest request) {
        return ((BlockWorkerGrpc.BlockWorkerBlockingStub)this.mRpcBlockingStub.withDeadlineAfter(this.mRpcTimeoutMs, TimeUnit.MILLISECONDS)).moveBlock(request);
    }

    @Override
    public ClearMetricsResponse clearMetrics(ClearMetricsRequest request) {
        return ((BlockWorkerGrpc.BlockWorkerBlockingStub)this.mRpcBlockingStub.withDeadlineAfter(this.mRpcTimeoutMs, TimeUnit.MILLISECONDS)).clearMetrics(request);
    }

    @Override
    public void cache(CacheRequest request) {
        boolean async = request.getAsync();
        try {
            ((BlockWorkerGrpc.BlockWorkerBlockingStub)this.mRpcBlockingStub.withDeadlineAfter(this.mRpcTimeoutMs, TimeUnit.MILLISECONDS)).cache(request);
        }
        catch (Exception e) {
            if (!async) {
                throw e;
            }
            LOG.warn("Error sending async cache request {} to worker {}.", new Object[]{request, this.mAddress, e});
        }
    }

    @Override
    public void freeWorker() {
        ((BlockWorkerGrpc.BlockWorkerBlockingStub)this.mRpcBlockingStub.withDeadlineAfter(this.mRpcTimeoutMs, TimeUnit.MILLISECONDS)).freeWorker(FreeWorkerRequest.getDefaultInstance());
    }

    @Override
    public ListenableFuture<LoadResponse> load(LoadRequest request) {
        return this.mRpcFutureStub.load(request);
    }
}

