/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.Seekable;
import alluxio.client.BoundedStream;
import alluxio.client.CanUnbuffer;
import alluxio.client.PositionedReadable;
import alluxio.exception.PreconditionMessage;
import alluxio.util.io.BufferUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class FileInStream
extends InputStream
implements BoundedStream,
PositionedReadable,
Seekable,
CanUnbuffer {
    private final byte[] mSingleByte = new byte[1];

    @Override
    public int read() throws IOException {
        int bytesRead = this.read(this.mSingleByte);
        if (bytesRead == -1) {
            return -1;
        }
        Preconditions.checkState((bytesRead == 1 ? 1 : 0) != 0);
        return BufferUtils.byteToInt((byte)this.mSingleByte[0]);
    }

    @Override
    public int read(byte[] b) throws IOException {
        Preconditions.checkNotNull((Object)b, (Object)PreconditionMessage.ERR_READ_BUFFER_NULL);
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkNotNull((Object)b, (Object)PreconditionMessage.ERR_READ_BUFFER_NULL);
        return this.read(ByteBuffer.wrap(b), off, len);
    }

    public int read(ByteBuffer buf) throws IOException {
        return this.read(buf, buf.position(), buf.remaining());
    }

    public int read(ByteBuffer byteBuffer, int off, int len) throws IOException {
        int nread = 0;
        int rd = 0;
        int sz = len;
        byte[] dest = new byte[sz];
        while (rd >= 0 && nread < sz) {
            rd = this.read(dest, nread, sz - nread);
            if (rd < 0) continue;
            nread += rd;
        }
        if (nread == -1) {
            nread = 0;
        } else if (nread > 0) {
            byteBuffer.put(dest, 0, nread);
        }
        return nread;
    }

    @Override
    public void unbuffer() {
    }
}

