/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MetadataCache {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataCache.class);
    private final Cache<String, CachedItem> mCache;

    public MetadataCache(int maxSize, long expirationTimeMs) {
        this.mCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterWrite(expirationTimeMs, TimeUnit.MILLISECONDS).build();
    }

    @Nullable
    public URIStatus get(AlluxioURI path) {
        CachedItem item = (CachedItem)this.mCache.getIfPresent((Object)path.getPath());
        if (item != null && item.getStatus() != null) {
            return item.getStatus();
        }
        return null;
    }

    public void put(AlluxioURI path, URIStatus status) {
        this.put(path.getPath(), status);
    }

    public void put(String path, URIStatus status) {
        try {
            CachedItem item = (CachedItem)this.mCache.get((Object)path, () -> new CachedItem());
            item.setStatus(status);
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to cache meta data for path {}", (Object)path);
        }
    }

    public void put(AlluxioURI dir, List<URIStatus> statuses) {
        try {
            CachedItem item = (CachedItem)this.mCache.get((Object)dir.getPath(), () -> new CachedItem());
            item.setDirStatuses(statuses);
            for (URIStatus status : statuses) {
                this.put(status.getPath(), status);
            }
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to cache metadata for dir {}", (Object)dir.getPath());
        }
    }

    @Nullable
    public List<URIStatus> listStatus(AlluxioURI dir) {
        return this.listStatus(dir.getPath());
    }

    @Nullable
    public List<URIStatus> listStatus(String dir) {
        CachedItem item = (CachedItem)this.mCache.getIfPresent((Object)dir);
        if (item != null && item.getDirStatuses() != null) {
            return item.getDirStatuses();
        }
        return null;
    }

    public void invalidate(AlluxioURI path) {
        this.invalidate(path.getPath());
    }

    public void invalidate(String path) {
        this.mCache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.mCache.invalidateAll();
    }

    @VisibleForTesting
    public long size() {
        return this.mCache.size();
    }

    private class CachedItem {
        private URIStatus mStatus = null;
        private List<URIStatus> mDirStatuses = null;

        private CachedItem() {
        }

        @Nullable
        public URIStatus getStatus() {
            return this.mStatus;
        }

        @Nullable
        public List<URIStatus> getDirStatuses() {
            return this.mDirStatuses;
        }

        public void setStatus(URIStatus status) {
            this.mStatus = status;
        }

        public void setDirStatuses(List<URIStatus> statuses) {
            this.mDirStatuses = statuses;
        }
    }
}

