/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheUsage;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public interface CacheUsageView {
    public long used();

    public long available();

    public long capacity();

    public static final class ImmutableCacheUsageView
    implements CacheUsage {
        private final long mUsed;
        private final long mAvailable;
        private final long mCapacity;

        public ImmutableCacheUsageView(long used, long available, long capacity) {
            this.mUsed = used;
            this.mAvailable = available;
            this.mCapacity = capacity;
        }

        @Override
        public long used() {
            return this.mUsed;
        }

        @Override
        public long available() {
            return this.mAvailable;
        }

        @Override
        public long capacity() {
            return this.mCapacity;
        }

        @Override
        public CacheUsageView snapshot() {
            return this;
        }

        @Override
        public Optional<CacheUsage> partitionedBy(CacheUsage.PartitionDescriptor<?> partition) {
            return Optional.empty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableCacheUsageView that = (ImmutableCacheUsageView)o;
            return this.mUsed == that.mUsed && this.mAvailable == that.mAvailable && this.mCapacity == that.mCapacity;
        }

        public int hashCode() {
            return Objects.hash(this.mUsed, this.mAvailable, this.mCapacity);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("used", this.mUsed).add("available", this.mAvailable).add("capacity", this.mCapacity).toString();
        }
    }
}

