/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.CacheUsageView;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageMetaStore;
import alluxio.client.file.cache.allocator.Allocator;
import alluxio.client.file.cache.allocator.HashAllocator;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.quota.CacheScope;
import alluxio.collections.IndexDefinition;
import alluxio.collections.IndexedSet;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.PageNotFoundException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultPageMetaStore
implements PageMetaStore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPageMetaStore.class);
    private final IndexedSet<PageInfo> mPages = new IndexedSet(INDEX_PAGE_ID, new IndexDefinition[]{INDEX_FILE_ID});
    private final ImmutableList<PageStoreDir> mDirs;
    private final AtomicLong mBytes = new AtomicLong(0L);
    protected final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();
    private final Allocator mAllcator;
    private static final IndexDefinition<PageInfo, PageId> INDEX_PAGE_ID = IndexDefinition.ofUnique(PageInfo::getPageId);
    private static final IndexDefinition<PageInfo, String> INDEX_FILE_ID = IndexDefinition.ofNonUnique(pageInfo -> pageInfo.getPageId().getFileId());

    public DefaultPageMetaStore(List<PageStoreDir> dirs) {
        this(dirs, new HashAllocator(dirs));
    }

    public DefaultPageMetaStore(List<PageStoreDir> dirs, Allocator allocator) {
        this.mDirs = ImmutableList.copyOf((Collection)Objects.requireNonNull(dirs));
        this.mAllcator = Objects.requireNonNull(allocator);
        MetricsSystem.registerGaugeIfAbsent((String)MetricKey.CLIENT_CACHE_PAGES.getName(), () -> this.mPages.size());
    }

    @Override
    public ReentrantReadWriteLock getLock() {
        return this.mLock;
    }

    @Override
    @GuardedBy(value="getLock()")
    public boolean hasPage(PageId pageId) {
        return this.mPages.contains(INDEX_PAGE_ID, (Object)pageId);
    }

    @Override
    @GuardedBy(value="getLock()")
    public void addPage(PageId pageId, PageInfo pageInfo) {
        this.addPageInternal(pageId, pageInfo);
        pageInfo.getLocalCacheDir().putPage(pageInfo);
    }

    private void addPageInternal(PageId pageId, PageInfo pageInfo) {
        Preconditions.checkArgument((boolean)pageId.equals(pageInfo.getPageId()), (Object)"page id mismatch");
        this.mPages.add((Object)pageInfo);
        this.mBytes.addAndGet(pageInfo.getPageSize());
        Metrics.SPACE_USED.inc(pageInfo.getPageSize());
    }

    @Override
    @GuardedBy(value="getLock()")
    public void addTempPage(PageId pageId, PageInfo pageInfo) {
        this.addPageInternal(pageId, pageInfo);
        pageInfo.getLocalCacheDir().putTempPage(pageInfo);
    }

    @Override
    @GuardedBy(value="getLock().writeLock()")
    public void commitFile(String fileId, String newFileId) throws PageNotFoundException {
        Set pages = this.mPages.getByField(INDEX_FILE_ID, (Object)fileId);
        if (pages.size() == 0) {
            throw new PageNotFoundException(String.format("No Pages found for file %s when committing", fileId));
        }
        for (PageInfo oldPageInfo : pages) {
            PageId newPageId = new PageId(newFileId, oldPageInfo.getPageId().getPageIndex());
            PageInfo newPageInfo = new PageInfo(newPageId, oldPageInfo.getPageSize(), oldPageInfo.getScope(), oldPageInfo.getLocalCacheDir());
            this.mPages.remove((Object)oldPageInfo);
            this.mPages.add((Object)newPageInfo);
        }
    }

    @Override
    public PageStoreDir getStoreDirOfFile(String fileId) throws FileDoesNotExistException {
        PageInfo pageInfo = (PageInfo)this.mPages.getFirstByField(INDEX_FILE_ID, (Object)fileId);
        if (pageInfo == null) {
            throw new FileDoesNotExistException(String.format("File %s does not exist in cache", fileId));
        }
        return pageInfo.getLocalCacheDir();
    }

    @Override
    public List<PageStoreDir> getStoreDirs() {
        return this.mDirs;
    }

    @Override
    public PageStoreDir allocate(String fileId, long fileLength) {
        return this.mAllcator.allocate(fileId, fileLength);
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo getPageInfo(PageId pageId) throws PageNotFoundException {
        if (!this.mPages.contains(INDEX_PAGE_ID, (Object)pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        PageInfo pageInfo = (PageInfo)this.mPages.getFirstByField(INDEX_PAGE_ID, (Object)pageId);
        pageInfo.getLocalCacheDir().getEvictor().updateOnGet(pageId);
        return pageInfo;
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo removePage(PageId pageId, boolean isTemporary) throws PageNotFoundException {
        if (!this.mPages.contains(INDEX_PAGE_ID, (Object)pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        PageInfo pageInfo = (PageInfo)this.mPages.getFirstByField(INDEX_PAGE_ID, (Object)pageId);
        this.mPages.remove((Object)pageInfo);
        this.mBytes.addAndGet(-pageInfo.getPageSize());
        Metrics.SPACE_USED.dec(pageInfo.getPageSize());
        if (isTemporary) {
            pageInfo.getLocalCacheDir().deleteTempPage(pageInfo);
        } else {
            pageInfo.getLocalCacheDir().deletePage(pageInfo);
        }
        return pageInfo;
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo removePage(PageId pageId) throws PageNotFoundException {
        return this.removePage(pageId, false);
    }

    @Override
    public long bytes() {
        return this.mBytes.get();
    }

    @Override
    @GuardedBy(value="getLock()")
    public long numPages() {
        return this.mPages.size();
    }

    @Override
    @GuardedBy(value="getLock()")
    public void reset() {
        this.mBytes.set(0L);
        Metrics.SPACE_USED.dec(Metrics.SPACE_USED.getCount());
        this.mPages.clear();
    }

    @Override
    @Nullable
    @GuardedBy(value="getLock()")
    public PageInfo evict(CacheScope scope, PageStoreDir pageStoreDir) {
        return this.evictInternal(pageStoreDir.getEvictor());
    }

    PageInfo evictInternal(CacheEvictor evictor) {
        PageId victim = evictor.evict();
        if (victim == null) {
            return null;
        }
        PageInfo victimInfo = (PageInfo)this.mPages.getFirstByField(INDEX_PAGE_ID, (Object)victim);
        if (victimInfo == null) {
            LOG.error("Invalid result returned by evictor: page {} not available", (Object)victim);
            evictor.updateOnDelete(victim);
            return null;
        }
        return victimInfo;
    }

    @Override
    @GuardedBy(value="getLock().readLock()")
    public Set<PageInfo> getAllPagesByFileId(String fileId) {
        Set pages = this.mPages.getByField(INDEX_FILE_ID, (Object)fileId);
        return pages;
    }

    @Override
    public Optional<CacheUsage> getUsage() {
        return Optional.of(new Usage());
    }

    private static final class Metrics {
        private static final Counter SPACE_USED = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_SPACE_USED_COUNT.getName());

        private Metrics() {
        }
    }

    class Usage
    implements CacheUsage {
        Usage() {
        }

        @Override
        public long used() {
            return DefaultPageMetaStore.this.bytes();
        }

        @Override
        public long available() {
            return this.capacity() - this.used();
        }

        @Override
        public long capacity() {
            return DefaultPageMetaStore.this.mDirs.stream().mapToLong(PageStoreDir::getCapacityBytes).sum();
        }

        @Override
        public Optional<CacheUsage> partitionedBy(CacheUsage.PartitionDescriptor<?> partition) {
            if (partition instanceof CacheUsage.FilePartition) {
                String fileId = ((CacheUsage.FilePartition)partition).getIdentifier();
                Set pages = DefaultPageMetaStore.this.mPages.getByField(INDEX_FILE_ID, (Object)fileId);
                long used = pages.stream().mapToLong(PageInfo::getPageSize).sum();
                long capacity = this.capacity();
                long available = capacity - DefaultPageMetaStore.this.bytes();
                return Optional.of(new CacheUsageView.ImmutableCacheUsageView(used, available, capacity));
            }
            if (partition instanceof CacheUsage.DirPartition) {
                int dirIndex = ((CacheUsage.DirPartition)partition).getIdentifier();
                if (dirIndex < 0 || dirIndex >= DefaultPageMetaStore.this.mDirs.size()) {
                    return Optional.empty();
                }
                return ((PageStoreDir)DefaultPageMetaStore.this.mDirs.get(dirIndex)).getUsage();
            }
            return Optional.empty();
        }
    }
}

