/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.allocator;

import alluxio.client.file.cache.allocator.Allocator;
import alluxio.client.file.cache.store.PageStoreDir;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class HashAllocator
implements Allocator {
    protected final List<PageStoreDir> mDirs;
    private final Function<String, Integer> mHashFunction;

    public HashAllocator(List<PageStoreDir> dirs) {
        this(dirs, fileId -> Hashing.murmur3_32_fixed().hashString((CharSequence)fileId, StandardCharsets.UTF_8).asInt());
    }

    public HashAllocator(List<PageStoreDir> dirs, Function<String, Integer> hashFunction) {
        this.mDirs = Objects.requireNonNull(dirs);
        this.mHashFunction = Objects.requireNonNull(hashFunction);
    }

    @Override
    public PageStoreDir allocate(String fileId, long fileLength) {
        return this.mDirs.get(Math.floorMod(this.mHashFunction.apply(fileId), this.mDirs.size()));
    }
}

