/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.ufs;

import alluxio.Seekable;
import alluxio.client.file.FileInStream;
import alluxio.exception.PreconditionMessage;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class UfsFileInStream
extends FileInStream {
    private final long mLength;
    private final Function<Long, InputStream> mFileOpener;
    private Optional<InputStream> mUfsInStream = Optional.empty();
    private long mPosition = 0L;

    public UfsFileInStream(Function<Long, InputStream> fileOpener, long fileLength) {
        this.mFileOpener = (Function)Preconditions.checkNotNull(fileOpener);
        this.mLength = fileLength;
    }

    @Override
    public int read() throws IOException {
        if (this.mPosition == this.mLength) {
            return -1;
        }
        this.updateStreamIfNeeded();
        int res = this.mUfsInStream.get().read();
        if (res == -1) {
            return -1;
        }
        ++this.mPosition;
        return res;
    }

    @Override
    public int read(ByteBuffer byteBuffer, int off, int len) throws IOException {
        byte[] byteArray = new byte[len];
        int totalBytesRead = this.read(byteArray, 0, len);
        if (totalBytesRead <= 0) {
            return totalBytesRead;
        }
        byteBuffer.position(off).limit(off + len);
        byteBuffer.put(byteArray, 0, totalBytesRead);
        return totalBytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalRead;
        Preconditions.checkArgument((off >= 0 && len >= 0 && len + off <= b.length ? 1 : 0) != 0, (String)PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)b.length, (Object)off, (Object)len);
        if (this.mPosition == this.mLength) {
            return -1;
        }
        this.updateStreamIfNeeded();
        int currentRead = 0;
        for (totalRead = 0; totalRead < len && (currentRead = this.mUfsInStream.get().read(b, off + totalRead, len - totalRead)) > 0; totalRead += currentRead) {
        }
        this.mPosition += (long)totalRead;
        return totalRead == 0 ? currentRead : totalRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long toBeSkipped = Math.min(n, this.mLength - this.mPosition);
        if (!this.mUfsInStream.isPresent()) {
            this.mPosition += toBeSkipped;
            return toBeSkipped;
        }
        long res = this.mUfsInStream.get().skip(toBeSkipped);
        if (res > 0L) {
            this.mPosition += res;
        }
        return res;
    }

    @Override
    public long remaining() {
        return this.mLength - this.mPosition;
    }

    @Override
    public int positionedRead(long position, byte[] buffer, int offset, int length) throws IOException {
        this.seek(position);
        return this.read(buffer, offset, length);
    }

    public long getPos() throws IOException {
        return this.mPosition;
    }

    public void seek(long pos) throws IOException {
        Preconditions.checkArgument((pos >= 0L ? 1 : 0) != 0, (String)"Seek position is negative: %s", (long)pos);
        Preconditions.checkArgument((pos <= this.mLength ? 1 : 0) != 0, (String)"Seek position (%s) exceeds the length of the file (%s)", (long)pos, (long)this.mLength);
        if (this.mPosition == pos) {
            return;
        }
        if (!this.mUfsInStream.isPresent()) {
            this.mPosition = pos;
            return;
        }
        if (this.mUfsInStream.get() instanceof Seekable) {
            ((Seekable)this.mUfsInStream.get()).seek(pos);
        } else if (this.mPosition < pos) {
            while (this.mPosition < pos) {
                this.mPosition += this.mUfsInStream.get().skip(pos - this.mPosition);
            }
        } else {
            this.close();
        }
        this.mPosition = pos;
    }

    @Override
    public void close() throws IOException {
        if (this.mUfsInStream.isPresent()) {
            this.mUfsInStream.get().close();
            this.mUfsInStream = Optional.empty();
        }
    }

    private void updateStreamIfNeeded() {
        if (this.mUfsInStream.isPresent()) {
            return;
        }
        this.mUfsInStream = Optional.of(this.mFileOpener.apply(this.mPosition));
    }
}

