/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.DocumentTypeJsonMarshaller;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.DocumentUnmarshaller;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingExecutionInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.document.VoidDocumentVisitor;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.protocols.json.SdkJsonGenerator;
import software.amazon.awssdk.protocols.json.StructuredJsonGenerator;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeVisitor;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConversationRole;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.InferenceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamResponse;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.Message;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.PayloadPart;
import software.amazon.awssdk.services.bedrockruntime.model.ResponseStream;
import software.amazon.awssdk.services.bedrockruntime.model.StopReason;
import software.amazon.awssdk.services.bedrockruntime.model.TokenUsage;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlockStart;
import software.amazon.awssdk.thirdparty.jackson.core.JsonFactory;

public final class BedrockRuntimeImpl {
    private static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey((String)"event.name");
    private static final AttributeKey<String> GEN_AI_SYSTEM = AttributeKey.stringKey((String)"gen_ai.system");
    private static final ExecutionAttribute<Document> INVOKE_MODEL_REQUEST_BODY = new ExecutionAttribute(BedrockRuntimeImpl.class.getName() + ".InvokeModelRequestBody");
    private static final ExecutionAttribute<Document> INVOKE_MODEL_RESPONSE_BODY = new ExecutionAttribute(BedrockRuntimeImpl.class.getName() + ".InvokeModelResponseBody");
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final JsonNodeParser JSON_PARSER = JsonNode.parser();
    private static final DocumentUnmarshaller DOCUMENT_UNMARSHALLER = new DocumentUnmarshaller();
    private static final Double CHARS_PER_TOKEN = 6.0;

    private BedrockRuntimeImpl() {
    }

    static boolean isBedrockRuntimeRequest(SdkRequest request) {
        if (request instanceof ConverseRequest) {
            return true;
        }
        if (request instanceof ConverseStreamRequest) {
            return true;
        }
        if (request instanceof InvokeModelRequest) {
            return true;
        }
        return request instanceof InvokeModelWithResponseStreamRequest;
    }

    static boolean isBedrockRuntimeResponse(SdkResponse request) {
        if (request instanceof ConverseResponse) {
            return true;
        }
        return request instanceof InvokeModelResponse;
    }

    static void maybeParseInvokeModelRequest(ExecutionAttributes executionAttributes, SdkRequest request) {
        SdkBytes payload = null;
        if (request instanceof InvokeModelRequest) {
            payload = ((InvokeModelRequest)request).body();
        }
        if (request instanceof InvokeModelWithResponseStreamRequest) {
            payload = ((InvokeModelWithResponseStreamRequest)request).body();
        }
        if (payload != null) {
            Document body = BedrockRuntimeImpl.deserializeDocument(payload.asByteArrayUnsafe());
            executionAttributes.putAttribute(INVOKE_MODEL_REQUEST_BODY, (Object)body);
        }
    }

    static void maybeParseInvokeModelResponse(ExecutionAttributes executionAttributes, SdkResponse response) {
        if (response instanceof InvokeModelResponse) {
            Document body = BedrockRuntimeImpl.deserializeDocument(((InvokeModelResponse)response).body().asByteArrayUnsafe());
            executionAttributes.putAttribute(INVOKE_MODEL_RESPONSE_BODY, (Object)body);
        }
    }

    @Nullable
    static String getModelId(ExecutionAttributes executionAttributes) {
        SdkRequest request = (SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        if (request instanceof ConverseRequest) {
            return ((ConverseRequest)request).modelId();
        }
        if (request instanceof ConverseStreamRequest) {
            return ((ConverseStreamRequest)request).modelId();
        }
        if (request instanceof InvokeModelRequest) {
            return ((InvokeModelRequest)request).modelId();
        }
        if (request instanceof InvokeModelWithResponseStreamRequest) {
            return ((InvokeModelWithResponseStreamRequest)request).modelId();
        }
        return null;
    }

    @Nullable
    static String getOperationName(ExecutionAttributes executionAttributes) {
        SdkRequest request = (SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        if (request instanceof ConverseRequest) {
            return "chat";
        }
        if (request instanceof ConverseStreamRequest) {
            return "chat";
        }
        if (request instanceof InvokeModelRequest) {
            return BedrockRuntimeImpl.getOperationNameInvokeModel(((InvokeModelRequest)request).modelId());
        }
        if (request instanceof InvokeModelWithResponseStreamRequest) {
            return BedrockRuntimeImpl.getOperationNameInvokeModel(((InvokeModelWithResponseStreamRequest)request).modelId());
        }
        return null;
    }

    @Nullable
    private static String getOperationNameInvokeModel(@Nullable String modelId) {
        if (modelId == null) {
            return null;
        }
        if (modelId.startsWith("amazon.titan")) {
            return "text_completion";
        }
        return "chat";
    }

    @Nullable
    static Long getMaxTokens(ExecutionAttributes executionAttributes) {
        SdkRequest request = (SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        if (request instanceof InvokeModelRequest) {
            return BedrockRuntimeImpl.getMaxTokensInvokeModel(executionAttributes, ((InvokeModelRequest)request).modelId());
        }
        if (request instanceof InvokeModelWithResponseStreamRequest) {
            return BedrockRuntimeImpl.getMaxTokensInvokeModel(executionAttributes, ((InvokeModelWithResponseStreamRequest)request).modelId());
        }
        InferenceConfiguration config = null;
        if (request instanceof ConverseRequest) {
            config = ((ConverseRequest)request).inferenceConfig();
        } else if (request instanceof ConverseStreamRequest) {
            config = ((ConverseStreamRequest)request).inferenceConfig();
        }
        if (config != null) {
            return BedrockRuntimeImpl.integerToLong(config.maxTokens());
        }
        return null;
    }

    @Nullable
    private static Long getMaxTokensInvokeModel(ExecutionAttributes executionAttributes, @Nullable String modelId) {
        if (modelId == null) {
            return null;
        }
        Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_REQUEST_BODY);
        if (!body.isMap()) {
            return null;
        }
        Document count = null;
        if (modelId.startsWith("amazon.titan")) {
            Document config = (Document)body.asMap().get("textGenerationConfig");
            if (config == null || !config.isMap()) {
                return null;
            }
            count = (Document)config.asMap().get("maxTokenCount");
        } else if (modelId.startsWith("amazon.nova")) {
            Document config = (Document)body.asMap().get("inferenceConfig");
            if (config == null || !config.isMap()) {
                return null;
            }
            count = (Document)config.asMap().get("max_new_tokens");
        } else if (modelId.startsWith("anthropic.claude") || modelId.startsWith("cohere.command") || modelId.startsWith("mistral.mistral")) {
            count = (Document)body.asMap().get("max_tokens");
        } else if (modelId.startsWith("meta.llama")) {
            count = (Document)body.asMap().get("max_gen_len");
        }
        if (count != null && count.isNumber()) {
            return count.asNumber().longValue();
        }
        return null;
    }

    @Nullable
    static Double getTemperature(ExecutionAttributes executionAttributes) {
        SdkRequest request = (SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        if (request instanceof InvokeModelRequest) {
            return BedrockRuntimeImpl.getTemperatureInvokeModel(executionAttributes, ((InvokeModelRequest)request).modelId());
        }
        if (request instanceof InvokeModelWithResponseStreamRequest) {
            return BedrockRuntimeImpl.getTemperatureInvokeModel(executionAttributes, ((InvokeModelWithResponseStreamRequest)request).modelId());
        }
        InferenceConfiguration config = null;
        if (request instanceof ConverseRequest) {
            config = ((ConverseRequest)request).inferenceConfig();
        } else if (request instanceof ConverseStreamRequest) {
            config = ((ConverseStreamRequest)request).inferenceConfig();
        }
        if (config != null) {
            return BedrockRuntimeImpl.floatToDouble(config.temperature());
        }
        return null;
    }

    @Nullable
    private static Double getTemperatureInvokeModel(ExecutionAttributes executionAttributes, @Nullable String modelId) {
        if (modelId == null) {
            return null;
        }
        Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_REQUEST_BODY);
        if (!body.isMap()) {
            return null;
        }
        Document temperature = null;
        if (modelId.startsWith("amazon.titan")) {
            Document config = (Document)body.asMap().get("textGenerationConfig");
            if (config == null || !config.isMap()) {
                return null;
            }
            temperature = (Document)config.asMap().get("temperature");
        } else if (modelId.startsWith("amazon.nova")) {
            Document config = (Document)body.asMap().get("inferenceConfig");
            if (config == null || !config.isMap()) {
                return null;
            }
            temperature = (Document)config.asMap().get("temperature");
        } else if (modelId.startsWith("anthropic.claude") || modelId.startsWith("meta.llama") || modelId.startsWith("cohere.command") || modelId.startsWith("mistral.mistral")) {
            temperature = (Document)body.asMap().get("temperature");
        }
        if (temperature != null && temperature.isNumber()) {
            return temperature.asNumber().doubleValue();
        }
        return null;
    }

    @Nullable
    static Double getTopP(ExecutionAttributes executionAttributes) {
        SdkRequest request = (SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        if (request instanceof InvokeModelRequest) {
            return BedrockRuntimeImpl.getToppInvokeModel(executionAttributes, ((InvokeModelRequest)request).modelId());
        }
        if (request instanceof InvokeModelWithResponseStreamRequest) {
            return BedrockRuntimeImpl.getToppInvokeModel(executionAttributes, ((InvokeModelWithResponseStreamRequest)request).modelId());
        }
        InferenceConfiguration config = null;
        if (request instanceof ConverseRequest) {
            config = ((ConverseRequest)request).inferenceConfig();
        } else if (request instanceof ConverseStreamRequest) {
            config = ((ConverseStreamRequest)request).inferenceConfig();
        }
        if (config != null) {
            return BedrockRuntimeImpl.floatToDouble(config.topP());
        }
        return null;
    }

    private static Double getToppInvokeModel(ExecutionAttributes executionAttributes, @Nullable String modelId) {
        if (modelId == null) {
            return null;
        }
        Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_REQUEST_BODY);
        if (!body.isMap()) {
            return null;
        }
        Document topP = null;
        if (modelId.startsWith("amazon.titan")) {
            Document config = (Document)body.asMap().get("textGenerationConfig");
            if (config == null || !config.isMap()) {
                return null;
            }
            topP = (Document)config.asMap().get("topP");
        } else if (modelId.startsWith("amazon.nova")) {
            Document config = (Document)body.asMap().get("inferenceConfig");
            if (config == null || !config.isMap()) {
                return null;
            }
            topP = (Document)config.asMap().get("topP");
        } else if (modelId.startsWith("anthropic.claude") || modelId.startsWith("meta.llama") || modelId.startsWith("mistral.mistral")) {
            topP = (Document)body.asMap().get("top_p");
        } else if (modelId.startsWith("cohere.command")) {
            topP = (Document)body.asMap().get("p");
        }
        if (topP != null && topP.isNumber()) {
            return topP.asNumber().doubleValue();
        }
        return null;
    }

    @Nullable
    static List<String> getStopSequences(ExecutionAttributes executionAttributes) {
        SdkRequest request = (SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        if (request instanceof InvokeModelRequest) {
            return BedrockRuntimeImpl.getStopSequences(executionAttributes, ((InvokeModelRequest)request).modelId());
        }
        if (request instanceof InvokeModelWithResponseStreamRequest) {
            return BedrockRuntimeImpl.getStopSequences(executionAttributes, ((InvokeModelWithResponseStreamRequest)request).modelId());
        }
        InferenceConfiguration config = null;
        if (request instanceof ConverseRequest) {
            config = ((ConverseRequest)request).inferenceConfig();
        } else if (request instanceof ConverseStreamRequest) {
            config = ((ConverseStreamRequest)request).inferenceConfig();
        }
        if (config != null) {
            return config.stopSequences();
        }
        return null;
    }

    @Nullable
    private static List<String> getStopSequences(ExecutionAttributes executionAttributes, @Nullable String modelId) {
        if (modelId == null) {
            return null;
        }
        Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_REQUEST_BODY);
        if (!body.isMap()) {
            return null;
        }
        Document stopSequences = null;
        if (modelId.startsWith("amazon.titan")) {
            Document config = (Document)body.asMap().get("textGenerationConfig");
            if (config == null || !config.isMap()) {
                return null;
            }
            stopSequences = (Document)config.asMap().get("stopSequences");
        } else if (modelId.startsWith("amazon.nova")) {
            Document config = (Document)body.asMap().get("inferenceConfig");
            if (config == null || !config.isMap()) {
                return null;
            }
            stopSequences = (Document)config.asMap().get("stopSequences");
        } else if (modelId.startsWith("anthropic.claude") || modelId.startsWith("cohere.command")) {
            stopSequences = (Document)body.asMap().get("stop_sequences");
        } else if (modelId.startsWith("mistral.mistral")) {
            stopSequences = (Document)body.asMap().get("stop");
        }
        if (stopSequences != null && stopSequences.isList()) {
            return stopSequences.asList().stream().filter(Document::isString).map(Document::asString).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    static List<String> getStopReasons(ExecutionAttributes executionAttributes, Response response) {
        SdkResponse sdkResponse = response.getSdkResponse();
        if (sdkResponse instanceof InvokeModelResponse) {
            return BedrockRuntimeImpl.getStopReasons(executionAttributes, (InvokeModelRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE));
        }
        if (sdkResponse instanceof ConverseResponse) {
            StopReason reason = ((ConverseResponse)sdkResponse).stopReason();
            if (reason != null) {
                return Collections.singletonList(reason.toString());
            }
        } else {
            BedrockRuntimeStreamResponseHandler<?, ?> streamHandler = BedrockRuntimeStreamResponseHandler.fromContext(response.otelContext());
            if (streamHandler != null) {
                return streamHandler.stopReasons;
            }
        }
        return null;
    }

    @Nullable
    private static List<String> getStopReasons(ExecutionAttributes executionAttributes, InvokeModelRequest request) {
        String modelId = request.modelId();
        if (modelId == null) {
            return null;
        }
        Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_RESPONSE_BODY);
        if (!body.isMap()) {
            return null;
        }
        if (modelId.startsWith("amazon.titan")) {
            ArrayList<String> stopReasons = new ArrayList<String>();
            Document results = (Document)body.asMap().get("results");
            if (results == null || !results.isList()) {
                return null;
            }
            for (Document result : results.asList()) {
                Document completionReason = (Document)result.asMap().get("completionReason");
                if (completionReason == null || !completionReason.isString()) continue;
                stopReasons.add(completionReason.asString());
            }
            return stopReasons;
        }
        Document stopReason = null;
        if (modelId.startsWith("amazon.nova")) {
            stopReason = (Document)body.asMap().get("stopReason");
        } else if (modelId.startsWith("anthropic.claude") || modelId.startsWith("meta.llama")) {
            stopReason = (Document)body.asMap().get("stop_reason");
        } else if (modelId.startsWith("cohere.command-r")) {
            stopReason = (Document)body.asMap().get("finish_reason");
        } else {
            if (modelId.startsWith("cohere.command")) {
                ArrayList<String> stopReasons = new ArrayList<String>();
                Document results = (Document)body.asMap().get("generations");
                if (results == null || !results.isList()) {
                    return null;
                }
                for (Document result : results.asList()) {
                    stopReason = (Document)result.asMap().get("finish_reason");
                    if (stopReason == null || !stopReason.isString()) continue;
                    stopReasons.add(stopReason.asString());
                }
                return stopReasons;
            }
            if (modelId.startsWith("mistral.mistral")) {
                ArrayList<String> stopReasons = new ArrayList<String>();
                Document results = (Document)body.asMap().get("outputs");
                if (results == null || !results.isList()) {
                    return null;
                }
                for (Document result : results.asList()) {
                    stopReason = (Document)result.asMap().get("stop_reason");
                    if (stopReason == null || !stopReason.isString()) continue;
                    stopReasons.add(stopReason.asString());
                }
                return stopReasons;
            }
        }
        if (stopReason != null && stopReason.isString()) {
            return Collections.singletonList(stopReason.asString());
        }
        return null;
    }

    @Nullable
    static Long getUsageInputTokens(ExecutionAttributes executionAttributes, Response response) {
        SdkResponse sdkResponse = response.getSdkResponse();
        if (sdkResponse instanceof InvokeModelResponse) {
            return BedrockRuntimeImpl.getUsageInputTokens(executionAttributes, (InvokeModelRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE));
        }
        TokenUsage usage = null;
        if (sdkResponse instanceof ConverseResponse) {
            usage = ((ConverseResponse)sdkResponse).usage();
        } else {
            BedrockRuntimeStreamResponseHandler<?, ?> streamHandler = BedrockRuntimeStreamResponseHandler.fromContext(response.otelContext());
            if (streamHandler != null) {
                usage = streamHandler.usage;
            }
        }
        if (usage != null) {
            return BedrockRuntimeImpl.integerToLong(usage.inputTokens());
        }
        return null;
    }

    @Nullable
    private static Long getUsageInputTokens(ExecutionAttributes executionAttributes, InvokeModelRequest request) {
        String modelId = request.modelId();
        if (modelId == null) {
            return null;
        }
        Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_RESPONSE_BODY);
        if (!body.isMap()) {
            return null;
        }
        Document count = null;
        if (modelId.startsWith("amazon.titan")) {
            count = (Document)body.asMap().get("inputTextTokenCount");
        } else if (modelId.startsWith("amazon.nova")) {
            Document usage = (Document)body.asMap().get("usage");
            if (usage == null || !usage.isMap()) {
                return null;
            }
            count = (Document)usage.asMap().get("inputTokens");
        } else if (modelId.startsWith("anthropic.claude")) {
            Document usage = (Document)body.asMap().get("usage");
            if (usage == null || !usage.isMap()) {
                return null;
            }
            count = (Document)usage.asMap().get("input_tokens");
        } else if (modelId.startsWith("meta.llama")) {
            count = (Document)body.asMap().get("prompt_token_count");
        } else if (modelId.startsWith("cohere.command-r")) {
            Document requestBody = (Document)executionAttributes.getAttribute(INVOKE_MODEL_REQUEST_BODY);
            if (requestBody == null || !requestBody.isMap()) {
                return null;
            }
            String prompt = ((Document)requestBody.asMap().get("message")).asString();
            if (prompt == null) {
                return null;
            }
            count = Document.fromNumber((double)Math.ceil((double)prompt.length() / CHARS_PER_TOKEN));
        } else if (modelId.startsWith("cohere.command") || modelId.startsWith("mistral.mistral")) {
            Document requestBody = (Document)executionAttributes.getAttribute(INVOKE_MODEL_REQUEST_BODY);
            if (requestBody == null || !requestBody.isMap()) {
                return null;
            }
            String prompt = ((Document)requestBody.asMap().get("prompt")).asString();
            if (prompt == null) {
                return null;
            }
            count = Document.fromNumber((double)Math.ceil((double)prompt.length() / CHARS_PER_TOKEN));
        }
        if (count != null && count.isNumber()) {
            return count.asNumber().longValue();
        }
        return null;
    }

    @Nullable
    static Long getUsageOutputTokens(ExecutionAttributes executionAttributes, Response response) {
        SdkResponse sdkResponse = response.getSdkResponse();
        if (sdkResponse instanceof InvokeModelResponse) {
            return BedrockRuntimeImpl.getUsageOutputTokens(executionAttributes, (InvokeModelRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE));
        }
        TokenUsage usage = null;
        if (sdkResponse instanceof ConverseResponse) {
            usage = ((ConverseResponse)sdkResponse).usage();
        } else {
            BedrockRuntimeStreamResponseHandler<?, ?> streamHandler = BedrockRuntimeStreamResponseHandler.fromContext(response.otelContext());
            if (streamHandler != null) {
                usage = streamHandler.usage;
            }
        }
        if (usage != null) {
            return BedrockRuntimeImpl.integerToLong(usage.outputTokens());
        }
        return null;
    }

    @Nullable
    private static Long getUsageOutputTokens(ExecutionAttributes executionAttributes, InvokeModelRequest request) {
        String modelId = request.modelId();
        if (modelId == null) {
            return null;
        }
        Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_RESPONSE_BODY);
        if (!body.isMap()) {
            return null;
        }
        Document count = null;
        if (modelId.startsWith("amazon.titan")) {
            Document results = (Document)body.asMap().get("results");
            if (results == null || !results.isList()) {
                return null;
            }
            long outputTokens = 0L;
            for (Document result : results.asList()) {
                Document tokenCount = (Document)result.asMap().get("tokenCount");
                if (tokenCount == null || !tokenCount.isNumber()) continue;
                outputTokens += (long)tokenCount.asNumber().intValue();
            }
            return outputTokens;
        }
        if (modelId.startsWith("amazon.nova")) {
            Document usage = (Document)body.asMap().get("usage");
            if (usage == null || !usage.isMap()) {
                return null;
            }
            count = (Document)usage.asMap().get("outputTokens");
        } else if (modelId.startsWith("anthropic.claude")) {
            Document usage = (Document)body.asMap().get("usage");
            if (usage == null || !usage.isMap()) {
                return null;
            }
            count = (Document)usage.asMap().get("output_tokens");
        } else if (modelId.startsWith("meta.llama")) {
            count = (Document)body.asMap().get("generation_token_count");
        } else if (modelId.startsWith("cohere.command-r")) {
            Document text = (Document)body.asMap().get("text");
            if (text == null || !text.isString()) {
                return null;
            }
            count = Document.fromNumber((double)Math.ceil((double)text.asString().length() / CHARS_PER_TOKEN));
        } else if (modelId.startsWith("cohere.command")) {
            Document generations = (Document)body.asMap().get("generations");
            if (generations == null || !generations.isList()) {
                return null;
            }
            long outputLength = 0L;
            for (Document generation : generations.asList()) {
                Document text = (Document)generation.asMap().get("text");
                if (text == null || !text.isString()) continue;
                outputLength += (long)text.asString().length();
            }
            count = Document.fromNumber((double)Math.ceil((double)outputLength / CHARS_PER_TOKEN));
        } else if (modelId.startsWith("mistral.mistral")) {
            Document outputs = (Document)body.asMap().get("outputs");
            if (outputs == null || !outputs.isList()) {
                return null;
            }
            long outputLength = 0L;
            for (Document output : outputs.asList()) {
                Document text = (Document)output.asMap().get("text");
                if (text == null || !text.isString()) continue;
                outputLength += (long)text.asString().length();
            }
            count = Document.fromNumber((double)Math.ceil((double)outputLength / CHARS_PER_TOKEN));
        }
        if (count != null && count.isNumber()) {
            return count.asNumber().longValue();
        }
        return null;
    }

    static void recordRequestEvents(Context otelContext, Logger eventLogger, ExecutionAttributes executionAttributes, SdkRequest request, boolean captureMessageContent) {
        BedrockRuntimeStreamResponseHandler<?, ?> streamHandler = BedrockRuntimeStreamResponseHandler.fromContext(otelContext);
        if (streamHandler != null) {
            streamHandler.setOtelContext(otelContext);
        }
        if (request instanceof InvokeModelRequest) {
            Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_REQUEST_BODY);
            BedrockRuntimeImpl.recordInvokeModelRequestEvents(otelContext, eventLogger, ((InvokeModelRequest)request).modelId(), body, captureMessageContent);
            return;
        }
        if (request instanceof InvokeModelWithResponseStreamRequest) {
            Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_REQUEST_BODY);
            BedrockRuntimeImpl.recordInvokeModelRequestEvents(otelContext, eventLogger, ((InvokeModelWithResponseStreamRequest)request).modelId(), body, captureMessageContent);
            return;
        }
        if (request instanceof ConverseRequest) {
            BedrockRuntimeImpl.recordRequestMessageEvents(otelContext, eventLogger, ((ConverseRequest)request).messages(), captureMessageContent);
            return;
        }
        if (request instanceof ConverseStreamRequest) {
            BedrockRuntimeImpl.recordRequestMessageEvents(otelContext, eventLogger, ((ConverseStreamRequest)request).messages(), captureMessageContent);
        }
    }

    private static void recordInvokeModelRequestEvents(Context otelContext, Logger eventLogger, @Nullable String modelId, Document body, boolean captureMessageContent) {
        if (!body.isMap()) {
            return;
        }
        if (modelId == null) {
            return;
        }
        if (modelId.startsWith("amazon.titan")) {
            Document inputText = (Document)body.asMap().get("inputText");
            if (inputText == null || !inputText.isString()) {
                return;
            }
            Message message = (Message)Message.builder().role(ConversationRole.USER).content(new ContentBlock[]{ContentBlock.fromText((String)inputText.asString())}).build();
            BedrockRuntimeImpl.recordRequestMessageEvents(otelContext, eventLogger, Collections.singletonList(message), captureMessageContent);
            return;
        }
        ModelFamily modelFamily = null;
        if (modelId.startsWith("amazon.nova")) {
            modelFamily = ModelFamily.AMAZON_NOVA;
        } else if (modelId.startsWith("anthropic.claude")) {
            modelFamily = ModelFamily.ANTHROPIC_CLAUDE;
        }
        if (modelFamily == ModelFamily.AMAZON_NOVA || modelFamily == ModelFamily.ANTHROPIC_CLAUDE) {
            Document messages = (Document)body.asMap().get("messages");
            if (messages == null || !messages.isList()) {
                return;
            }
            ArrayList<Message> parsedMessages = new ArrayList<Message>();
            for (Document message : messages.asList()) {
                Document content;
                Document role;
                if (!message.isMap() || (role = (Document)message.asMap().get("role")) == null || !role.isString() || (content = (Document)message.asMap().get("content")) == null || !content.isList()) continue;
                ArrayList<ContentBlock> parsedContentBlocks = new ArrayList<ContentBlock>();
                for (Document contentBlock : content.asList()) {
                    ContentBlock parsed = BedrockRuntimeImpl.parseModelContentBlock(modelFamily, contentBlock);
                    if (parsed == null) continue;
                    parsedContentBlocks.add(parsed);
                }
                parsedMessages.add((Message)Message.builder().role(role.asString()).content(parsedContentBlocks).build());
            }
            BedrockRuntimeImpl.recordRequestMessageEvents(otelContext, eventLogger, parsedMessages, captureMessageContent);
        }
    }

    private static void recordRequestMessageEvents(Context otelContext, Logger eventLogger, List<Message> messages, boolean captureMessageContent) {
        block4: for (Message message : messages) {
            long numToolResults = message.content().stream().filter(block -> block.toolResult() != null).count();
            if (numToolResults > 0L) {
                BedrockRuntimeImpl.emitToolResultEvents(otelContext, eventLogger, message, captureMessageContent);
                if (numToolResults == (long)message.content().size()) continue;
            }
            LogRecordBuilder event = BedrockRuntimeImpl.newEvent(otelContext, eventLogger);
            switch (message.role()) {
                case ASSISTANT: {
                    event.setAttribute(EVENT_NAME, (Object)"gen_ai.assistant.message");
                    break;
                }
                case USER: {
                    event.setAttribute(EVENT_NAME, (Object)"gen_ai.user.message");
                    break;
                }
                default: {
                    continue block4;
                }
            }
            event.setBody(BedrockRuntimeImpl.convertMessage(message, -1, null, captureMessageContent)).emit();
        }
    }

    static void recordResponseEvents(Context otelContext, Logger eventLogger, ExecutionAttributes executionAttributes, SdkResponse response, boolean captureMessageContent) {
        if (response instanceof InvokeModelResponse) {
            InvokeModelRequest request = (InvokeModelRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
            Document body = (Document)executionAttributes.getAttribute(INVOKE_MODEL_RESPONSE_BODY);
            BedrockRuntimeImpl.recordInvokeModelResponseEvents(otelContext, eventLogger, request, body, captureMessageContent);
        }
        if (response instanceof ConverseResponse) {
            ConverseResponse converseResponse = (ConverseResponse)response;
            BedrockRuntimeImpl.newEvent(otelContext, eventLogger).setAttribute(EVENT_NAME, (Object)"gen_ai.choice").setBody(BedrockRuntimeImpl.convertMessage(converseResponse.output().message(), 0, converseResponse.stopReasonAsString(), captureMessageContent)).emit();
        }
    }

    private static void recordInvokeModelResponseEvents(Context otelContext, Logger eventLogger, InvokeModelRequest request, Document body, boolean captureMessageContent) {
        Document stopReason;
        if (!body.isMap()) {
            return;
        }
        String modelId = request.modelId();
        if (modelId == null) {
            return;
        }
        ModelFamily modelFamily = null;
        if (modelId.startsWith("amazon.titan")) {
            Document results = (Document)body.asMap().get("results");
            if (results == null || !results.isList()) {
                return;
            }
            int index = 0;
            for (Document result : results.asList()) {
                Document completionReason = (Document)result.asMap().get("completionReason");
                if (completionReason == null || !completionReason.isString()) continue;
                Message.Builder parsedMessage = Message.builder().role(ConversationRole.ASSISTANT);
                Document outputText = (Document)result.asMap().get("outputText");
                if (outputText != null && outputText.isString()) {
                    parsedMessage.content(new ContentBlock[]{ContentBlock.fromText((String)outputText.asString())});
                }
                BedrockRuntimeImpl.newEvent(otelContext, eventLogger).setAttribute(EVENT_NAME, (Object)"gen_ai.choice").setBody(BedrockRuntimeImpl.convertMessage((Message)parsedMessage.build(), index, completionReason.asString(), captureMessageContent)).emit();
                ++index;
            }
            return;
        }
        String stopReasonString = null;
        Document content = null;
        if (modelId.startsWith("amazon.nova")) {
            modelFamily = ModelFamily.AMAZON_NOVA;
            stopReason = (Document)body.asMap().get("stopReason");
            Document output = (Document)body.asMap().get("output");
            if (output == null || !output.isMap()) {
                return;
            }
            Document message = (Document)output.asMap().get("message");
            if (message == null || !message.isMap()) {
                return;
            }
            content = (Document)message.asMap().get("content");
            stopReasonString = stopReason.asString();
        } else if (modelId.startsWith("anthropic.claude")) {
            modelFamily = ModelFamily.ANTHROPIC_CLAUDE;
            stopReason = (Document)body.asMap().get("stop_reason");
            content = (Document)body.asMap().get("content");
            stopReasonString = stopReason.asString();
        }
        if (content == null || !content.isList()) {
            return;
        }
        ArrayList<ContentBlock> parsedContentBlocks = new ArrayList<ContentBlock>();
        for (Document contentBlock : content.asList()) {
            ContentBlock parsed = BedrockRuntimeImpl.parseModelContentBlock(modelFamily, contentBlock);
            if (parsed == null) continue;
            parsedContentBlocks.add(parsed);
        }
        Message parsedMessage = (Message)Message.builder().role(ConversationRole.ASSISTANT).content(parsedContentBlocks).build();
        BedrockRuntimeImpl.newEvent(otelContext, eventLogger).setAttribute(EVENT_NAME, (Object)"gen_ai.choice").setBody(BedrockRuntimeImpl.convertMessage(parsedMessage, 0, stopReasonString, captureMessageContent)).emit();
    }

    @Nullable
    private static ContentBlock parseModelContentBlock(ModelFamily modelFamily, Document contentBlock) {
        switch (modelFamily.ordinal()) {
            case 0: {
                return BedrockRuntimeImpl.parseAmazonNovaContentBlock(contentBlock);
            }
            case 1: {
                return BedrockRuntimeImpl.parseAnthropicClaudeContentBlock(contentBlock);
            }
        }
        return null;
    }

    @Nullable
    private static ContentBlock parseAmazonNovaContentBlock(Document contentBlock) {
        Document toolUseId;
        Document text = (Document)contentBlock.asMap().get("text");
        if (text != null && text.isString()) {
            return ContentBlock.fromText((String)text.asString());
        }
        Document toolUse = (Document)contentBlock.asMap().get("toolUse");
        if (toolUse != null && toolUse.isMap()) {
            ToolUseBlock.Builder toolUseBlock = ToolUseBlock.builder();
            BedrockRuntimeImpl.handleToolUseAmazonNova(toolUse, toolUseBlock);
            return ContentBlock.fromToolUse((ToolUseBlock)((ToolUseBlock)toolUseBlock.build()));
        }
        Document toolResult = (Document)contentBlock.asMap().get("toolResult");
        if (toolResult != null && toolResult.isMap() && (toolUseId = (Document)toolResult.asMap().get("toolUseId")) != null && toolUseId.isString()) {
            ToolResultBlock.Builder resultBlockBuilder = ToolResultBlock.builder().toolUseId(toolUseId.asString());
            Document toolResultContent = (Document)toolResult.asMap().get("content");
            if (toolResultContent != null && toolResultContent.isList()) {
                List toolResultContentBlocks = toolResultContent.asList().stream().map(toolResultContentBlockDoc -> {
                    Document json;
                    if (toolResultContentBlockDoc.isMap() && (json = (Document)toolResultContentBlockDoc.asMap().get("json")) != null) {
                        return (ToolResultContentBlock)ToolResultContentBlock.builder().json(json).build();
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                resultBlockBuilder.content(toolResultContentBlocks);
            }
            return ContentBlock.fromToolResult((ToolResultBlock)((ToolResultBlock)resultBlockBuilder.build()));
        }
        return null;
    }

    @Nullable
    private static ContentBlock parseAnthropicClaudeContentBlock(Document contentBlock) {
        Document type = (Document)contentBlock.asMap().get("type");
        if (type == null || !type.isString()) {
            return null;
        }
        switch (type.asString()) {
            case "text": {
                Document text = (Document)contentBlock.asMap().get("text");
                if (text != null && text.isString()) {
                    return ContentBlock.fromText((String)text.asString());
                }
                return null;
            }
            case "tool_use": {
                ToolUseBlock.Builder toolUseBlock = ToolUseBlock.builder();
                BedrockRuntimeImpl.handleToolUseAnthropicCloud(contentBlock, toolUseBlock);
                return ContentBlock.fromToolUse((ToolUseBlock)((ToolUseBlock)toolUseBlock.build()));
            }
            case "tool_result": {
                Document toolUseId = (Document)contentBlock.asMap().get("tool_use_id");
                if (toolUseId != null && toolUseId.isString()) {
                    ToolResultBlock.Builder resultBlockBuilder = ToolResultBlock.builder().toolUseId(toolUseId.asString());
                    Document toolResultContent = (Document)contentBlock.asMap().get("content");
                    if (toolResultContent != null) {
                        resultBlockBuilder.content(new ToolResultContentBlock[]{ToolResultContentBlock.fromJson((Document)toolResultContent)});
                    }
                    return ContentBlock.fromToolResult((ToolResultBlock)((ToolResultBlock)resultBlockBuilder.build()));
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static Long integerToLong(Integer value) {
        if (value == null) {
            return null;
        }
        return (long)value;
    }

    @Nullable
    private static Double floatToDouble(Float value) {
        if (value == null) {
            return null;
        }
        return value.floatValue();
    }

    public static BedrockRuntimeAsyncClient wrap(BedrockRuntimeAsyncClient asyncClient, Logger eventLogger, boolean captureMessageContent) {
        return (BedrockRuntimeAsyncClient)Proxy.newProxyInstance(asyncClient.getClass().getClassLoader(), new Class[]{BedrockRuntimeAsyncClient.class}, (proxy, method, args) -> {
            if (method.getName().equals("converseStream") && args.length >= 2 && args[1] instanceof ConverseStreamResponseHandler) {
                TracingConverseStreamResponseHandler wrapped = new TracingConverseStreamResponseHandler((ConverseStreamResponseHandler)args[1], eventLogger, captureMessageContent);
                args[1] = wrapped;
                try (Scope ignored = wrapped.makeCurrent();){
                    Object object = BedrockRuntimeImpl.invokeProxyMethod(method, asyncClient, args);
                    return object;
                }
            }
            if (method.getName().equals("invokeModelWithResponseStream") && args.length >= 2 && args[0] instanceof InvokeModelWithResponseStreamRequest && args[1] instanceof InvokeModelWithResponseStreamResponseHandler) {
                InvokeModelWithResponseStreamRequest request = (InvokeModelWithResponseStreamRequest)args[0];
                TracingInvokeModelWithResponseStreamResponseHandler wrapped = new TracingInvokeModelWithResponseStreamResponseHandler((InvokeModelWithResponseStreamResponseHandler)args[1], eventLogger, captureMessageContent, request.modelId());
                args[1] = wrapped;
                try (Scope ignored = wrapped.makeCurrent();){
                    Object object = BedrockRuntimeImpl.invokeProxyMethod(method, asyncClient, args);
                    return object;
                }
            }
            return BedrockRuntimeImpl.invokeProxyMethod(method, asyncClient, args);
        });
    }

    private static Object invokeProxyMethod(Method method, Object target, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException exception) {
            throw exception.getCause();
        }
    }

    private static LogRecordBuilder newEvent(Context otelContext, Logger eventLogger) {
        return eventLogger.logRecordBuilder().setContext(otelContext).setAttribute(GEN_AI_SYSTEM, (Object)"aws.bedrock");
    }

    private static void emitToolResultEvents(Context otelContext, Logger eventLogger, Message message, boolean captureMessageContent) {
        for (ContentBlock content : message.content()) {
            if (content.toolResult() == null) continue;
            HashMap<String, Value> body = new HashMap<String, Value>();
            body.put("id", Value.of((String)content.toolResult().toolUseId()));
            if (captureMessageContent) {
                StringBuilder text = new StringBuilder();
                for (ToolResultContentBlock toolContent : content.toolResult().content()) {
                    if (toolContent.text() != null) {
                        text.append(toolContent.text());
                    }
                    if (toolContent.json() == null) continue;
                    text.append(BedrockRuntimeImpl.serializeDocument(toolContent.json()));
                }
                body.put("content", Value.of((String)text.toString()));
            }
            BedrockRuntimeImpl.newEvent(otelContext, eventLogger).setAttribute(EVENT_NAME, (Object)"gen_ai.tool.message").setBody(Value.of(body)).emit();
        }
    }

    private static Value<?> convertMessage(Message message, int index, @Nullable String stopReason, boolean captureMessageContent) {
        StringBuilder text = null;
        ArrayList<ToolUseBlock> toolCalls = null;
        for (ContentBlock content : message.content()) {
            if (captureMessageContent && content.text() != null) {
                if (text == null) {
                    text = new StringBuilder();
                }
                text.append(content.text());
            }
            if (content.toolUse() == null) continue;
            if (toolCalls == null) {
                toolCalls = new ArrayList<ToolUseBlock>();
            }
            toolCalls.add(content.toolUse());
        }
        return BedrockRuntimeImpl.convertMessageData(text, toolCalls, index, stopReason, captureMessageContent);
    }

    private static void handleToolUseAmazonNova(Document toolUse, ToolUseBlock.Builder currentTool) {
        Document input;
        Document name;
        Document toolUseId = (Document)toolUse.asMap().get("toolUseId");
        if (toolUseId != null && toolUseId.isString()) {
            currentTool.toolUseId(toolUseId.asString());
        }
        if ((name = (Document)toolUse.asMap().get("name")) != null && name.isString()) {
            currentTool.name(name.asString());
        }
        if ((input = (Document)toolUse.asMap().get("input")) != null) {
            Document parsedInput = input.isString() ? BedrockRuntimeImpl.deserializeDocument(input.asString()) : input;
            currentTool.input(parsedInput);
        }
    }

    private static void handleToolUseAnthropicCloud(Document toolUse, ToolUseBlock.Builder currentTool) {
        Document input;
        Document name;
        Document toolUseId = (Document)toolUse.asMap().get("id");
        if (toolUseId != null && toolUseId.isString()) {
            currentTool.toolUseId(toolUseId.asString());
        }
        if ((name = (Document)toolUse.asMap().get("name")) != null && name.isString()) {
            currentTool.name(name.asString());
        }
        if ((input = (Document)toolUse.asMap().get("input")) != null) {
            currentTool.input(input);
        }
    }

    private static Value<?> convertMessageData(@Nullable StringBuilder text, List<ToolUseBlock> toolCalls, int index, @Nullable String stopReason, boolean captureMessageContent) {
        HashMap<String, Value> body = new HashMap<String, Value>();
        if (text != null) {
            body.put("content", Value.of((String)text.toString()));
        }
        if (toolCalls != null) {
            List toolCallValues = toolCalls.stream().map(tool -> BedrockRuntimeImpl.convertToolCall(tool, captureMessageContent)).collect(Collectors.toList());
            body.put("toolCalls", Value.of(toolCallValues));
        }
        if (stopReason != null) {
            body.put("finish_reason", Value.of((String)stopReason.toString()));
        }
        if (index >= 0) {
            body.put("index", Value.of((long)index));
        }
        return Value.of(body);
    }

    private static Value<?> convertToolCall(ToolUseBlock toolCall, boolean captureMessageContent) {
        HashMap<String, Value> body = new HashMap<String, Value>();
        body.put("id", Value.of((String)toolCall.toolUseId()));
        body.put("name", Value.of((String)toolCall.name()));
        body.put("type", Value.of((String)"function"));
        if (captureMessageContent) {
            body.put("arguments", Value.of((String)BedrockRuntimeImpl.serializeDocument(toolCall.input())));
        }
        return Value.of(body);
    }

    private static String serializeDocument(Document document) {
        SdkJsonGenerator generator = new SdkJsonGenerator(JSON_FACTORY, "application/json");
        DocumentTypeJsonMarshaller marshaller = new DocumentTypeJsonMarshaller((StructuredJsonGenerator)generator);
        document.accept((VoidDocumentVisitor)marshaller);
        return new String(generator.getBytes(), StandardCharsets.UTF_8);
    }

    private static Document deserializeDocument(String json) {
        JsonNode node = JSON_PARSER.parse(json);
        return (Document)node.visit((JsonNodeVisitor)DOCUMENT_UNMARSHALLER);
    }

    private static Document deserializeDocument(byte[] json) {
        JsonNode node = JSON_PARSER.parse(json);
        return (Document)node.visit((JsonNodeVisitor)DOCUMENT_UNMARSHALLER);
    }

    private static final class GenAiOperationNameIncubatingValues {
        static final String CHAT = "chat";
        static final String TEXT_COMPLETION = "text_completion";

        private GenAiOperationNameIncubatingValues() {
        }
    }

    static abstract class BedrockRuntimeStreamResponseHandler<R, S>
    implements EventStreamResponseHandler<R, S>,
    ImplicitContextKeyed {
        private static final ContextKey<BedrockRuntimeStreamResponseHandler<?, ?>> KEY = ContextKey.named((String)"bedrock-runtime-stream-response-handler");
        private final EventStreamResponseHandler<R, S> delegate;
        volatile Context otelContext;
        List<String> stopReasons;
        TokenUsage usage;

        @Nullable
        public static BedrockRuntimeStreamResponseHandler<?, ?> fromContext(Context context) {
            return (BedrockRuntimeStreamResponseHandler)context.get(KEY);
        }

        BedrockRuntimeStreamResponseHandler(EventStreamResponseHandler<R, S> delegate) {
            this.delegate = delegate;
        }

        protected abstract void handleEvent(S var1);

        public final void responseReceived(R response) {
            this.delegate.responseReceived(response);
        }

        public final void onEventStream(SdkPublisher<S> sdkPublisher) {
            this.delegate.onEventStream(sdkPublisher.map(event -> {
                this.handleEvent(event);
                return event;
            }));
        }

        public final void exceptionOccurred(Throwable throwable) {
            this.delegate.exceptionOccurred(throwable);
        }

        public final void complete() {
            this.delegate.complete();
        }

        public final Context storeInContext(Context context) {
            return context.with(KEY, (Object)this);
        }

        final void setOtelContext(Context otelContext) {
            this.otelContext = otelContext;
        }
    }

    private static enum ModelFamily {
        AMAZON_NOVA,
        ANTHROPIC_CLAUDE;

    }

    public static class TracingConverseStreamResponseHandler
    extends BedrockRuntimeStreamResponseHandler<ConverseStreamResponse, ConverseStreamOutput>
    implements ConverseStreamResponseHandler {
        private final Logger eventLogger;
        private final boolean captureMessageContent;
        private StringBuilder currentText;
        private List<ToolUseBlock> tools;
        private ToolUseBlock.Builder currentTool;
        private StringBuilder currentToolArgs;

        TracingConverseStreamResponseHandler(ConverseStreamResponseHandler delegate, Logger eventLogger, boolean captureMessageContent) {
            super(delegate);
            this.eventLogger = eventLogger;
            this.captureMessageContent = captureMessageContent;
        }

        @Override
        protected void handleEvent(ConverseStreamOutput event) {
            ToolUseBlockStart toolUse;
            if (this.captureMessageContent && event instanceof MessageStartEvent) {
                if (this.currentText == null) {
                    this.currentText = new StringBuilder();
                }
                this.currentText.setLength(0);
            }
            if (event instanceof ContentBlockStartEvent && (toolUse = ((ContentBlockStartEvent)event).start().toolUse()) != null) {
                if (this.currentToolArgs == null) {
                    this.currentToolArgs = new StringBuilder();
                }
                this.currentToolArgs.setLength(0);
                this.currentTool = ToolUseBlock.builder().name(toolUse.name()).toolUseId(toolUse.toolUseId());
            }
            if (event instanceof ContentBlockDeltaEvent) {
                ContentBlockDelta delta = ((ContentBlockDeltaEvent)event).delta();
                if (this.captureMessageContent && delta.text() != null) {
                    this.currentText.append(delta.text());
                }
                if (delta.toolUse() != null) {
                    this.currentToolArgs.append(delta.toolUse().input());
                }
            }
            if (event instanceof ContentBlockStopEvent && this.currentTool != null) {
                if (this.tools == null) {
                    this.tools = new ArrayList<ToolUseBlock>();
                }
                if (this.currentToolArgs != null) {
                    Document args = BedrockRuntimeImpl.deserializeDocument(this.currentToolArgs.toString());
                    this.currentTool.input(args);
                }
                this.tools.add((ToolUseBlock)this.currentTool.build());
                this.currentTool = null;
            }
            if (event instanceof MessageStopEvent) {
                if (this.stopReasons == null) {
                    this.stopReasons = new ArrayList();
                }
                String stopReason = ((MessageStopEvent)event).stopReasonAsString();
                this.stopReasons.add(stopReason);
                BedrockRuntimeImpl.newEvent(this.otelContext, this.eventLogger).setAttribute(EVENT_NAME, (Object)"gen_ai.choice").setBody(BedrockRuntimeImpl.convertMessageData(this.currentText, this.tools, 0, stopReason, this.captureMessageContent)).emit();
            }
            if (event instanceof ConverseStreamMetadataEvent) {
                this.usage = ((ConverseStreamMetadataEvent)event).usage();
            }
        }
    }

    public static class TracingInvokeModelWithResponseStreamResponseHandler
    extends BedrockRuntimeStreamResponseHandler<InvokeModelWithResponseStreamResponse, ResponseStream>
    implements InvokeModelWithResponseStreamResponseHandler {
        private final Logger eventLogger;
        private final boolean captureMessageContent;
        private final String requestModel;
        @Nullable
        private StringBuilder currentText;
        @Nullable
        private List<ToolUseBlock> tools;
        @Nullable
        private ToolUseBlock.Builder currentTool;
        @Nullable
        private StringBuilder currentInputJson;
        private int inputTokens;
        private int outputTokens;

        TracingInvokeModelWithResponseStreamResponseHandler(InvokeModelWithResponseStreamResponseHandler delegate, Logger eventLogger, boolean captureMessageContent, String requestModel) {
            super(delegate);
            this.eventLogger = eventLogger;
            this.captureMessageContent = captureMessageContent;
            this.requestModel = requestModel;
        }

        @Override
        protected void handleEvent(ResponseStream event) {
            if (!(event instanceof PayloadPart)) {
                return;
            }
            Document result = BedrockRuntimeImpl.deserializeDocument(((PayloadPart)event).bytes().asByteArrayUnsafe());
            if (this.requestModel.startsWith("amazon.titan")) {
                this.handleEventAmazonTitan(result);
            } else if (this.requestModel.startsWith("amazon.nova")) {
                this.handleEventAmazonNova(result);
            } else if (this.requestModel.startsWith("anthropic.claude")) {
                this.handleEventAnthropicClaude(result);
            }
        }

        private void handleEventAmazonTitan(Document result) {
            Document stopReasonDoc;
            Document outputTokens;
            Document inputTokens;
            Document resultText;
            if (this.captureMessageContent && (resultText = (Document)result.asMap().get("outputText")) != null && resultText.isString()) {
                if (this.currentText == null) {
                    this.currentText = new StringBuilder();
                }
                this.currentText.append(resultText.asString());
            }
            if ((inputTokens = (Document)result.asMap().get("inputTextTokenCount")) != null && inputTokens.isNumber()) {
                this.inputTokens = inputTokens.asNumber().intValue();
            }
            if ((outputTokens = (Document)result.asMap().get("totalOutputTextTokenCount")) != null && outputTokens.isNumber()) {
                this.outputTokens = outputTokens.asNumber().intValue();
            }
            if ((stopReasonDoc = (Document)result.asMap().get("completionReason")) != null && stopReasonDoc.isString()) {
                String stopReason = stopReasonDoc.asString();
                if (this.stopReasons == null) {
                    this.stopReasons = new ArrayList();
                }
                this.stopReasons.add(stopReason);
                BedrockRuntimeImpl.newEvent(this.otelContext, this.eventLogger).setAttribute(EVENT_NAME, (Object)"gen_ai.choice").setBody(BedrockRuntimeImpl.convertMessageData(this.currentText, null, 0, stopReason, this.captureMessageContent)).emit();
                this.usage = (TokenUsage)TokenUsage.builder().inputTokens(Integer.valueOf(this.inputTokens)).outputTokens(Integer.valueOf(this.outputTokens)).build();
            }
        }

        private void handleEventAmazonNova(Document result) {
            Document messageStop;
            if (result.asMap().get("messageStart") != null) {
                if (this.captureMessageContent) {
                    if (this.currentText == null) {
                        this.currentText = new StringBuilder();
                    }
                    this.currentText.setLength(0);
                }
                return;
            }
            Document contentBlockStart = (Document)result.asMap().get("contentBlockStart");
            if (contentBlockStart != null && contentBlockStart.isMap()) {
                Document toolUse;
                Document start = (Document)contentBlockStart.asMap().get("start");
                if (start != null && start.isMap() && (toolUse = (Document)start.asMap().get("toolUse")) != null && toolUse.isMap()) {
                    this.currentTool = ToolUseBlock.builder();
                    BedrockRuntimeImpl.handleToolUseAmazonNova(toolUse, this.currentTool);
                }
                return;
            }
            Document contentBlockDelta = (Document)result.asMap().get("contentBlockDelta");
            if (contentBlockDelta != null && contentBlockDelta.isMap()) {
                Document toolUse;
                Document text;
                Document delta = (Document)contentBlockDelta.asMap().get("delta");
                if (delta == null || !delta.isMap()) {
                    return;
                }
                if (this.captureMessageContent && (text = (Document)delta.asMap().get("text")) != null && text.isString()) {
                    this.currentText.append(text.asString());
                }
                if ((toolUse = (Document)delta.asMap().get("toolUse")) != null && toolUse.isMap()) {
                    BedrockRuntimeImpl.handleToolUseAmazonNova(toolUse, this.currentTool);
                }
                return;
            }
            if (result.asMap().get("contentBlockStop") != null && this.currentTool != null) {
                if (this.tools == null) {
                    this.tools = new ArrayList<ToolUseBlock>();
                }
                this.tools.add((ToolUseBlock)this.currentTool.build());
                this.currentTool = null;
            }
            if ((messageStop = (Document)result.asMap().get("messageStop")) != null && messageStop.isMap()) {
                Document stopReasonDoc = (Document)messageStop.asMap().get("stopReason");
                if (stopReasonDoc == null || !stopReasonDoc.isString()) {
                    return;
                }
                if (this.stopReasons == null) {
                    this.stopReasons = new ArrayList();
                }
                String stopReason = stopReasonDoc.asString();
                this.stopReasons.add(stopReason);
                BedrockRuntimeImpl.newEvent(this.otelContext, this.eventLogger).setAttribute(EVENT_NAME, (Object)"gen_ai.choice").setBody(BedrockRuntimeImpl.convertMessageData(this.currentText, this.tools, 0, stopReason, this.captureMessageContent)).emit();
                return;
            }
            Document metadata = (Document)result.asMap().get("metadata");
            if (metadata != null && metadata.isMap()) {
                Document usage = (Document)metadata.asMap().get("usage");
                if (usage == null || !usage.isMap()) {
                    return;
                }
                Document inputTokens = (Document)usage.asMap().get("inputTokens");
                Document outputTokens = (Document)usage.asMap().get("outputTokens");
                if (inputTokens != null && inputTokens.isNumber() && outputTokens != null && outputTokens.isNumber()) {
                    this.usage = (TokenUsage)TokenUsage.builder().inputTokens(Integer.valueOf(inputTokens.asNumber().intValue())).outputTokens(Integer.valueOf(outputTokens.asNumber().intValue())).build();
                }
            }
        }

        private void handleEventAnthropicClaude(Document result) {
            Document type = (Document)result.asMap().get("type");
            if (type == null || !type.isString()) {
                return;
            }
            switch (type.asString()) {
                case "message_start": {
                    Document message;
                    if (this.captureMessageContent) {
                        if (this.currentText == null) {
                            this.currentText = new StringBuilder();
                        }
                        this.currentText.setLength(0);
                    }
                    if ((message = (Document)result.asMap().get("message")) == null || !message.isMap()) {
                        return;
                    }
                    Document usage = (Document)message.asMap().get("usage");
                    if (usage != null && usage.isMap()) {
                        Document outputTokens;
                        Document inputTokens = (Document)usage.asMap().get("input_tokens");
                        if (inputTokens != null && inputTokens.isNumber()) {
                            this.inputTokens = inputTokens.asNumber().intValue();
                        }
                        if ((outputTokens = (Document)usage.asMap().get("output_tokens")) != null && outputTokens.isNumber()) {
                            this.outputTokens = outputTokens.asNumber().intValue();
                        }
                    }
                    return;
                }
                case "content_block_start": {
                    Document contentBlock = (Document)result.asMap().get("content_block");
                    if (contentBlock == null || !contentBlock.isMap()) {
                        return;
                    }
                    Document contentBlockType = (Document)contentBlock.asMap().get("type");
                    if (contentBlockType == null || !contentBlockType.isString()) {
                        return;
                    }
                    if (contentBlockType.asString().equals("tool_use")) {
                        this.currentTool = ToolUseBlock.builder();
                        BedrockRuntimeImpl.handleToolUseAnthropicCloud(contentBlock, this.currentTool);
                    }
                    return;
                }
                case "content_block_delta": {
                    Document delta = (Document)result.asMap().get("delta");
                    if (delta == null || !delta.isMap()) {
                        return;
                    }
                    Document deltaType = (Document)delta.asMap().get("type");
                    if (deltaType == null || !deltaType.isString()) {
                        return;
                    }
                    switch (deltaType.asString()) {
                        case "text_delta": {
                            Document text;
                            if (this.captureMessageContent && (text = (Document)delta.asMap().get("text")) != null && text.isString()) {
                                this.currentText.append(text.asString());
                            }
                            return;
                        }
                        case "input_json_delta": {
                            Document json = (Document)delta.asMap().get("partial_json");
                            if (json != null && json.isString()) {
                                if (this.currentInputJson == null) {
                                    this.currentInputJson = new StringBuilder();
                                }
                                this.currentInputJson.append(json.asString());
                            }
                            return;
                        }
                    }
                    return;
                }
                case "content_block_stop": {
                    if (this.currentTool != null) {
                        if (this.currentInputJson != null) {
                            this.currentTool.input(BedrockRuntimeImpl.deserializeDocument(this.currentInputJson.toString()));
                            this.currentInputJson.setLength(0);
                        }
                        if (this.tools == null) {
                            this.tools = new ArrayList<ToolUseBlock>();
                        }
                        this.tools.add((ToolUseBlock)this.currentTool.build());
                        this.currentTool = null;
                    }
                    return;
                }
                case "message_delta": {
                    Document outputTokens;
                    Document usage;
                    Document stopReasonDoc;
                    Document delta = (Document)result.asMap().get("delta");
                    if (delta != null && delta.isMap() && (stopReasonDoc = (Document)delta.asMap().get("stop_reason")) != null && stopReasonDoc.isString()) {
                        String stopReason = stopReasonDoc.asString();
                        if (this.stopReasons == null) {
                            this.stopReasons = new ArrayList();
                        }
                        this.stopReasons.add(stopReason);
                        BedrockRuntimeImpl.newEvent(this.otelContext, this.eventLogger).setAttribute(EVENT_NAME, (Object)"gen_ai.choice").setBody(BedrockRuntimeImpl.convertMessageData(this.currentText, this.tools, 0, stopReason, this.captureMessageContent)).emit();
                    }
                    if ((usage = (Document)result.asMap().get("usage")) != null && usage.isMap() && (outputTokens = (Document)usage.asMap().get("output_tokens")) != null && outputTokens.isNumber()) {
                        this.outputTokens = outputTokens.asNumber().intValue();
                    }
                    this.usage = (TokenUsage)TokenUsage.builder().inputTokens(Integer.valueOf(this.inputTokens)).outputTokens(Integer.valueOf(this.outputTokens)).build();
                    return;
                }
            }
        }
    }
}

