/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class OrcColumnId
implements Comparable<OrcColumnId> {
    public static final OrcColumnId ROOT_COLUMN = new OrcColumnId(0);
    private final int id;

    public OrcColumnId(int id) {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id is negative");
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrcColumnId that = (OrcColumnId)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(OrcColumnId o) {
        return Integer.compare(this.id, o.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).toString();
    }
}

