/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.inject.Inject;
import io.trino.filesystem.s3.S3SecurityMappingConfig;
import io.trino.filesystem.s3.S3SecurityMappings;
import io.trino.plugin.base.util.JsonUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Supplier;

class S3SecurityMappingsFileSource
implements Supplier<S3SecurityMappings> {
    private final File configFile;
    private final String jsonPointer;

    @Inject
    public S3SecurityMappingsFileSource(S3SecurityMappingConfig config) {
        this.configFile = config.getConfigFile().orElseThrow();
        this.jsonPointer = config.getJsonPointer();
    }

    @Override
    public S3SecurityMappings get() {
        return (S3SecurityMappings)JsonUtils.parseJson((Path)this.configFile.toPath(), (String)this.jsonPointer, S3SecurityMappings.class);
    }
}

