/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Objects;

public class ParquetReaderOptions {
    private static final DataSize DEFAULT_MAX_READ_BLOCK_SIZE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final int DEFAULT_MAX_READ_BLOCK_ROW_COUNT = 8192;
    private static final DataSize DEFAULT_MAX_MERGE_DISTANCE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_SMALL_FILE_THRESHOLD = DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final boolean ignoreStatistics;
    private final DataSize maxReadBlockSize;
    private final int maxReadBlockRowCount;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;
    private final boolean useColumnIndex;
    private final boolean useBloomFilter;
    private final DataSize smallFileThreshold;
    private final boolean vectorizedDecodingEnabled;

    private ParquetReaderOptions() {
        this.ignoreStatistics = false;
        this.maxReadBlockSize = DEFAULT_MAX_READ_BLOCK_SIZE;
        this.maxReadBlockRowCount = 8192;
        this.maxMergeDistance = DEFAULT_MAX_MERGE_DISTANCE;
        this.maxBufferSize = DEFAULT_MAX_BUFFER_SIZE;
        this.useColumnIndex = true;
        this.useBloomFilter = true;
        this.smallFileThreshold = DEFAULT_SMALL_FILE_THRESHOLD;
        this.vectorizedDecodingEnabled = true;
    }

    private ParquetReaderOptions(boolean ignoreStatistics, DataSize maxReadBlockSize, int maxReadBlockRowCount, DataSize maxMergeDistance, DataSize maxBufferSize, boolean useColumnIndex, boolean useBloomFilter, DataSize smallFileThreshold, boolean vectorizedDecodingEnabled) {
        this.ignoreStatistics = ignoreStatistics;
        this.maxReadBlockSize = Objects.requireNonNull(maxReadBlockSize, "maxReadBlockSize is null");
        Preconditions.checkArgument((maxReadBlockRowCount > 0 ? 1 : 0) != 0, (Object)"maxReadBlockRowCount must be greater than 0");
        this.maxReadBlockRowCount = maxReadBlockRowCount;
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.useColumnIndex = useColumnIndex;
        this.useBloomFilter = useBloomFilter;
        this.smallFileThreshold = Objects.requireNonNull(smallFileThreshold, "smallFileThreshold is null");
        this.vectorizedDecodingEnabled = vectorizedDecodingEnabled;
    }

    public static Builder builder() {
        return new Builder(new ParquetReaderOptions());
    }

    public static Builder builder(ParquetReaderOptions parquetReaderOptions) {
        return new Builder(parquetReaderOptions);
    }

    public static ParquetReaderOptions defaultOptions() {
        return new ParquetReaderOptions();
    }

    public boolean isIgnoreStatistics() {
        return this.ignoreStatistics;
    }

    public DataSize getMaxReadBlockSize() {
        return this.maxReadBlockSize;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public boolean isUseColumnIndex() {
        return this.useColumnIndex;
    }

    public boolean useBloomFilter() {
        return this.useBloomFilter;
    }

    public boolean isVectorizedDecodingEnabled() {
        return this.vectorizedDecodingEnabled;
    }

    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getMaxReadBlockRowCount() {
        return this.maxReadBlockRowCount;
    }

    public DataSize getSmallFileThreshold() {
        return this.smallFileThreshold;
    }

    public static class Builder {
        private boolean ignoreStatistics;
        private DataSize maxReadBlockSize;
        private int maxReadBlockRowCount;
        private DataSize maxMergeDistance;
        private DataSize maxBufferSize;
        private boolean useColumnIndex;
        private boolean useBloomFilter;
        private DataSize smallFileThreshold;
        private boolean vectorizedDecodingEnabled;

        private Builder(ParquetReaderOptions parquetReaderOptions) {
            Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
            this.ignoreStatistics = parquetReaderOptions.ignoreStatistics;
            this.maxReadBlockSize = parquetReaderOptions.maxReadBlockSize;
            this.maxReadBlockRowCount = parquetReaderOptions.maxReadBlockRowCount;
            this.maxMergeDistance = parquetReaderOptions.maxMergeDistance;
            this.maxBufferSize = parquetReaderOptions.maxBufferSize;
            this.useColumnIndex = parquetReaderOptions.useColumnIndex;
            this.useBloomFilter = parquetReaderOptions.useBloomFilter;
            this.smallFileThreshold = parquetReaderOptions.smallFileThreshold;
            this.vectorizedDecodingEnabled = parquetReaderOptions.vectorizedDecodingEnabled;
        }

        public Builder withIgnoreStatistics(boolean ignoreStatistics) {
            this.ignoreStatistics = ignoreStatistics;
            return this;
        }

        public Builder withMaxReadBlockSize(DataSize maxReadBlockSize) {
            this.maxReadBlockSize = Objects.requireNonNull(maxReadBlockSize, "maxReadBlockSize is null");
            return this;
        }

        public Builder withMaxReadBlockRowCount(int maxReadBlockRowCount) {
            this.maxReadBlockRowCount = maxReadBlockRowCount;
            return this;
        }

        public Builder withMaxMergeDistance(DataSize maxMergeDistance) {
            this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
            return this;
        }

        public Builder withMaxBufferSize(DataSize maxBufferSize) {
            this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
            return this;
        }

        public Builder withUseColumnIndex(boolean useColumnIndex) {
            this.useColumnIndex = useColumnIndex;
            return this;
        }

        public Builder withBloomFilter(boolean useBloomFilter) {
            this.useBloomFilter = useBloomFilter;
            return this;
        }

        public Builder withSmallFileThreshold(DataSize smallFileThreshold) {
            this.smallFileThreshold = Objects.requireNonNull(smallFileThreshold, "smallFileThreshold is null");
            return this;
        }

        public Builder withVectorizedDecodingEnabled(boolean vectorizedDecodingEnabled) {
            this.vectorizedDecodingEnabled = vectorizedDecodingEnabled;
            return this;
        }

        public ParquetReaderOptions build() {
            return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxReadBlockRowCount, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex, this.useBloomFilter, this.smallFileThreshold, this.vectorizedDecodingEnabled);
        }
    }
}

