/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetMetadataConverter;
import io.trino.parquet.ParquetValidationUtils;
import io.trino.parquet.ParquetWriteValidation;
import io.trino.parquet.metadata.FileMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import org.apache.parquet.CorruptStatistics;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.Util;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public final class MetadataReader {
    private static final Slice MAGIC = Slices.utf8Slice((String)"PAR1");
    private static final int POST_SCRIPT_SIZE = 4 + MAGIC.length();
    private static final int EXPECTED_FOOTER_SIZE = 49152;

    private MetadataReader() {
    }

    public static ParquetMetadata readFooter(ParquetDataSource dataSource, Optional<ParquetWriteValidation> parquetWriteValidation) throws IOException {
        ParquetValidationUtils.validateParquet(dataSource.getEstimatedSize() >= (long)(MAGIC.length() + POST_SCRIPT_SIZE), dataSource.getId(), "%s is not a valid Parquet File", dataSource.getId());
        long estimatedFileSize = dataSource.getEstimatedSize();
        long expectedReadSize = Math.min(estimatedFileSize, 49152L);
        Slice buffer = dataSource.readTail(Math.toIntExact(expectedReadSize));
        Slice magic = buffer.slice(buffer.length() - MAGIC.length(), MAGIC.length());
        ParquetValidationUtils.validateParquet(MAGIC.equals((Object)magic), dataSource.getId(), "Expected magic number: %s got: %s", MAGIC.toStringUtf8(), magic.toStringUtf8());
        int metadataLength = buffer.getInt(buffer.length() - POST_SCRIPT_SIZE);
        long metadataIndex = estimatedFileSize - (long)POST_SCRIPT_SIZE - (long)metadataLength;
        ParquetValidationUtils.validateParquet(metadataIndex >= (long)MAGIC.length() && metadataIndex < estimatedFileSize - (long)POST_SCRIPT_SIZE, dataSource.getId(), "Metadata index: %s out of range", metadataIndex);
        int completeFooterSize = metadataLength + POST_SCRIPT_SIZE;
        if (completeFooterSize > buffer.length()) {
            buffer = dataSource.readTail(completeFooterSize);
        }
        BasicSliceInput metadataStream = buffer.slice(buffer.length() - completeFooterSize, metadataLength).getInput();
        FileMetaData fileMetaData = Util.readFileMetaData((InputStream)metadataStream);
        ParquetMetadata parquetMetadata = new ParquetMetadata(fileMetaData, dataSource.getId());
        MetadataReader.validateFileMetadata(dataSource.getId(), parquetMetadata.getFileMetaData(), parquetWriteValidation);
        return parquetMetadata;
    }

    public static Statistics<?> readStats(Optional<String> fileCreatedBy, Optional<org.apache.parquet.format.Statistics> statisticsFromFile, PrimitiveType type) {
        org.apache.parquet.format.Statistics statistics = statisticsFromFile.orElse(null);
        Statistics<?> columnStatistics = ParquetMetadataConverter.fromParquetStatistics(fileCreatedBy.orElse(null), statistics, type);
        if (MetadataReader.isStringType(type) && statistics != null && !statistics.isSetMin_value() && !statistics.isSetMax_value() && statistics.isSetMin() && statistics.isSetMax() && columnStatistics.genericGetMin() == null && columnStatistics.genericGetMax() == null && !CorruptStatistics.shouldIgnoreStatistics((String)fileCreatedBy.orElse(null), (PrimitiveType.PrimitiveTypeName)type.getPrimitiveTypeName())) {
            columnStatistics = MetadataReader.tryReadOldUtf8Stats(statistics, (BinaryStatistics)columnStatistics);
        }
        return columnStatistics;
    }

    private static boolean isStringType(PrimitiveType type) {
        if (type.getLogicalTypeAnnotation() == null) {
            return false;
        }
        return type.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Boolean>(){

            public Optional<Boolean> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                return Optional.of(Boolean.TRUE);
            }
        }).orElse(Boolean.FALSE);
    }

    private static Statistics<?> tryReadOldUtf8Stats(org.apache.parquet.format.Statistics statistics, BinaryStatistics columnStatistics) {
        byte[] max;
        byte[] min = statistics.getMin();
        if (Arrays.equals(min, max = statistics.getMax())) {
            min = (byte[])min.clone();
            max = min;
        } else {
            int commonPrefix;
            int minGoodLength;
            for (minGoodLength = commonPrefix = MetadataReader.commonPrefix(min, max); minGoodLength < min.length && MetadataReader.isAscii(min[minGoodLength]); ++minGoodLength) {
            }
            int maxGoodLength = commonPrefix;
            if (maxGoodLength < max.length && maxGoodLength < min.length && MetadataReader.isAscii(min[maxGoodLength]) && MetadataReader.isAscii(max[maxGoodLength])) {
                ++maxGoodLength;
            }
            while (!(maxGoodLength <= 0 || max[maxGoodLength - 1] != 127 && MetadataReader.isAscii(max[maxGoodLength - 1]))) {
                --maxGoodLength;
            }
            if (maxGoodLength == 0) {
                return columnStatistics;
            }
            min = Arrays.copyOf(min, minGoodLength);
            max = Arrays.copyOf(max, maxGoodLength);
            int n = maxGoodLength - 1;
            max[n] = (byte)(max[n] + 1);
        }
        return Statistics.getBuilderForReading((PrimitiveType)columnStatistics.type()).withMin(min).withMax(max).withNumNulls(!columnStatistics.isNumNullsSet() && statistics.isSetNull_count() ? statistics.getNull_count() : columnStatistics.getNumNulls()).build();
    }

    private static boolean isAscii(byte b) {
        return 0 <= b;
    }

    private static int commonPrefix(byte[] a, byte[] b) {
        int commonPrefixLength;
        for (commonPrefixLength = 0; commonPrefixLength < a.length && commonPrefixLength < b.length && a[commonPrefixLength] == b[commonPrefixLength]; ++commonPrefixLength) {
        }
        return commonPrefixLength;
    }

    private static void validateFileMetadata(ParquetDataSourceId dataSourceId, FileMetadata fileMetaData, Optional<ParquetWriteValidation> parquetWriteValidation) throws ParquetCorruptionException {
        if (parquetWriteValidation.isEmpty()) {
            return;
        }
        ParquetWriteValidation writeValidation = parquetWriteValidation.get();
        writeValidation.validateTimeZone(dataSourceId, Optional.ofNullable(fileMetaData.getKeyValueMetaData().get("writer.time.zone")));
        writeValidation.validateColumns(dataSourceId, fileMetaData.getSchema());
    }
}

