/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.IntBitUnpacker;
import io.trino.parquet.reader.decoders.IntBitUnpackers;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.decoders.VectorIntBitUnpackers;
import java.util.Arrays;
import java.util.Objects;

public final class RleBitPackingHybridDecoder
implements ValueDecoder<int[]> {
    private static final int EXTRACT_BATCH_SIZE = 8;
    private final int bitWidth;
    private final int byteWidth;
    private final IntBitUnpacker unpacker;
    private SimpleSliceInputStream input;
    private boolean isRle;
    private int valuesLeftInGroup;
    private int rleValue;
    private int[] valuesBuffer;
    private int alreadyReadInBuffer;

    public RleBitPackingHybridDecoder(int bitWidth, boolean vectorizedDecodingEnabled) {
        Preconditions.checkArgument((bitWidth >= 0 && bitWidth <= 32 ? 1 : 0) != 0, (Object)"bit width need to be between 0 and 32");
        this.bitWidth = bitWidth;
        this.byteWidth = RleBitPackingHybridDecoder.byteWidth(bitWidth);
        this.unpacker = vectorizedDecodingEnabled ? VectorIntBitUnpackers.getVectorIntBitUnpacker(bitWidth) : IntBitUnpackers.getIntBitUnpacker(bitWidth);
    }

    @Override
    public void init(SimpleSliceInputStream input) {
        this.input = Objects.requireNonNull(input, "input is null");
        this.valuesBuffer = new int[8];
    }

    @Override
    public void read(int[] values, int offset, int length) {
        while (length > 0) {
            int chunkSize;
            if (this.valuesLeftInGroup == 0) {
                this.readGroupHeader();
            }
            if (this.isRle) {
                chunkSize = Math.min(length, this.valuesLeftInGroup);
                Arrays.fill(values, offset, offset + chunkSize, this.rleValue);
                this.valuesLeftInGroup -= chunkSize;
                offset += chunkSize;
                length -= chunkSize;
                continue;
            }
            if (this.alreadyReadInBuffer != 0) {
                int remainingValues = 8 - this.alreadyReadInBuffer;
                int chunkSize2 = Math.min(remainingValues, length);
                System.arraycopy(this.valuesBuffer, this.alreadyReadInBuffer, values, offset, chunkSize2);
                this.valuesLeftInGroup -= chunkSize2;
                this.alreadyReadInBuffer = (this.alreadyReadInBuffer + chunkSize2) % 8;
                offset += chunkSize2;
                length -= chunkSize2;
                continue;
            }
            chunkSize = Math.min(length, this.valuesLeftInGroup);
            int leftToRead = chunkSize % 8;
            int fullBatchesToRead = chunkSize - leftToRead;
            this.unpacker.unpack(values, offset, this.input, fullBatchesToRead);
            offset += fullBatchesToRead;
            if (leftToRead > 0) {
                this.unpacker.unpack(this.valuesBuffer, 0, this.input, 8);
                System.arraycopy(this.valuesBuffer, 0, values, offset, leftToRead);
                offset += leftToRead;
            }
            this.alreadyReadInBuffer = leftToRead;
            this.valuesLeftInGroup -= chunkSize;
            length -= chunkSize;
        }
    }

    @Override
    public void skip(int n) {
        while (n > 0) {
            int chunkSize;
            if (this.valuesLeftInGroup == 0) {
                this.readGroupHeader();
            }
            if (this.isRle) {
                chunkSize = Math.min(n, this.valuesLeftInGroup);
                this.valuesLeftInGroup -= chunkSize;
                n -= chunkSize;
                continue;
            }
            if (this.alreadyReadInBuffer != 0) {
                int remainingValues = 8 - this.alreadyReadInBuffer;
                int chunkSize2 = Math.min(remainingValues, n);
                this.valuesLeftInGroup -= chunkSize2;
                this.alreadyReadInBuffer = (this.alreadyReadInBuffer + chunkSize2) % 8;
                n -= chunkSize2;
                continue;
            }
            chunkSize = Math.min(n, this.valuesLeftInGroup);
            int fullBatchesToRead = chunkSize / 8;
            this.input.skip(fullBatchesToRead * this.bitWidth * 8 / 8);
            int leftToRead = chunkSize % 8;
            if (leftToRead > 0) {
                this.unpacker.unpack(this.valuesBuffer, 0, this.input, 8);
            }
            this.alreadyReadInBuffer = leftToRead;
            this.valuesLeftInGroup -= chunkSize;
            n -= chunkSize;
        }
    }

    private void readGroupHeader() {
        int header = ParquetReaderUtils.readUleb128Int(this.input);
        this.isRle = (header & 1) == 0;
        this.valuesLeftInGroup = header >>> 1;
        if (this.isRle) {
            this.rleValue = ParquetReaderUtils.readFixedWidthInt(this.input, this.byteWidth);
        } else {
            this.valuesLeftInGroup *= 8;
        }
    }

    private static int byteWidth(int bitWidth) {
        return (bitWidth + 8 - 1) / 8;
    }
}

