/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ShortBitUnpacker;

public final class ShortBitUnpackers {
    private static final ShortBitUnpacker[] UNPACKERS = new ShortBitUnpacker[]{new Unpacker1(), new Unpacker2(), new Unpacker3(), new Unpacker4(), new Unpacker5(), new Unpacker6(), new Unpacker7(), new Unpacker8(), new Unpacker9(), new Unpacker10(), new Unpacker11(), new Unpacker12(), new Unpacker13(), new Unpacker14(), new Unpacker15(), new Unpacker16(), new Unpacker17()};

    public static ShortBitUnpacker getShortBitUnpacker(int bitWidth) {
        Preconditions.checkArgument((bitWidth > 0 && bitWidth <= 17 ? 1 : 0) != 0, (String)"bitWidth %s should be in the range 1-17", (int)bitWidth);
        return UNPACKERS[bitWidth - 1];
    }

    private ShortBitUnpackers() {
    }

    private static final class Unpacker1
    implements ShortBitUnpacker {
        private Unpacker1() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker1.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            output[outputOffset] = (short)((long)v0 & 1L);
            output[outputOffset + 1] = (short)((long)(v0 >>> 1) & 1L);
            output[outputOffset + 2] = (short)((long)(v0 >>> 2) & 1L);
            output[outputOffset + 3] = (short)((long)(v0 >>> 3) & 1L);
            output[outputOffset + 4] = (short)((long)(v0 >>> 4) & 1L);
            output[outputOffset + 5] = (short)((long)(v0 >>> 5) & 1L);
            output[outputOffset + 6] = (short)((long)(v0 >>> 6) & 1L);
            output[outputOffset + 7] = (short)((long)(v0 >>> 7) & 1L);
            output[outputOffset + 8] = (short)((long)(v0 >>> 8) & 1L);
            output[outputOffset + 9] = (short)((long)(v0 >>> 9) & 1L);
            output[outputOffset + 10] = (short)((long)(v0 >>> 10) & 1L);
            output[outputOffset + 11] = (short)((long)(v0 >>> 11) & 1L);
            output[outputOffset + 12] = (short)((long)(v0 >>> 12) & 1L);
            output[outputOffset + 13] = (short)((long)(v0 >>> 13) & 1L);
            output[outputOffset + 14] = (short)((long)(v0 >>> 14) & 1L);
            output[outputOffset + 15] = (short)((long)(v0 >>> 15) & 1L);
            output[outputOffset + 16] = (short)((long)(v0 >>> 16) & 1L);
            output[outputOffset + 17] = (short)((long)(v0 >>> 17) & 1L);
            output[outputOffset + 18] = (short)((long)(v0 >>> 18) & 1L);
            output[outputOffset + 19] = (short)((long)(v0 >>> 19) & 1L);
            output[outputOffset + 20] = (short)((long)(v0 >>> 20) & 1L);
            output[outputOffset + 21] = (short)((long)(v0 >>> 21) & 1L);
            output[outputOffset + 22] = (short)((long)(v0 >>> 22) & 1L);
            output[outputOffset + 23] = (short)((long)(v0 >>> 23) & 1L);
            output[outputOffset + 24] = (short)((long)(v0 >>> 24) & 1L);
            output[outputOffset + 25] = (short)((long)(v0 >>> 25) & 1L);
            output[outputOffset + 26] = (short)((long)(v0 >>> 26) & 1L);
            output[outputOffset + 27] = (short)((long)(v0 >>> 27) & 1L);
            output[outputOffset + 28] = (short)((long)(v0 >>> 28) & 1L);
            output[outputOffset + 29] = (short)((long)(v0 >>> 29) & 1L);
            output[outputOffset + 30] = (short)((long)(v0 >>> 30) & 1L);
            output[outputOffset + 31] = (short)((long)(v0 >>> 31) & 1L);
        }
    }

    private static final class Unpacker2
    implements ShortBitUnpacker {
        private Unpacker2() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker2.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            output[outputOffset] = (short)(v0 & 3L);
            output[outputOffset + 1] = (short)(v0 >>> 2 & 3L);
            output[outputOffset + 2] = (short)(v0 >>> 4 & 3L);
            output[outputOffset + 3] = (short)(v0 >>> 6 & 3L);
            output[outputOffset + 4] = (short)(v0 >>> 8 & 3L);
            output[outputOffset + 5] = (short)(v0 >>> 10 & 3L);
            output[outputOffset + 6] = (short)(v0 >>> 12 & 3L);
            output[outputOffset + 7] = (short)(v0 >>> 14 & 3L);
            output[outputOffset + 8] = (short)(v0 >>> 16 & 3L);
            output[outputOffset + 9] = (short)(v0 >>> 18 & 3L);
            output[outputOffset + 10] = (short)(v0 >>> 20 & 3L);
            output[outputOffset + 11] = (short)(v0 >>> 22 & 3L);
            output[outputOffset + 12] = (short)(v0 >>> 24 & 3L);
            output[outputOffset + 13] = (short)(v0 >>> 26 & 3L);
            output[outputOffset + 14] = (short)(v0 >>> 28 & 3L);
            output[outputOffset + 15] = (short)(v0 >>> 30 & 3L);
            output[outputOffset + 16] = (short)(v0 >>> 32 & 3L);
            output[outputOffset + 17] = (short)(v0 >>> 34 & 3L);
            output[outputOffset + 18] = (short)(v0 >>> 36 & 3L);
            output[outputOffset + 19] = (short)(v0 >>> 38 & 3L);
            output[outputOffset + 20] = (short)(v0 >>> 40 & 3L);
            output[outputOffset + 21] = (short)(v0 >>> 42 & 3L);
            output[outputOffset + 22] = (short)(v0 >>> 44 & 3L);
            output[outputOffset + 23] = (short)(v0 >>> 46 & 3L);
            output[outputOffset + 24] = (short)(v0 >>> 48 & 3L);
            output[outputOffset + 25] = (short)(v0 >>> 50 & 3L);
            output[outputOffset + 26] = (short)(v0 >>> 52 & 3L);
            output[outputOffset + 27] = (short)(v0 >>> 54 & 3L);
            output[outputOffset + 28] = (short)(v0 >>> 56 & 3L);
            output[outputOffset + 29] = (short)(v0 >>> 58 & 3L);
            output[outputOffset + 30] = (short)(v0 >>> 60 & 3L);
            output[outputOffset + 31] = (short)(v0 >>> 62 & 3L);
        }
    }

    private static final class Unpacker3
    implements ShortBitUnpacker {
        private Unpacker3() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker3.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            output[outputOffset] = (short)(v0 & 7L);
            output[outputOffset + 1] = (short)(v0 >>> 3 & 7L);
            output[outputOffset + 2] = (short)(v0 >>> 6 & 7L);
            output[outputOffset + 3] = (short)(v0 >>> 9 & 7L);
            output[outputOffset + 4] = (short)(v0 >>> 12 & 7L);
            output[outputOffset + 5] = (short)(v0 >>> 15 & 7L);
            output[outputOffset + 6] = (short)(v0 >>> 18 & 7L);
            output[outputOffset + 7] = (short)(v0 >>> 21 & 7L);
            output[outputOffset + 8] = (short)(v0 >>> 24 & 7L);
            output[outputOffset + 9] = (short)(v0 >>> 27 & 7L);
            output[outputOffset + 10] = (short)(v0 >>> 30 & 7L);
            output[outputOffset + 11] = (short)(v0 >>> 33 & 7L);
            output[outputOffset + 12] = (short)(v0 >>> 36 & 7L);
            output[outputOffset + 13] = (short)(v0 >>> 39 & 7L);
            output[outputOffset + 14] = (short)(v0 >>> 42 & 7L);
            output[outputOffset + 15] = (short)(v0 >>> 45 & 7L);
            output[outputOffset + 16] = (short)(v0 >>> 48 & 7L);
            output[outputOffset + 17] = (short)(v0 >>> 51 & 7L);
            output[outputOffset + 18] = (short)(v0 >>> 54 & 7L);
            output[outputOffset + 19] = (short)(v0 >>> 57 & 7L);
            output[outputOffset + 20] = (short)(v0 >>> 60 & 7L);
            output[outputOffset + 21] = (short)(v0 >>> 63 & 1L | ((long)v1 & 3L) << 1);
            output[outputOffset + 22] = (short)((long)(v1 >>> 2) & 7L);
            output[outputOffset + 23] = (short)((long)(v1 >>> 5) & 7L);
            output[outputOffset + 24] = (short)((long)(v1 >>> 8) & 7L);
            output[outputOffset + 25] = (short)((long)(v1 >>> 11) & 7L);
            output[outputOffset + 26] = (short)((long)(v1 >>> 14) & 7L);
            output[outputOffset + 27] = (short)((long)(v1 >>> 17) & 7L);
            output[outputOffset + 28] = (short)((long)(v1 >>> 20) & 7L);
            output[outputOffset + 29] = (short)((long)(v1 >>> 23) & 7L);
            output[outputOffset + 30] = (short)((long)(v1 >>> 26) & 7L);
            output[outputOffset + 31] = (short)((long)(v1 >>> 29) & 7L);
        }
    }

    private static final class Unpacker4
    implements ShortBitUnpacker {
        private Unpacker4() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker4.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            output[outputOffset] = (short)(v0 & 0xFL);
            output[outputOffset + 1] = (short)(v0 >>> 4 & 0xFL);
            output[outputOffset + 2] = (short)(v0 >>> 8 & 0xFL);
            output[outputOffset + 3] = (short)(v0 >>> 12 & 0xFL);
            output[outputOffset + 4] = (short)(v0 >>> 16 & 0xFL);
            output[outputOffset + 5] = (short)(v0 >>> 20 & 0xFL);
            output[outputOffset + 6] = (short)(v0 >>> 24 & 0xFL);
            output[outputOffset + 7] = (short)(v0 >>> 28 & 0xFL);
            output[outputOffset + 8] = (short)(v0 >>> 32 & 0xFL);
            output[outputOffset + 9] = (short)(v0 >>> 36 & 0xFL);
            output[outputOffset + 10] = (short)(v0 >>> 40 & 0xFL);
            output[outputOffset + 11] = (short)(v0 >>> 44 & 0xFL);
            output[outputOffset + 12] = (short)(v0 >>> 48 & 0xFL);
            output[outputOffset + 13] = (short)(v0 >>> 52 & 0xFL);
            output[outputOffset + 14] = (short)(v0 >>> 56 & 0xFL);
            output[outputOffset + 15] = (short)(v0 >>> 60 & 0xFL);
            output[outputOffset + 16] = (short)(v1 & 0xFL);
            output[outputOffset + 17] = (short)(v1 >>> 4 & 0xFL);
            output[outputOffset + 18] = (short)(v1 >>> 8 & 0xFL);
            output[outputOffset + 19] = (short)(v1 >>> 12 & 0xFL);
            output[outputOffset + 20] = (short)(v1 >>> 16 & 0xFL);
            output[outputOffset + 21] = (short)(v1 >>> 20 & 0xFL);
            output[outputOffset + 22] = (short)(v1 >>> 24 & 0xFL);
            output[outputOffset + 23] = (short)(v1 >>> 28 & 0xFL);
            output[outputOffset + 24] = (short)(v1 >>> 32 & 0xFL);
            output[outputOffset + 25] = (short)(v1 >>> 36 & 0xFL);
            output[outputOffset + 26] = (short)(v1 >>> 40 & 0xFL);
            output[outputOffset + 27] = (short)(v1 >>> 44 & 0xFL);
            output[outputOffset + 28] = (short)(v1 >>> 48 & 0xFL);
            output[outputOffset + 29] = (short)(v1 >>> 52 & 0xFL);
            output[outputOffset + 30] = (short)(v1 >>> 56 & 0xFL);
            output[outputOffset + 31] = (short)(v1 >>> 60 & 0xFL);
        }
    }

    private static final class Unpacker5
    implements ShortBitUnpacker {
        private Unpacker5() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker5.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            int v2 = input.readInt();
            output[outputOffset] = (short)(v0 & 0x1FL);
            output[outputOffset + 1] = (short)(v0 >>> 5 & 0x1FL);
            output[outputOffset + 2] = (short)(v0 >>> 10 & 0x1FL);
            output[outputOffset + 3] = (short)(v0 >>> 15 & 0x1FL);
            output[outputOffset + 4] = (short)(v0 >>> 20 & 0x1FL);
            output[outputOffset + 5] = (short)(v0 >>> 25 & 0x1FL);
            output[outputOffset + 6] = (short)(v0 >>> 30 & 0x1FL);
            output[outputOffset + 7] = (short)(v0 >>> 35 & 0x1FL);
            output[outputOffset + 8] = (short)(v0 >>> 40 & 0x1FL);
            output[outputOffset + 9] = (short)(v0 >>> 45 & 0x1FL);
            output[outputOffset + 10] = (short)(v0 >>> 50 & 0x1FL);
            output[outputOffset + 11] = (short)(v0 >>> 55 & 0x1FL);
            output[outputOffset + 12] = (short)(v0 >>> 60 & 0xFL | (v1 & 1L) << 4);
            output[outputOffset + 13] = (short)(v1 >>> 1 & 0x1FL);
            output[outputOffset + 14] = (short)(v1 >>> 6 & 0x1FL);
            output[outputOffset + 15] = (short)(v1 >>> 11 & 0x1FL);
            output[outputOffset + 16] = (short)(v1 >>> 16 & 0x1FL);
            output[outputOffset + 17] = (short)(v1 >>> 21 & 0x1FL);
            output[outputOffset + 18] = (short)(v1 >>> 26 & 0x1FL);
            output[outputOffset + 19] = (short)(v1 >>> 31 & 0x1FL);
            output[outputOffset + 20] = (short)(v1 >>> 36 & 0x1FL);
            output[outputOffset + 21] = (short)(v1 >>> 41 & 0x1FL);
            output[outputOffset + 22] = (short)(v1 >>> 46 & 0x1FL);
            output[outputOffset + 23] = (short)(v1 >>> 51 & 0x1FL);
            output[outputOffset + 24] = (short)(v1 >>> 56 & 0x1FL);
            output[outputOffset + 25] = (short)(v1 >>> 61 & 7L | ((long)v2 & 3L) << 3);
            output[outputOffset + 26] = (short)((long)(v2 >>> 2) & 0x1FL);
            output[outputOffset + 27] = (short)((long)(v2 >>> 7) & 0x1FL);
            output[outputOffset + 28] = (short)((long)(v2 >>> 12) & 0x1FL);
            output[outputOffset + 29] = (short)((long)(v2 >>> 17) & 0x1FL);
            output[outputOffset + 30] = (short)((long)(v2 >>> 22) & 0x1FL);
            output[outputOffset + 31] = (short)((long)(v2 >>> 27) & 0x1FL);
        }
    }

    private static final class Unpacker6
    implements ShortBitUnpacker {
        private Unpacker6() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker6.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            output[outputOffset] = (short)(v0 & 0x3FL);
            output[outputOffset + 1] = (short)(v0 >>> 6 & 0x3FL);
            output[outputOffset + 2] = (short)(v0 >>> 12 & 0x3FL);
            output[outputOffset + 3] = (short)(v0 >>> 18 & 0x3FL);
            output[outputOffset + 4] = (short)(v0 >>> 24 & 0x3FL);
            output[outputOffset + 5] = (short)(v0 >>> 30 & 0x3FL);
            output[outputOffset + 6] = (short)(v0 >>> 36 & 0x3FL);
            output[outputOffset + 7] = (short)(v0 >>> 42 & 0x3FL);
            output[outputOffset + 8] = (short)(v0 >>> 48 & 0x3FL);
            output[outputOffset + 9] = (short)(v0 >>> 54 & 0x3FL);
            output[outputOffset + 10] = (short)(v0 >>> 60 & 0xFL | (v1 & 3L) << 4);
            output[outputOffset + 11] = (short)(v1 >>> 2 & 0x3FL);
            output[outputOffset + 12] = (short)(v1 >>> 8 & 0x3FL);
            output[outputOffset + 13] = (short)(v1 >>> 14 & 0x3FL);
            output[outputOffset + 14] = (short)(v1 >>> 20 & 0x3FL);
            output[outputOffset + 15] = (short)(v1 >>> 26 & 0x3FL);
            output[outputOffset + 16] = (short)(v1 >>> 32 & 0x3FL);
            output[outputOffset + 17] = (short)(v1 >>> 38 & 0x3FL);
            output[outputOffset + 18] = (short)(v1 >>> 44 & 0x3FL);
            output[outputOffset + 19] = (short)(v1 >>> 50 & 0x3FL);
            output[outputOffset + 20] = (short)(v1 >>> 56 & 0x3FL);
            output[outputOffset + 21] = (short)(v1 >>> 62 & 3L | (v2 & 0xFL) << 2);
            output[outputOffset + 22] = (short)(v2 >>> 4 & 0x3FL);
            output[outputOffset + 23] = (short)(v2 >>> 10 & 0x3FL);
            output[outputOffset + 24] = (short)(v2 >>> 16 & 0x3FL);
            output[outputOffset + 25] = (short)(v2 >>> 22 & 0x3FL);
            output[outputOffset + 26] = (short)(v2 >>> 28 & 0x3FL);
            output[outputOffset + 27] = (short)(v2 >>> 34 & 0x3FL);
            output[outputOffset + 28] = (short)(v2 >>> 40 & 0x3FL);
            output[outputOffset + 29] = (short)(v2 >>> 46 & 0x3FL);
            output[outputOffset + 30] = (short)(v2 >>> 52 & 0x3FL);
            output[outputOffset + 31] = (short)(v2 >>> 58 & 0x3FL);
        }
    }

    private static final class Unpacker7
    implements ShortBitUnpacker {
        private Unpacker7() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker7.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            int v3 = input.readInt();
            output[outputOffset] = (short)(v0 & 0x7FL);
            output[outputOffset + 1] = (short)(v0 >>> 7 & 0x7FL);
            output[outputOffset + 2] = (short)(v0 >>> 14 & 0x7FL);
            output[outputOffset + 3] = (short)(v0 >>> 21 & 0x7FL);
            output[outputOffset + 4] = (short)(v0 >>> 28 & 0x7FL);
            output[outputOffset + 5] = (short)(v0 >>> 35 & 0x7FL);
            output[outputOffset + 6] = (short)(v0 >>> 42 & 0x7FL);
            output[outputOffset + 7] = (short)(v0 >>> 49 & 0x7FL);
            output[outputOffset + 8] = (short)(v0 >>> 56 & 0x7FL);
            output[outputOffset + 9] = (short)(v0 >>> 63 & 1L | (v1 & 0x3FL) << 1);
            output[outputOffset + 10] = (short)(v1 >>> 6 & 0x7FL);
            output[outputOffset + 11] = (short)(v1 >>> 13 & 0x7FL);
            output[outputOffset + 12] = (short)(v1 >>> 20 & 0x7FL);
            output[outputOffset + 13] = (short)(v1 >>> 27 & 0x7FL);
            output[outputOffset + 14] = (short)(v1 >>> 34 & 0x7FL);
            output[outputOffset + 15] = (short)(v1 >>> 41 & 0x7FL);
            output[outputOffset + 16] = (short)(v1 >>> 48 & 0x7FL);
            output[outputOffset + 17] = (short)(v1 >>> 55 & 0x7FL);
            output[outputOffset + 18] = (short)(v1 >>> 62 & 3L | (v2 & 0x1FL) << 2);
            output[outputOffset + 19] = (short)(v2 >>> 5 & 0x7FL);
            output[outputOffset + 20] = (short)(v2 >>> 12 & 0x7FL);
            output[outputOffset + 21] = (short)(v2 >>> 19 & 0x7FL);
            output[outputOffset + 22] = (short)(v2 >>> 26 & 0x7FL);
            output[outputOffset + 23] = (short)(v2 >>> 33 & 0x7FL);
            output[outputOffset + 24] = (short)(v2 >>> 40 & 0x7FL);
            output[outputOffset + 25] = (short)(v2 >>> 47 & 0x7FL);
            output[outputOffset + 26] = (short)(v2 >>> 54 & 0x7FL);
            output[outputOffset + 27] = (short)(v2 >>> 61 & 7L | ((long)v3 & 0xFL) << 3);
            output[outputOffset + 28] = (short)((long)(v3 >>> 4) & 0x7FL);
            output[outputOffset + 29] = (short)((long)(v3 >>> 11) & 0x7FL);
            output[outputOffset + 30] = (short)((long)(v3 >>> 18) & 0x7FL);
            output[outputOffset + 31] = (short)((long)(v3 >>> 25) & 0x7FL);
        }
    }

    private static final class Unpacker8
    implements ShortBitUnpacker {
        private Unpacker8() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker8.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            output[outputOffset] = (short)(v0 & 0xFFL);
            output[outputOffset + 1] = (short)(v0 >>> 8 & 0xFFL);
            output[outputOffset + 2] = (short)(v0 >>> 16 & 0xFFL);
            output[outputOffset + 3] = (short)(v0 >>> 24 & 0xFFL);
            output[outputOffset + 4] = (short)(v0 >>> 32 & 0xFFL);
            output[outputOffset + 5] = (short)(v0 >>> 40 & 0xFFL);
            output[outputOffset + 6] = (short)(v0 >>> 48 & 0xFFL);
            output[outputOffset + 7] = (short)(v0 >>> 56 & 0xFFL);
            output[outputOffset + 8] = (short)(v1 & 0xFFL);
            output[outputOffset + 9] = (short)(v1 >>> 8 & 0xFFL);
            output[outputOffset + 10] = (short)(v1 >>> 16 & 0xFFL);
            output[outputOffset + 11] = (short)(v1 >>> 24 & 0xFFL);
            output[outputOffset + 12] = (short)(v1 >>> 32 & 0xFFL);
            output[outputOffset + 13] = (short)(v1 >>> 40 & 0xFFL);
            output[outputOffset + 14] = (short)(v1 >>> 48 & 0xFFL);
            output[outputOffset + 15] = (short)(v1 >>> 56 & 0xFFL);
            output[outputOffset + 16] = (short)(v2 & 0xFFL);
            output[outputOffset + 17] = (short)(v2 >>> 8 & 0xFFL);
            output[outputOffset + 18] = (short)(v2 >>> 16 & 0xFFL);
            output[outputOffset + 19] = (short)(v2 >>> 24 & 0xFFL);
            output[outputOffset + 20] = (short)(v2 >>> 32 & 0xFFL);
            output[outputOffset + 21] = (short)(v2 >>> 40 & 0xFFL);
            output[outputOffset + 22] = (short)(v2 >>> 48 & 0xFFL);
            output[outputOffset + 23] = (short)(v2 >>> 56 & 0xFFL);
            output[outputOffset + 24] = (short)(v3 & 0xFFL);
            output[outputOffset + 25] = (short)(v3 >>> 8 & 0xFFL);
            output[outputOffset + 26] = (short)(v3 >>> 16 & 0xFFL);
            output[outputOffset + 27] = (short)(v3 >>> 24 & 0xFFL);
            output[outputOffset + 28] = (short)(v3 >>> 32 & 0xFFL);
            output[outputOffset + 29] = (short)(v3 >>> 40 & 0xFFL);
            output[outputOffset + 30] = (short)(v3 >>> 48 & 0xFFL);
            output[outputOffset + 31] = (short)(v3 >>> 56 & 0xFFL);
        }
    }

    private static final class Unpacker9
    implements ShortBitUnpacker {
        private Unpacker9() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker9.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            int v4 = input.readInt();
            output[outputOffset] = (short)(v0 & 0x1FFL);
            output[outputOffset + 1] = (short)(v0 >>> 9 & 0x1FFL);
            output[outputOffset + 2] = (short)(v0 >>> 18 & 0x1FFL);
            output[outputOffset + 3] = (short)(v0 >>> 27 & 0x1FFL);
            output[outputOffset + 4] = (short)(v0 >>> 36 & 0x1FFL);
            output[outputOffset + 5] = (short)(v0 >>> 45 & 0x1FFL);
            output[outputOffset + 6] = (short)(v0 >>> 54 & 0x1FFL);
            output[outputOffset + 7] = (short)(v0 >>> 63 & 1L | (v1 & 0xFFL) << 1);
            output[outputOffset + 8] = (short)(v1 >>> 8 & 0x1FFL);
            output[outputOffset + 9] = (short)(v1 >>> 17 & 0x1FFL);
            output[outputOffset + 10] = (short)(v1 >>> 26 & 0x1FFL);
            output[outputOffset + 11] = (short)(v1 >>> 35 & 0x1FFL);
            output[outputOffset + 12] = (short)(v1 >>> 44 & 0x1FFL);
            output[outputOffset + 13] = (short)(v1 >>> 53 & 0x1FFL);
            output[outputOffset + 14] = (short)(v1 >>> 62 & 3L | (v2 & 0x7FL) << 2);
            output[outputOffset + 15] = (short)(v2 >>> 7 & 0x1FFL);
            output[outputOffset + 16] = (short)(v2 >>> 16 & 0x1FFL);
            output[outputOffset + 17] = (short)(v2 >>> 25 & 0x1FFL);
            output[outputOffset + 18] = (short)(v2 >>> 34 & 0x1FFL);
            output[outputOffset + 19] = (short)(v2 >>> 43 & 0x1FFL);
            output[outputOffset + 20] = (short)(v2 >>> 52 & 0x1FFL);
            output[outputOffset + 21] = (short)(v2 >>> 61 & 7L | (v3 & 0x3FL) << 3);
            output[outputOffset + 22] = (short)(v3 >>> 6 & 0x1FFL);
            output[outputOffset + 23] = (short)(v3 >>> 15 & 0x1FFL);
            output[outputOffset + 24] = (short)(v3 >>> 24 & 0x1FFL);
            output[outputOffset + 25] = (short)(v3 >>> 33 & 0x1FFL);
            output[outputOffset + 26] = (short)(v3 >>> 42 & 0x1FFL);
            output[outputOffset + 27] = (short)(v3 >>> 51 & 0x1FFL);
            output[outputOffset + 28] = (short)(v3 >>> 60 & 0xFL | ((long)v4 & 0x1FL) << 4);
            output[outputOffset + 29] = (short)((long)(v4 >>> 5) & 0x1FFL);
            output[outputOffset + 30] = (short)((long)(v4 >>> 14) & 0x1FFL);
            output[outputOffset + 31] = (short)((long)(v4 >>> 23) & 0x1FFL);
        }
    }

    private static final class Unpacker10
    implements ShortBitUnpacker {
        private Unpacker10() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker10.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            output[outputOffset] = (short)(v0 & 0x3FFL);
            output[outputOffset + 1] = (short)(v0 >>> 10 & 0x3FFL);
            output[outputOffset + 2] = (short)(v0 >>> 20 & 0x3FFL);
            output[outputOffset + 3] = (short)(v0 >>> 30 & 0x3FFL);
            output[outputOffset + 4] = (short)(v0 >>> 40 & 0x3FFL);
            output[outputOffset + 5] = (short)(v0 >>> 50 & 0x3FFL);
            output[outputOffset + 6] = (short)(v0 >>> 60 & 0xFL | (v1 & 0x3FL) << 4);
            output[outputOffset + 7] = (short)(v1 >>> 6 & 0x3FFL);
            output[outputOffset + 8] = (short)(v1 >>> 16 & 0x3FFL);
            output[outputOffset + 9] = (short)(v1 >>> 26 & 0x3FFL);
            output[outputOffset + 10] = (short)(v1 >>> 36 & 0x3FFL);
            output[outputOffset + 11] = (short)(v1 >>> 46 & 0x3FFL);
            output[outputOffset + 12] = (short)(v1 >>> 56 & 0xFFL | (v2 & 3L) << 8);
            output[outputOffset + 13] = (short)(v2 >>> 2 & 0x3FFL);
            output[outputOffset + 14] = (short)(v2 >>> 12 & 0x3FFL);
            output[outputOffset + 15] = (short)(v2 >>> 22 & 0x3FFL);
            output[outputOffset + 16] = (short)(v2 >>> 32 & 0x3FFL);
            output[outputOffset + 17] = (short)(v2 >>> 42 & 0x3FFL);
            output[outputOffset + 18] = (short)(v2 >>> 52 & 0x3FFL);
            output[outputOffset + 19] = (short)(v2 >>> 62 & 3L | (v3 & 0xFFL) << 2);
            output[outputOffset + 20] = (short)(v3 >>> 8 & 0x3FFL);
            output[outputOffset + 21] = (short)(v3 >>> 18 & 0x3FFL);
            output[outputOffset + 22] = (short)(v3 >>> 28 & 0x3FFL);
            output[outputOffset + 23] = (short)(v3 >>> 38 & 0x3FFL);
            output[outputOffset + 24] = (short)(v3 >>> 48 & 0x3FFL);
            output[outputOffset + 25] = (short)(v3 >>> 58 & 0x3FL | (v4 & 0xFL) << 6);
            output[outputOffset + 26] = (short)(v4 >>> 4 & 0x3FFL);
            output[outputOffset + 27] = (short)(v4 >>> 14 & 0x3FFL);
            output[outputOffset + 28] = (short)(v4 >>> 24 & 0x3FFL);
            output[outputOffset + 29] = (short)(v4 >>> 34 & 0x3FFL);
            output[outputOffset + 30] = (short)(v4 >>> 44 & 0x3FFL);
            output[outputOffset + 31] = (short)(v4 >>> 54 & 0x3FFL);
        }
    }

    private static final class Unpacker11
    implements ShortBitUnpacker {
        private Unpacker11() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker11.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            int v5 = input.readInt();
            output[outputOffset] = (short)(v0 & 0x7FFL);
            output[outputOffset + 1] = (short)(v0 >>> 11 & 0x7FFL);
            output[outputOffset + 2] = (short)(v0 >>> 22 & 0x7FFL);
            output[outputOffset + 3] = (short)(v0 >>> 33 & 0x7FFL);
            output[outputOffset + 4] = (short)(v0 >>> 44 & 0x7FFL);
            output[outputOffset + 5] = (short)(v0 >>> 55 & 0x1FFL | (v1 & 3L) << 9);
            output[outputOffset + 6] = (short)(v1 >>> 2 & 0x7FFL);
            output[outputOffset + 7] = (short)(v1 >>> 13 & 0x7FFL);
            output[outputOffset + 8] = (short)(v1 >>> 24 & 0x7FFL);
            output[outputOffset + 9] = (short)(v1 >>> 35 & 0x7FFL);
            output[outputOffset + 10] = (short)(v1 >>> 46 & 0x7FFL);
            output[outputOffset + 11] = (short)(v1 >>> 57 & 0x7FL | (v2 & 0xFL) << 7);
            output[outputOffset + 12] = (short)(v2 >>> 4 & 0x7FFL);
            output[outputOffset + 13] = (short)(v2 >>> 15 & 0x7FFL);
            output[outputOffset + 14] = (short)(v2 >>> 26 & 0x7FFL);
            output[outputOffset + 15] = (short)(v2 >>> 37 & 0x7FFL);
            output[outputOffset + 16] = (short)(v2 >>> 48 & 0x7FFL);
            output[outputOffset + 17] = (short)(v2 >>> 59 & 0x1FL | (v3 & 0x3FL) << 5);
            output[outputOffset + 18] = (short)(v3 >>> 6 & 0x7FFL);
            output[outputOffset + 19] = (short)(v3 >>> 17 & 0x7FFL);
            output[outputOffset + 20] = (short)(v3 >>> 28 & 0x7FFL);
            output[outputOffset + 21] = (short)(v3 >>> 39 & 0x7FFL);
            output[outputOffset + 22] = (short)(v3 >>> 50 & 0x7FFL);
            output[outputOffset + 23] = (short)(v3 >>> 61 & 7L | (v4 & 0xFFL) << 3);
            output[outputOffset + 24] = (short)(v4 >>> 8 & 0x7FFL);
            output[outputOffset + 25] = (short)(v4 >>> 19 & 0x7FFL);
            output[outputOffset + 26] = (short)(v4 >>> 30 & 0x7FFL);
            output[outputOffset + 27] = (short)(v4 >>> 41 & 0x7FFL);
            output[outputOffset + 28] = (short)(v4 >>> 52 & 0x7FFL);
            output[outputOffset + 29] = (short)(v4 >>> 63 & 1L | ((long)v5 & 0x3FFL) << 1);
            output[outputOffset + 30] = (short)((long)(v5 >>> 10) & 0x7FFL);
            output[outputOffset + 31] = (short)((long)(v5 >>> 21) & 0x7FFL);
        }
    }

    private static final class Unpacker12
    implements ShortBitUnpacker {
        private Unpacker12() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker12.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            output[outputOffset] = (short)(v0 & 0xFFFL);
            output[outputOffset + 1] = (short)(v0 >>> 12 & 0xFFFL);
            output[outputOffset + 2] = (short)(v0 >>> 24 & 0xFFFL);
            output[outputOffset + 3] = (short)(v0 >>> 36 & 0xFFFL);
            output[outputOffset + 4] = (short)(v0 >>> 48 & 0xFFFL);
            output[outputOffset + 5] = (short)(v0 >>> 60 & 0xFL | (v1 & 0xFFL) << 4);
            output[outputOffset + 6] = (short)(v1 >>> 8 & 0xFFFL);
            output[outputOffset + 7] = (short)(v1 >>> 20 & 0xFFFL);
            output[outputOffset + 8] = (short)(v1 >>> 32 & 0xFFFL);
            output[outputOffset + 9] = (short)(v1 >>> 44 & 0xFFFL);
            output[outputOffset + 10] = (short)(v1 >>> 56 & 0xFFL | (v2 & 0xFL) << 8);
            output[outputOffset + 11] = (short)(v2 >>> 4 & 0xFFFL);
            output[outputOffset + 12] = (short)(v2 >>> 16 & 0xFFFL);
            output[outputOffset + 13] = (short)(v2 >>> 28 & 0xFFFL);
            output[outputOffset + 14] = (short)(v2 >>> 40 & 0xFFFL);
            output[outputOffset + 15] = (short)(v2 >>> 52 & 0xFFFL);
            output[outputOffset + 16] = (short)(v3 & 0xFFFL);
            output[outputOffset + 17] = (short)(v3 >>> 12 & 0xFFFL);
            output[outputOffset + 18] = (short)(v3 >>> 24 & 0xFFFL);
            output[outputOffset + 19] = (short)(v3 >>> 36 & 0xFFFL);
            output[outputOffset + 20] = (short)(v3 >>> 48 & 0xFFFL);
            output[outputOffset + 21] = (short)(v3 >>> 60 & 0xFL | (v4 & 0xFFL) << 4);
            output[outputOffset + 22] = (short)(v4 >>> 8 & 0xFFFL);
            output[outputOffset + 23] = (short)(v4 >>> 20 & 0xFFFL);
            output[outputOffset + 24] = (short)(v4 >>> 32 & 0xFFFL);
            output[outputOffset + 25] = (short)(v4 >>> 44 & 0xFFFL);
            output[outputOffset + 26] = (short)(v4 >>> 56 & 0xFFL | (v5 & 0xFL) << 8);
            output[outputOffset + 27] = (short)(v5 >>> 4 & 0xFFFL);
            output[outputOffset + 28] = (short)(v5 >>> 16 & 0xFFFL);
            output[outputOffset + 29] = (short)(v5 >>> 28 & 0xFFFL);
            output[outputOffset + 30] = (short)(v5 >>> 40 & 0xFFFL);
            output[outputOffset + 31] = (short)(v5 >>> 52 & 0xFFFL);
        }
    }

    private static final class Unpacker13
    implements ShortBitUnpacker {
        private Unpacker13() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker13.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            int v6 = input.readInt();
            output[outputOffset] = (short)(v0 & 0x1FFFL);
            output[outputOffset + 1] = (short)(v0 >>> 13 & 0x1FFFL);
            output[outputOffset + 2] = (short)(v0 >>> 26 & 0x1FFFL);
            output[outputOffset + 3] = (short)(v0 >>> 39 & 0x1FFFL);
            output[outputOffset + 4] = (short)(v0 >>> 52 & 0xFFFL | (v1 & 1L) << 12);
            output[outputOffset + 5] = (short)(v1 >>> 1 & 0x1FFFL);
            output[outputOffset + 6] = (short)(v1 >>> 14 & 0x1FFFL);
            output[outputOffset + 7] = (short)(v1 >>> 27 & 0x1FFFL);
            output[outputOffset + 8] = (short)(v1 >>> 40 & 0x1FFFL);
            output[outputOffset + 9] = (short)(v1 >>> 53 & 0x7FFL | (v2 & 3L) << 11);
            output[outputOffset + 10] = (short)(v2 >>> 2 & 0x1FFFL);
            output[outputOffset + 11] = (short)(v2 >>> 15 & 0x1FFFL);
            output[outputOffset + 12] = (short)(v2 >>> 28 & 0x1FFFL);
            output[outputOffset + 13] = (short)(v2 >>> 41 & 0x1FFFL);
            output[outputOffset + 14] = (short)(v2 >>> 54 & 0x3FFL | (v3 & 7L) << 10);
            output[outputOffset + 15] = (short)(v3 >>> 3 & 0x1FFFL);
            output[outputOffset + 16] = (short)(v3 >>> 16 & 0x1FFFL);
            output[outputOffset + 17] = (short)(v3 >>> 29 & 0x1FFFL);
            output[outputOffset + 18] = (short)(v3 >>> 42 & 0x1FFFL);
            output[outputOffset + 19] = (short)(v3 >>> 55 & 0x1FFL | (v4 & 0xFL) << 9);
            output[outputOffset + 20] = (short)(v4 >>> 4 & 0x1FFFL);
            output[outputOffset + 21] = (short)(v4 >>> 17 & 0x1FFFL);
            output[outputOffset + 22] = (short)(v4 >>> 30 & 0x1FFFL);
            output[outputOffset + 23] = (short)(v4 >>> 43 & 0x1FFFL);
            output[outputOffset + 24] = (short)(v4 >>> 56 & 0xFFL | (v5 & 0x1FL) << 8);
            output[outputOffset + 25] = (short)(v5 >>> 5 & 0x1FFFL);
            output[outputOffset + 26] = (short)(v5 >>> 18 & 0x1FFFL);
            output[outputOffset + 27] = (short)(v5 >>> 31 & 0x1FFFL);
            output[outputOffset + 28] = (short)(v5 >>> 44 & 0x1FFFL);
            output[outputOffset + 29] = (short)(v5 >>> 57 & 0x7FL | ((long)v6 & 0x3FL) << 7);
            output[outputOffset + 30] = (short)((long)(v6 >>> 6) & 0x1FFFL);
            output[outputOffset + 31] = (short)((long)(v6 >>> 19) & 0x1FFFL);
        }
    }

    private static final class Unpacker14
    implements ShortBitUnpacker {
        private Unpacker14() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker14.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            output[outputOffset] = (short)(v0 & 0x3FFFL);
            output[outputOffset + 1] = (short)(v0 >>> 14 & 0x3FFFL);
            output[outputOffset + 2] = (short)(v0 >>> 28 & 0x3FFFL);
            output[outputOffset + 3] = (short)(v0 >>> 42 & 0x3FFFL);
            output[outputOffset + 4] = (short)(v0 >>> 56 & 0xFFL | (v1 & 0x3FL) << 8);
            output[outputOffset + 5] = (short)(v1 >>> 6 & 0x3FFFL);
            output[outputOffset + 6] = (short)(v1 >>> 20 & 0x3FFFL);
            output[outputOffset + 7] = (short)(v1 >>> 34 & 0x3FFFL);
            output[outputOffset + 8] = (short)(v1 >>> 48 & 0x3FFFL);
            output[outputOffset + 9] = (short)(v1 >>> 62 & 3L | (v2 & 0xFFFL) << 2);
            output[outputOffset + 10] = (short)(v2 >>> 12 & 0x3FFFL);
            output[outputOffset + 11] = (short)(v2 >>> 26 & 0x3FFFL);
            output[outputOffset + 12] = (short)(v2 >>> 40 & 0x3FFFL);
            output[outputOffset + 13] = (short)(v2 >>> 54 & 0x3FFL | (v3 & 0xFL) << 10);
            output[outputOffset + 14] = (short)(v3 >>> 4 & 0x3FFFL);
            output[outputOffset + 15] = (short)(v3 >>> 18 & 0x3FFFL);
            output[outputOffset + 16] = (short)(v3 >>> 32 & 0x3FFFL);
            output[outputOffset + 17] = (short)(v3 >>> 46 & 0x3FFFL);
            output[outputOffset + 18] = (short)(v3 >>> 60 & 0xFL | (v4 & 0x3FFL) << 4);
            output[outputOffset + 19] = (short)(v4 >>> 10 & 0x3FFFL);
            output[outputOffset + 20] = (short)(v4 >>> 24 & 0x3FFFL);
            output[outputOffset + 21] = (short)(v4 >>> 38 & 0x3FFFL);
            output[outputOffset + 22] = (short)(v4 >>> 52 & 0xFFFL | (v5 & 3L) << 12);
            output[outputOffset + 23] = (short)(v5 >>> 2 & 0x3FFFL);
            output[outputOffset + 24] = (short)(v5 >>> 16 & 0x3FFFL);
            output[outputOffset + 25] = (short)(v5 >>> 30 & 0x3FFFL);
            output[outputOffset + 26] = (short)(v5 >>> 44 & 0x3FFFL);
            output[outputOffset + 27] = (short)(v5 >>> 58 & 0x3FL | (v6 & 0xFFL) << 6);
            output[outputOffset + 28] = (short)(v6 >>> 8 & 0x3FFFL);
            output[outputOffset + 29] = (short)(v6 >>> 22 & 0x3FFFL);
            output[outputOffset + 30] = (short)(v6 >>> 36 & 0x3FFFL);
            output[outputOffset + 31] = (short)(v6 >>> 50 & 0x3FFFL);
        }
    }

    private static final class Unpacker15
    implements ShortBitUnpacker {
        private Unpacker15() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker15.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            int v7 = input.readInt();
            output[outputOffset] = (short)(v0 & 0x7FFFL);
            output[outputOffset + 1] = (short)(v0 >>> 15 & 0x7FFFL);
            output[outputOffset + 2] = (short)(v0 >>> 30 & 0x7FFFL);
            output[outputOffset + 3] = (short)(v0 >>> 45 & 0x7FFFL);
            output[outputOffset + 4] = (short)(v0 >>> 60 & 0xFL | (v1 & 0x7FFL) << 4);
            output[outputOffset + 5] = (short)(v1 >>> 11 & 0x7FFFL);
            output[outputOffset + 6] = (short)(v1 >>> 26 & 0x7FFFL);
            output[outputOffset + 7] = (short)(v1 >>> 41 & 0x7FFFL);
            output[outputOffset + 8] = (short)(v1 >>> 56 & 0xFFL | (v2 & 0x7FL) << 8);
            output[outputOffset + 9] = (short)(v2 >>> 7 & 0x7FFFL);
            output[outputOffset + 10] = (short)(v2 >>> 22 & 0x7FFFL);
            output[outputOffset + 11] = (short)(v2 >>> 37 & 0x7FFFL);
            output[outputOffset + 12] = (short)(v2 >>> 52 & 0xFFFL | (v3 & 7L) << 12);
            output[outputOffset + 13] = (short)(v3 >>> 3 & 0x7FFFL);
            output[outputOffset + 14] = (short)(v3 >>> 18 & 0x7FFFL);
            output[outputOffset + 15] = (short)(v3 >>> 33 & 0x7FFFL);
            output[outputOffset + 16] = (short)(v3 >>> 48 & 0x7FFFL);
            output[outputOffset + 17] = (short)(v3 >>> 63 & 1L | (v4 & 0x3FFFL) << 1);
            output[outputOffset + 18] = (short)(v4 >>> 14 & 0x7FFFL);
            output[outputOffset + 19] = (short)(v4 >>> 29 & 0x7FFFL);
            output[outputOffset + 20] = (short)(v4 >>> 44 & 0x7FFFL);
            output[outputOffset + 21] = (short)(v4 >>> 59 & 0x1FL | (v5 & 0x3FFL) << 5);
            output[outputOffset + 22] = (short)(v5 >>> 10 & 0x7FFFL);
            output[outputOffset + 23] = (short)(v5 >>> 25 & 0x7FFFL);
            output[outputOffset + 24] = (short)(v5 >>> 40 & 0x7FFFL);
            output[outputOffset + 25] = (short)(v5 >>> 55 & 0x1FFL | (v6 & 0x3FL) << 9);
            output[outputOffset + 26] = (short)(v6 >>> 6 & 0x7FFFL);
            output[outputOffset + 27] = (short)(v6 >>> 21 & 0x7FFFL);
            output[outputOffset + 28] = (short)(v6 >>> 36 & 0x7FFFL);
            output[outputOffset + 29] = (short)(v6 >>> 51 & 0x1FFFL | ((long)v7 & 3L) << 13);
            output[outputOffset + 30] = (short)((long)(v7 >>> 2) & 0x7FFFL);
            output[outputOffset + 31] = (short)((long)(v7 >>> 17) & 0x7FFFL);
        }
    }

    private static final class Unpacker16
    implements ShortBitUnpacker {
        private Unpacker16() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            input.readShorts(output, outputOffset, length);
        }
    }

    private static final class Unpacker17
    implements ShortBitUnpacker {
        private Unpacker17() {
        }

        @Override
        public void unpack(short[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker17.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(short[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            long v7 = input.readLong();
            int v8 = input.readInt();
            output[outputOffset] = (short)(v0 & 0x1FFFFL);
            output[outputOffset + 1] = (short)(v0 >>> 17 & 0x1FFFFL);
            output[outputOffset + 2] = (short)(v0 >>> 34 & 0x1FFFFL);
            output[outputOffset + 3] = (short)(v0 >>> 51 & 0x1FFFL | (v1 & 0xFL) << 13);
            output[outputOffset + 4] = (short)(v1 >>> 4 & 0x1FFFFL);
            output[outputOffset + 5] = (short)(v1 >>> 21 & 0x1FFFFL);
            output[outputOffset + 6] = (short)(v1 >>> 38 & 0x1FFFFL);
            output[outputOffset + 7] = (short)(v1 >>> 55 & 0x1FFL | (v2 & 0xFFL) << 9);
            output[outputOffset + 8] = (short)(v2 >>> 8 & 0x1FFFFL);
            output[outputOffset + 9] = (short)(v2 >>> 25 & 0x1FFFFL);
            output[outputOffset + 10] = (short)(v2 >>> 42 & 0x1FFFFL);
            output[outputOffset + 11] = (short)(v2 >>> 59 & 0x1FL | (v3 & 0xFFFL) << 5);
            output[outputOffset + 12] = (short)(v3 >>> 12 & 0x1FFFFL);
            output[outputOffset + 13] = (short)(v3 >>> 29 & 0x1FFFFL);
            output[outputOffset + 14] = (short)(v3 >>> 46 & 0x1FFFFL);
            output[outputOffset + 15] = (short)(v3 >>> 63 & 1L | (v4 & 0xFFFFL) << 1);
            output[outputOffset + 16] = (short)(v4 >>> 16 & 0x1FFFFL);
            output[outputOffset + 17] = (short)(v4 >>> 33 & 0x1FFFFL);
            output[outputOffset + 18] = (short)(v4 >>> 50 & 0x3FFFL | (v5 & 7L) << 14);
            output[outputOffset + 19] = (short)(v5 >>> 3 & 0x1FFFFL);
            output[outputOffset + 20] = (short)(v5 >>> 20 & 0x1FFFFL);
            output[outputOffset + 21] = (short)(v5 >>> 37 & 0x1FFFFL);
            output[outputOffset + 22] = (short)(v5 >>> 54 & 0x3FFL | (v6 & 0x7FL) << 10);
            output[outputOffset + 23] = (short)(v6 >>> 7 & 0x1FFFFL);
            output[outputOffset + 24] = (short)(v6 >>> 24 & 0x1FFFFL);
            output[outputOffset + 25] = (short)(v6 >>> 41 & 0x1FFFFL);
            output[outputOffset + 26] = (short)(v6 >>> 58 & 0x3FL | (v7 & 0x7FFL) << 6);
            output[outputOffset + 27] = (short)(v7 >>> 11 & 0x1FFFFL);
            output[outputOffset + 28] = (short)(v7 >>> 28 & 0x1FFFFL);
            output[outputOffset + 29] = (short)(v7 >>> 45 & 0x1FFFFL);
            output[outputOffset + 30] = (short)(v7 >>> 62 & 3L | ((long)v8 & 0x7FFFL) << 2);
            output[outputOffset + 31] = (short)((long)(v8 >>> 15) & 0x1FFFFL);
        }
    }
}

