/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.IntBitUnpacker;
import io.trino.parquet.reader.decoders.IntBitUnpackers;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.ShortVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorShuffle;
import jdk.incubator.vector.VectorSpecies;

public final class VectorIntBitUnpackers {
    private static final IntBitUnpacker[] UNPACKERS = new IntBitUnpacker[]{new Unpacker0(), new Unpacker1(), new Unpacker2(), new Unpacker3(), new Unpacker4(), new Unpacker5(), new Unpacker6(), new Unpacker7(), new Unpacker8(), new Unpacker9(), new Unpacker10(), new Unpacker11(), new Unpacker12(), new Unpacker13(), new Unpacker14(), new Unpacker15(), new Unpacker16(), new Unpacker17(), new Unpacker18(), new Unpacker19(), new Unpacker20()};

    public static IntBitUnpacker getVectorIntBitUnpacker(int bitWidth) {
        if (bitWidth > 20) {
            return IntBitUnpackers.getIntBitUnpacker(bitWidth);
        }
        return UNPACKERS[bitWidth];
    }

    private VectorIntBitUnpackers() {
    }

    private static final class Unpacker0
    implements IntBitUnpacker {
        private Unpacker0() {
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
        }
    }

    private static final class Unpacker1
    implements IntBitUnpacker {
        private static final ByteVector MASK_1 = ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (long)1L);
        private static final ByteVector LSHR_BYTE_VECTOR = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7}, (int)0);

        private Unpacker1() {
        }

        private static void unpack8(int[] output, int outputOffset, byte input) {
            ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (byte)input).lanewise(VectorOperators.LSHR, (Vector)LSHR_BYTE_VECTOR).and((Vector)MASK_1).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 8) {
                Unpacker1.unpack8(output, outputOffset, inputArray[inputOffset + inputBytesRead]);
                outputOffset += 8;
                length -= 8;
                ++inputBytesRead;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker2
    implements IntBitUnpacker {
        private static final ByteVector MASK_2 = ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (long)3L);
        private static final ByteVector LSHR_BYTE_VECTOR = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 2, 4, 6, 0, 2, 4, 6}, (int)0);
        private static final VectorShuffle<Byte> SHUFFLE = VectorShuffle.fromArray((VectorSpecies)ByteVector.SPECIES_64, (int[])new int[]{0, 0, 0, 0, 1, 1, 1, 1}, (int)0);

        private Unpacker2() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])input, (int)inputOffset).rearrange(SHUFFLE).lanewise(VectorOperators.LSHR, (Vector)LSHR_BYTE_VECTOR).and((Vector)MASK_2).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8Scalar(int[] output, int outputOffset, byte[] input, int inputOffset) {
            byte v0 = input[inputOffset];
            byte v1 = input[inputOffset + 1];
            output[outputOffset] = v0 & 3;
            output[outputOffset + 1] = v0 >>> 2 & 3;
            output[outputOffset + 2] = v0 >>> 4 & 3;
            output[outputOffset + 3] = v0 >>> 6 & 3;
            output[outputOffset + 4] = v1 & 3;
            output[outputOffset + 5] = v1 >>> 2 & 3;
            output[outputOffset + 6] = v1 >>> 4 & 3;
            output[outputOffset + 7] = v1 >>> 6 & 3;
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 32) {
                Unpacker2.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 2;
            }
            switch (length) {
                case 24: {
                    Unpacker2.unpack8Scalar(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                    outputOffset += 8;
                    inputBytesRead += 2;
                }
                case 16: {
                    Unpacker2.unpack8Scalar(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                    outputOffset += 8;
                    inputBytesRead += 2;
                }
                case 8: {
                    Unpacker2.unpack8Scalar(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                    inputBytesRead += 2;
                }
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker3
    implements IntBitUnpacker {
        private static final ByteVector MASK_3 = ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (long)7L);
        private static final ByteVector MASK_BEFORE_LSHL = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 0, 1, 0, 0, 3, 0, 0}, (int)0);
        private static final ByteVector LSHR_BYTE_VECTOR = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 3, 6, 1, 4, 7, 2, 5}, (int)0);
        private static final ByteVector LSHL_BYTE_VECTOR = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 0, 2, 0, 0, 1, 0, 0}, (int)0);
        private static final VectorShuffle<Byte> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ByteVector.SPECIES_64, (int[])new int[]{0, 0, 0, 1, 1, 1, 2, 2}, (int)0);
        private static final VectorShuffle<Byte> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ByteVector.SPECIES_64, (int[])new int[]{0, 0, 1, 1, 1, 2, 2, 2}, (int)0);

        private Unpacker3() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ByteVector byteVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])input, (int)inputOffset);
            ByteVector shiftRightResult = byteVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_BYTE_VECTOR).and((Vector)MASK_3);
            ByteVector shiftLeftResult = byteVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_BYTE_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            short v0 = input.readShort();
            byte v1 = input.readByte();
            output[outputOffset] = v0 & 7;
            output[outputOffset + 1] = v0 >>> 3 & 7;
            output[outputOffset + 2] = v0 >>> 6 & 7;
            output[outputOffset + 3] = v0 >>> 9 & 7;
            output[outputOffset + 4] = v0 >>> 12 & 7;
            output[outputOffset + 5] = v0 >>> 15 & 1 | (v1 & 3) << 1;
            output[outputOffset + 6] = v1 >>> 2 & 7;
            output[outputOffset + 7] = v1 >>> 5 & 7;
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 24) {
                Unpacker3.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 3;
            }
            input.skip(inputBytesRead);
            switch (length) {
                case 16: {
                    Unpacker3.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 8: {
                    Unpacker3.unpack8(output, outputOffset, input);
                }
            }
        }
    }

    private static final class Unpacker4
    implements IntBitUnpacker {
        private static final ByteVector MASK_4 = ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (long)15L);
        private static final ByteVector LSHR_BYTE_VECTOR = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 4, 0, 4, 0, 4, 0, 4}, (int)0);
        private static final VectorShuffle<Byte> SHUFFLE = VectorShuffle.fromArray((VectorSpecies)ByteVector.SPECIES_64, (int[])new int[]{0, 0, 1, 1, 2, 2, 3, 3}, (int)0);

        private Unpacker4() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])input, (int)inputOffset).rearrange(SHUFFLE).lanewise(VectorOperators.LSHR, (Vector)LSHR_BYTE_VECTOR).and((Vector)MASK_4).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8Scalar(int[] output, int outputOffset, byte[] input, int inputOffset) {
            byte v0 = input[inputOffset];
            byte v1 = input[inputOffset + 1];
            byte v2 = input[inputOffset + 2];
            byte v3 = input[inputOffset + 3];
            output[outputOffset] = v0 & 0xF;
            output[outputOffset + 1] = v0 >>> 4 & 0xF;
            output[outputOffset + 2] = v1 & 0xF;
            output[outputOffset + 3] = v1 >>> 4 & 0xF;
            output[outputOffset + 4] = v2 & 0xF;
            output[outputOffset + 5] = v2 >>> 4 & 0xF;
            output[outputOffset + 6] = v3 & 0xF;
            output[outputOffset + 7] = v3 >>> 4 & 0xF;
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker4.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 4;
            }
            if (length >= 8) {
                Unpacker4.unpack8Scalar(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                inputBytesRead += 4;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker5
    implements IntBitUnpacker {
        private static final ByteVector MASK_5 = ByteVector.broadcast((VectorSpecies)ByteVector.SPECIES_64, (long)31L);
        private static final ByteVector MASK_BEFORE_LSHL = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 3, 0, 15, 1, 0, 7, 0}, (int)0);
        private static final ByteVector LSHR_BYTE_VECTOR = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 5, 2, 7, 4, 1, 6, 3}, (int)0);
        private static final ByteVector LSHL_BYTE_VECTOR = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])new byte[]{0, 3, 0, 1, 4, 0, 2, 0}, (int)0);
        private static final VectorShuffle<Byte> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ByteVector.SPECIES_64, (int[])new int[]{0, 0, 1, 1, 2, 3, 3, 4}, (int)0);
        private static final VectorShuffle<Byte> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ByteVector.SPECIES_64, (int[])new int[]{0, 1, 1, 2, 3, 3, 4, 4}, (int)0);

        private Unpacker5() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ByteVector byteVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])input, (int)inputOffset);
            ByteVector shiftRightResult = byteVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_BYTE_VECTOR).and((Vector)MASK_5);
            ByteVector shiftLeftResult = byteVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_BYTE_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            byte v1 = input.readByte();
            output[outputOffset] = (int)((long)v0 & 0x1FL);
            output[outputOffset + 1] = (int)((long)(v0 >>> 5) & 0x1FL);
            output[outputOffset + 2] = (int)((long)(v0 >>> 10) & 0x1FL);
            output[outputOffset + 3] = (int)((long)(v0 >>> 15) & 0x1FL);
            output[outputOffset + 4] = (int)((long)(v0 >>> 20) & 0x1FL);
            output[outputOffset + 5] = (int)((long)(v0 >>> 25) & 0x1FL);
            output[outputOffset + 6] = (int)((long)(v0 >>> 30) & 3L | ((long)v1 & 7L) << 2);
            output[outputOffset + 7] = (int)((long)(v1 >>> 3) & 0x1FL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker5.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 5;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker5.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker6
    implements IntBitUnpacker {
        private static final ShortVector MASK_6 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)63L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 0, 3, 0, 0, 15, 0, 0}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 6, 12, 2, 8, 14, 4, 10}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 0, 4, 0, 0, 2, 0, 0}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 0, 1, 1, 1, 2, 2}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 1, 1, 2, 2, 2}, (int)0);

        private Unpacker6() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])input, (int)inputOffset).castShape(ByteVector.SPECIES_128, 0).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_6);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            short v1 = input.readShort();
            output[outputOffset] = (int)((long)v0 & 0x3FL);
            output[outputOffset + 1] = (int)((long)(v0 >>> 6) & 0x3FL);
            output[outputOffset + 2] = (int)((long)(v0 >>> 12) & 0x3FL);
            output[outputOffset + 3] = (int)((long)(v0 >>> 18) & 0x3FL);
            output[outputOffset + 4] = (int)((long)(v0 >>> 24) & 0x3FL);
            output[outputOffset + 5] = (int)((long)(v0 >>> 30) & 3L | ((long)v1 & 0xFL) << 2);
            output[outputOffset + 6] = (int)((long)(v1 >>> 4) & 0x3FL);
            output[outputOffset + 7] = (int)((long)(v1 >>> 10) & 0x3FL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker6.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 6;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker6.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker7
    implements IntBitUnpacker {
        private static final ShortVector MASK_7 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)127L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 0, 31, 0, 7, 0, 1, 0}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 7, 14, 5, 12, 3, 10, 1}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 0, 2, 0, 4, 0, 6, 0}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 0, 1, 1, 2, 2, 3}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 1, 2, 2, 3, 3}, (int)0);

        private Unpacker7() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])input, (int)inputOffset).castShape(ByteVector.SPECIES_128, 0).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_7);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            short v1 = input.readShort();
            byte v2 = input.readByte();
            output[outputOffset] = (int)((long)v0 & 0x7FL);
            output[outputOffset + 1] = (int)((long)(v0 >>> 7) & 0x7FL);
            output[outputOffset + 2] = (int)((long)(v0 >>> 14) & 0x7FL);
            output[outputOffset + 3] = (int)((long)(v0 >>> 21) & 0x7FL);
            output[outputOffset + 4] = (int)((long)(v0 >>> 28) & 0xFL | ((long)v1 & 7L) << 4);
            output[outputOffset + 5] = (int)((long)(v1 >>> 3) & 0x7FL);
            output[outputOffset + 6] = (int)((long)(v1 >>> 10) & 0x3FL | ((long)v2 & 1L) << 6);
            output[outputOffset + 7] = (int)((long)(v2 >>> 1) & 0x7FL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker7.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 7;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker7.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker8
    implements IntBitUnpacker {
        private static final IntVector MASK_8 = IntVector.broadcast((VectorSpecies)IntVector.SPECIES_256, (int)255);

        private Unpacker8() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_64, (byte[])input, (int)inputOffset).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().and((Vector)MASK_8).intoArray(output, outputOffset);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 8) {
                Unpacker8.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 8;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker9
    implements IntBitUnpacker {
        private static final ShortVector MASK_9 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)511L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 3, 0, 15, 0, 63, 0, 255}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 9, 2, 11, 4, 13, 6, 15}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 7, 0, 5, 0, 3, 0, 1}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 1, 2, 2, 3, 3}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 1, 1, 2, 2, 3, 3, 4}, (int)0);

        private Unpacker9() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_128, (byte[])input, (int)inputOffset).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_9);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            byte v1 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFL);
            output[outputOffset + 1] = (int)(v0 >>> 9 & 0x1FFL);
            output[outputOffset + 2] = (int)(v0 >>> 18 & 0x1FFL);
            output[outputOffset + 3] = (int)(v0 >>> 27 & 0x1FFL);
            output[outputOffset + 4] = (int)(v0 >>> 36 & 0x1FFL);
            output[outputOffset + 5] = (int)(v0 >>> 45 & 0x1FFL);
            output[outputOffset + 6] = (int)(v0 >>> 54 & 0x1FFL);
            output[outputOffset + 7] = (int)(v0 >>> 63 & 1L | ((long)v1 & 0xFFL) << 1);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker9.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 9;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker9.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker10
    implements IntBitUnpacker {
        private static final ShortVector MASK_10 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)1023L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 15, 0, 255, 3, 0, 63, 0}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 10, 4, 14, 8, 2, 12, 6}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 6, 0, 2, 8, 0, 4, 0}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 1, 2, 3, 3, 4}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 1, 1, 2, 3, 3, 4, 4}, (int)0);

        private Unpacker10() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_128, (byte[])input, (int)inputOffset).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_10);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            short v1 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFL);
            output[outputOffset + 1] = (int)(v0 >>> 10 & 0x3FFL);
            output[outputOffset + 2] = (int)(v0 >>> 20 & 0x3FFL);
            output[outputOffset + 3] = (int)(v0 >>> 30 & 0x3FFL);
            output[outputOffset + 4] = (int)(v0 >>> 40 & 0x3FFL);
            output[outputOffset + 5] = (int)(v0 >>> 50 & 0x3FFL);
            output[outputOffset + 6] = (int)(v0 >>> 60 & 0xFL | ((long)v1 & 0x3FL) << 4);
            output[outputOffset + 7] = (int)((long)(v1 >>> 6) & 0x3FFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker10.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 10;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker10.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker11
    implements IntBitUnpacker {
        private static final ShortVector MASK_11 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)2047L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 63, 1, 0, 127, 3, 0, 255}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 11, 6, 1, 12, 7, 2, 13}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 5, 10, 0, 4, 9, 0, 3}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 2, 2, 3, 4, 4}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 1, 2, 2, 3, 4, 4, 5}, (int)0);

        private Unpacker11() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_128, (byte[])input, (int)inputOffset).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_11);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            short v1 = input.readShort();
            byte v2 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x7FFL);
            output[outputOffset + 1] = (int)(v0 >>> 11 & 0x7FFL);
            output[outputOffset + 2] = (int)(v0 >>> 22 & 0x7FFL);
            output[outputOffset + 3] = (int)(v0 >>> 33 & 0x7FFL);
            output[outputOffset + 4] = (int)(v0 >>> 44 & 0x7FFL);
            output[outputOffset + 5] = (int)(v0 >>> 55 & 0x1FFL | ((long)v1 & 3L) << 9);
            output[outputOffset + 6] = (int)((long)(v1 >>> 2) & 0x7FFL);
            output[outputOffset + 7] = (int)((long)(v1 >>> 13) & 7L | ((long)v2 & 0xFFL) << 3);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker11.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 11;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker11.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker12
    implements IntBitUnpacker {
        private static final ShortVector MASK_12 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)4095L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 255, 15, 0, 0, 255, 15, 0}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 12, 8, 4, 0, 12, 8, 4}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 4, 8, 0, 0, 4, 8, 0}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 2, 3, 3, 4, 5}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 1, 2, 2, 3, 4, 5, 5}, (int)0);

        private Unpacker12() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_128, (byte[])input, (int)inputOffset).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_12);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            output[outputOffset] = (int)(v0 & 0xFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 12 & 0xFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 24 & 0xFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 36 & 0xFFFL);
            output[outputOffset + 4] = (int)(v0 >>> 48 & 0xFFFL);
            output[outputOffset + 5] = (int)(v0 >>> 60 & 0xFL | ((long)v1 & 0xFFL) << 4);
            output[outputOffset + 6] = (int)((long)(v1 >>> 8) & 0xFFFL);
            output[outputOffset + 7] = (int)((long)(v1 >>> 20) & 0xFFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker12.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 12;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker12.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker13
    implements IntBitUnpacker {
        private static final ShortVector MASK_13 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)8191L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 1023, 127, 15, 1, 0, 2047, 255}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 13, 10, 7, 4, 1, 14, 11}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 3, 6, 9, 12, 0, 2, 5}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 2, 3, 4, 4, 5}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 1, 2, 3, 4, 4, 5, 6}, (int)0);

        private Unpacker13() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_128, (byte[])input, (int)inputOffset).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_13);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            byte v2 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFFL);
            output[outputOffset + 1] = (int)(v0 >>> 13 & 0x1FFFL);
            output[outputOffset + 2] = (int)(v0 >>> 26 & 0x1FFFL);
            output[outputOffset + 3] = (int)(v0 >>> 39 & 0x1FFFL);
            output[outputOffset + 4] = (int)(v0 >>> 52 & 0xFFFL | ((long)v1 & 1L) << 12);
            output[outputOffset + 5] = (int)((long)(v1 >>> 1) & 0x1FFFL);
            output[outputOffset + 6] = (int)((long)(v1 >>> 14) & 0x1FFFL);
            output[outputOffset + 7] = (int)((long)(v1 >>> 27) & 0x1FL | ((long)v2 & 0xFFL) << 5);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker13.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 13;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker13.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker14
    implements IntBitUnpacker {
        private static final ShortVector MASK_14 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)16383L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 4095, 1023, 255, 63, 15, 3, 0}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 14, 12, 10, 8, 6, 4, 2}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 2, 4, 6, 8, 10, 12, 0}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 2, 3, 4, 5, 6}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 6}, (int)0);

        private Unpacker14() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_128, (byte[])input, (int)inputOffset).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_14);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            short v2 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFFL);
            output[outputOffset + 1] = (int)(v0 >>> 14 & 0x3FFFL);
            output[outputOffset + 2] = (int)(v0 >>> 28 & 0x3FFFL);
            output[outputOffset + 3] = (int)(v0 >>> 42 & 0x3FFFL);
            output[outputOffset + 4] = (int)(v0 >>> 56 & 0xFFL | ((long)v1 & 0x3FL) << 8);
            output[outputOffset + 5] = (int)((long)(v1 >>> 6) & 0x3FFFL);
            output[outputOffset + 6] = (int)((long)(v1 >>> 20) & 0xFFFL | ((long)v2 & 3L) << 12);
            output[outputOffset + 7] = (int)((long)(v2 >>> 2) & 0x3FFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker14.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 14;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker14.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker15
    implements IntBitUnpacker {
        private static final ShortVector MASK_15 = ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_128, (long)32767L);
        private static final ShortVector MASK_BEFORE_LSHL = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 16383, 8191, 4095, 2047, 1023, 511, 255}, (int)0);
        private static final ShortVector LSHR_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 15, 14, 13, 12, 11, 10, 9}, (int)0);
        private static final ShortVector LSHL_SHORT_VECTOR = ShortVector.fromArray((VectorSpecies)ShortVector.SPECIES_128, (short[])new short[]{0, 1, 2, 3, 4, 5, 6, 7}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 0, 1, 2, 3, 4, 5, 6}, (int)0);
        private static final VectorShuffle<Short> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)ShortVector.SPECIES_128, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7}, (int)0);

        private Unpacker15() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ShortVector shortVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_128, (byte[])input, (int)inputOffset).reinterpretAsShorts();
            ShortVector shiftRightResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_SHORT_VECTOR).and((Vector)MASK_15);
            ShortVector shiftLeftResult = shortVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_SHORT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            short v2 = input.readShort();
            byte v3 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x7FFFL);
            output[outputOffset + 1] = (int)(v0 >>> 15 & 0x7FFFL);
            output[outputOffset + 2] = (int)(v0 >>> 30 & 0x7FFFL);
            output[outputOffset + 3] = (int)(v0 >>> 45 & 0x7FFFL);
            output[outputOffset + 4] = (int)(v0 >>> 60 & 0xFL | ((long)v1 & 0x7FFL) << 4);
            output[outputOffset + 5] = (int)((long)(v1 >>> 11) & 0x7FFFL);
            output[outputOffset + 6] = (int)((long)(v1 >>> 26) & 0x3FL | ((long)v2 & 0x1FFL) << 6);
            output[outputOffset + 7] = (int)((long)(v2 >>> 9) & 0x7FL | ((long)v3 & 0xFFL) << 7);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker15.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 15;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker15.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker16
    implements IntBitUnpacker {
        private static final IntVector MASK_16 = IntVector.broadcast((VectorSpecies)IntVector.SPECIES_256, (int)65535);

        private Unpacker16() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_128, (byte[])input, (int)inputOffset).reinterpretAsShorts().castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().and((Vector)MASK_16).intoArray(output, outputOffset);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 8) {
                Unpacker16.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 16;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker17
    implements IntBitUnpacker {
        private static final IntVector MASK_17 = IntVector.broadcast((VectorSpecies)IntVector.SPECIES_256, (int)131071);
        private static final IntVector MASK_BEFORE_LSHL = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 3, 0, 15, 0, 63, 0, 255}, (int)0);
        private static final IntVector LSHR_INT_VECTOR = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 17, 2, 19, 4, 21, 6, 23}, (int)0);
        private static final IntVector LSHL_INT_VECTOR = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 15, 0, 13, 0, 11, 0, 9}, (int)0);
        private static final VectorShuffle<Integer> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 0, 1, 1, 2, 2, 3, 3}, (int)0);
        private static final VectorShuffle<Integer> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 1, 1, 2, 2, 3, 3, 4}, (int)0);

        private Unpacker17() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            IntVector intVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])input, (int)inputOffset).reinterpretAsInts();
            IntVector shiftRightResult = intVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_INT_VECTOR).and((Vector)MASK_17);
            IntVector shiftLeftResult = intVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_INT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            byte v2 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 17 & 0x1FFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 34 & 0x1FFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 51 & 0x1FFFL | (v1 & 0xFL) << 13);
            output[outputOffset + 4] = (int)(v1 >>> 4 & 0x1FFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 21 & 0x1FFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 38 & 0x1FFFFL);
            output[outputOffset + 7] = (int)(v1 >>> 55 & 0x1FFL | ((long)v2 & 0xFFL) << 9);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker17.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 17;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker17.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker18
    implements IntBitUnpacker {
        private static final IntVector MASK_18 = IntVector.broadcast((VectorSpecies)IntVector.SPECIES_256, (int)262143);
        private static final IntVector MASK_BEFORE_LSHL = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 15, 0, 255, 0, 4095, 0, 65535}, (int)0);
        private static final IntVector LSHR_INT_VECTOR = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 18, 4, 22, 8, 26, 12, 30}, (int)0);
        private static final IntVector LSHL_INT_VECTOR = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 14, 0, 10, 0, 6, 0, 2}, (int)0);
        private static final VectorShuffle<Integer> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 0, 1, 1, 2, 2, 3, 3}, (int)0);
        private static final VectorShuffle<Integer> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 1, 1, 2, 2, 3, 3, 4}, (int)0);

        private Unpacker18() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            IntVector intVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])input, (int)inputOffset).reinterpretAsInts();
            IntVector shiftRightResult = intVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_INT_VECTOR).and((Vector)MASK_18);
            IntVector shiftLeftResult = intVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_INT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            short v2 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 18 & 0x3FFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 36 & 0x3FFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 54 & 0x3FFL | (v1 & 0xFFL) << 10);
            output[outputOffset + 4] = (int)(v1 >>> 8 & 0x3FFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 26 & 0x3FFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 44 & 0x3FFFFL);
            output[outputOffset + 7] = (int)(v1 >>> 62 & 3L | ((long)v2 & 0xFFFFL) << 2);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker18.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 18;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker18.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker19
    implements IntBitUnpacker {
        private static final IntVector MASK_19 = IntVector.broadcast((VectorSpecies)IntVector.SPECIES_256, (int)524287);
        private static final IntVector MASK_BEFORE_LSHL = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 63, 0, 4095, 0, 262143, 31, 0}, (int)0);
        private static final IntVector LSHR_INT_VECTOR = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 19, 6, 25, 12, 31, 18, 5}, (int)0);
        private static final IntVector LSHL_INT_VECTOR = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 13, 0, 7, 0, 1, 14, 0}, (int)0);
        private static final VectorShuffle<Integer> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 0, 1, 1, 2, 2, 3, 4}, (int)0);
        private static final VectorShuffle<Integer> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 1, 1, 2, 2, 3, 4, 4}, (int)0);

        private Unpacker19() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            IntVector intVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])input, (int)inputOffset).reinterpretAsInts();
            IntVector shiftRightResult = intVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_INT_VECTOR).and((Vector)MASK_19);
            IntVector shiftLeftResult = intVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_INT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            short v2 = input.readShort();
            byte v3 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x7FFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 19 & 0x7FFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 38 & 0x7FFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 57 & 0x7FL | (v1 & 0xFFFL) << 7);
            output[outputOffset + 4] = (int)(v1 >>> 12 & 0x7FFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 31 & 0x7FFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 50 & 0x3FFFL | ((long)v2 & 0x1FL) << 14);
            output[outputOffset + 7] = (int)((long)(v2 >>> 5) & 0x7FFL | ((long)v3 & 0xFFL) << 11);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker19.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 19;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker19.unpack8(output, outputOffset, input);
            }
        }
    }

    private static final class Unpacker20
    implements IntBitUnpacker {
        private static final IntVector MASK_20 = IntVector.broadcast((VectorSpecies)IntVector.SPECIES_256, (int)1048575);
        private static final IntVector MASK_BEFORE_LSHL = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 255, 0, 65535, 15, 0, 4095, 0}, (int)0);
        private static final IntVector LSHR_INT_VECTOR = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 20, 8, 28, 16, 4, 24, 12}, (int)0);
        private static final IntVector LSHL_INT_VECTOR = IntVector.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 12, 0, 4, 16, 0, 8, 0}, (int)0);
        private static final VectorShuffle<Integer> SHUFFLE_BEFORE_LSHR = VectorShuffle.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 0, 1, 1, 2, 3, 3, 4}, (int)0);
        private static final VectorShuffle<Integer> SHUFFLE_BEFORE_LSHL = VectorShuffle.fromArray((VectorSpecies)IntVector.SPECIES_256, (int[])new int[]{0, 1, 1, 2, 3, 3, 4, 4}, (int)0);

        private Unpacker20() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            IntVector intVector = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])input, (int)inputOffset).reinterpretAsInts();
            IntVector shiftRightResult = intVector.rearrange(SHUFFLE_BEFORE_LSHR).lanewise(VectorOperators.LSHR, (Vector)LSHR_INT_VECTOR).and((Vector)MASK_20);
            IntVector shiftLeftResult = intVector.rearrange(SHUFFLE_BEFORE_LSHL).and((Vector)MASK_BEFORE_LSHL).lanewise(VectorOperators.LSHL, (Vector)LSHL_INT_VECTOR);
            shiftRightResult.or((Vector)shiftLeftResult).castShape(IntVector.SPECIES_256, 0).reinterpretAsInts().intoArray(output, outputOffset);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            int v2 = input.readInt();
            output[outputOffset] = (int)(v0 & 0xFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 20 & 0xFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 40 & 0xFFFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 60 & 0xFL | (v1 & 0xFFFFL) << 4);
            output[outputOffset + 4] = (int)(v1 >>> 16 & 0xFFFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 36 & 0xFFFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 56 & 0xFFL | ((long)v2 & 0xFFFL) << 8);
            output[outputOffset + 7] = (int)((long)(v2 >>> 12) & 0xFFFFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 16) {
                Unpacker20.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 20;
            }
            input.skip(inputBytesRead);
            if (length >= 8) {
                Unpacker20.unpack8(output, outputOffset, input);
            }
        }
    }
}

