/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.spi.block.Block;
import io.trino.spi.block.VariableWidthBlock;
import java.util.List;
import java.util.Optional;

public class BinaryColumnAdapter
implements ColumnAdapter<BinaryBuffer> {
    public static final BinaryColumnAdapter BINARY_ADAPTER = new BinaryColumnAdapter();

    @Override
    public BinaryBuffer createBuffer(int batchSize) {
        return new BinaryBuffer(batchSize);
    }

    @Override
    public BinaryBuffer createTemporaryBuffer(int currentOffset, int size, BinaryBuffer buffer) {
        return buffer.withTemporaryOffsets(currentOffset, size);
    }

    @Override
    public void copyValue(BinaryBuffer source, int sourceIndex, BinaryBuffer destination, int destinationIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block createNullableBlock(boolean[] nulls, BinaryBuffer values) {
        return new VariableWidthBlock(values.getValueCount(), values.asSlice(), values.getOffsets(), Optional.of(nulls));
    }

    @Override
    public Block createNullableDictionaryBlock(BinaryBuffer dictionary, int nonNullsCount) {
        Preconditions.checkArgument((dictionary.getValueCount() == nonNullsCount + 1 ? 1 : 0) != 0, (String)"Dictionary buffer size %s did not match the expected value of %s", (int)dictionary.getValueCount(), (int)(nonNullsCount + 1));
        boolean[] nulls = new boolean[nonNullsCount + 1];
        nulls[nonNullsCount] = true;
        int[] offsets = dictionary.getOffsets();
        offsets[nonNullsCount + 1] = offsets[nonNullsCount];
        return new VariableWidthBlock(dictionary.getValueCount(), dictionary.asSlice(), offsets, Optional.of(nulls));
    }

    @Override
    public Block createNonNullBlock(BinaryBuffer values) {
        return new VariableWidthBlock(values.getValueCount(), values.asSlice(), values.getOffsets(), Optional.empty());
    }

    @Override
    public void unpackNullValues(BinaryBuffer sourceBuffer, BinaryBuffer destinationBuffer, boolean[] isNull, int destOffset, int nonNullCount, int totalValuesCount) {
        int endOffset = destOffset + totalValuesCount;
        int srcOffset = 0;
        int[] destination = destinationBuffer.getOffsets();
        int[] source = sourceBuffer.getOffsets();
        while (srcOffset < nonNullCount) {
            destination[destOffset] = source[srcOffset];
            srcOffset += ParquetReaderUtils.castToByteNegate(isNull[destOffset]);
            ++destOffset;
        }
        while (destOffset <= endOffset) {
            destination[destOffset++] = source[nonNullCount];
        }
    }

    @Override
    public void decodeDictionaryIds(BinaryBuffer values, int offset, int length, int[] ids, BinaryBuffer dictionary) {
        Slice dictionarySlice = dictionary.asSlice();
        int[] outputOffsets = values.getOffsets();
        int[] dictionaryOffsets = dictionary.getOffsets();
        int outputLength = 0;
        for (int i = 0; i < length; ++i) {
            int id = ids[i];
            int positionLength = dictionaryOffsets[id + 1] - dictionaryOffsets[id];
            outputLength += positionLength;
            outputOffsets[offset + i + 1] = outputOffsets[offset + i] + positionLength;
        }
        byte[] outputChunk = new byte[outputLength];
        int outputIndex = 0;
        for (int i = 0; i < length; ++i) {
            int id = ids[i];
            int startIndex = dictionaryOffsets[id];
            int endIndex = dictionaryOffsets[id + 1];
            int positionLength = endIndex - startIndex;
            dictionarySlice.getBytes(startIndex, outputChunk, outputIndex, positionLength);
            outputIndex += positionLength;
        }
        values.addChunk(Slices.wrappedBuffer((byte[])outputChunk));
    }

    @Override
    public long getSizeInBytes(BinaryBuffer values) {
        return values.getRetainedSize();
    }

    @Override
    public BinaryBuffer merge(List<BinaryBuffer> buffers) {
        if (buffers.isEmpty()) {
            return new BinaryBuffer(0);
        }
        int valueCount = 0;
        for (BinaryBuffer binaryBuffer : buffers) {
            valueCount += binaryBuffer.getValueCount();
        }
        BinaryBuffer result = new BinaryBuffer(valueCount);
        for (BinaryBuffer binaryBuffer : buffers) {
            result.addChunk(binaryBuffer.asSlice());
        }
        int[] nArray = result.getOffsets();
        int[] firstOffsets = buffers.get(0).getOffsets();
        System.arraycopy(firstOffsets, 0, nArray, 0, firstOffsets.length);
        int dataOffset = firstOffsets[firstOffsets.length - 1];
        int outputArrayOffset = firstOffsets.length;
        for (int i = 1; i < buffers.size(); ++i) {
            int[] currentOffsets = buffers.get(i).getOffsets();
            for (int j = 1; j < currentOffsets.length; ++j) {
                nArray[outputArrayOffset + j - 1] = dataOffset + currentOffsets[j];
            }
            dataOffset = nArray[(outputArrayOffset += currentOffsets.length - 1) - 1];
        }
        return result;
    }
}

