/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DoubleType;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class DoubleValueWriter
extends PrimitiveValueWriter {
    public DoubleValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
    }

    @Override
    public void write(Block block) {
        ValuesWriter valuesWriter = Objects.requireNonNull(this.getValuesWriter(), "valuesWriter is null");
        Statistics<?> statistics = Objects.requireNonNull(this.getStatistics(), "statistics is null");
        boolean mayHaveNull = block.mayHaveNull();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (mayHaveNull && block.isNull(i)) continue;
            double value = DoubleType.DOUBLE.getDouble(block, i);
            valuesWriter.writeDouble(value);
            statistics.updateStats(value);
        }
    }
}

