/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public class Int96TimestampValueWriter
extends PrimitiveValueWriter {
    private final TimestampType timestampType;
    private final DateTimeZone parquetTimeZone;

    public Int96TimestampValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType, DateTimeZone parquetTimeZone) {
        super(parquetType, valuesWriter);
        TimestampType timestampType;
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).getPrecision() <= 9 ? 1 : 0) != 0, (String)"type %s is not a TimestampType with precision <= 9", (Object)type);
        this.timestampType = (TimestampType)type;
        Preconditions.checkArgument((boolean)parquetType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96), (String)"parquetType %s is not INT96", (Object)parquetType);
        this.parquetTimeZone = Objects.requireNonNull(parquetTimeZone, "parquetTimeZone is null");
    }

    @Override
    public void write(Block block) {
        if (this.timestampType.isShort()) {
            this.writeShortTimestamps(block);
        } else {
            this.writeLongTimestamps(block);
        }
    }

    private void writeShortTimestamps(Block block) {
        ValuesWriter valuesWriter = Objects.requireNonNull(this.getValuesWriter(), "valuesWriter is null");
        Statistics<?> statistics = Objects.requireNonNull(this.getStatistics(), "statistics is null");
        boolean mayHaveNull = block.mayHaveNull();
        byte[] buffer = new byte[12];
        Binary reusedBinary = Binary.fromReusedByteArray((byte[])buffer);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (mayHaveNull && block.isNull(position)) continue;
            long epochMicros = this.timestampType.getLong(block, position);
            long localEpochMillis = Math.floorDiv(epochMicros, 1000);
            int nanosOfMillis = Math.floorMod(epochMicros, 1000) * 1000;
            this.convertAndWriteToBuffer(localEpochMillis, nanosOfMillis, buffer);
            valuesWriter.writeBytes(reusedBinary);
            statistics.updateStats(reusedBinary);
        }
    }

    private void writeLongTimestamps(Block block) {
        ValuesWriter valuesWriter = Objects.requireNonNull(this.getValuesWriter(), "valuesWriter is null");
        Statistics<?> statistics = Objects.requireNonNull(this.getStatistics(), "statistics is null");
        boolean mayHaveNull = block.mayHaveNull();
        byte[] buffer = new byte[12];
        Binary reusedBinary = Binary.fromReusedByteArray((byte[])buffer);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (mayHaveNull && block.isNull(position)) continue;
            LongTimestamp timestamp = (LongTimestamp)this.timestampType.getObject(block, position);
            long epochMicros = timestamp.getEpochMicros();
            int nanosOfMicro = timestamp.getPicosOfMicro() / 1000;
            long localEpochMillis = Math.floorDiv(epochMicros, 1000);
            int nanosOfMillis = Math.floorMod(epochMicros, 1000) * 1000 + nanosOfMicro;
            this.convertAndWriteToBuffer(localEpochMillis, nanosOfMillis, buffer);
            valuesWriter.writeBytes(reusedBinary);
            statistics.updateStats(reusedBinary);
        }
    }

    private void convertAndWriteToBuffer(long localEpochMillis, int nanosOfMillis, byte[] buffer) {
        long epochMillis = this.parquetTimeZone.convertLocalToUTC(localEpochMillis, false);
        long epochDay = Math.floorDiv(epochMillis, 86400000);
        int julianDay = 2440588 + Math.toIntExact(epochDay);
        long nanosOfEpochDay = (long)nanosOfMillis + (long)Math.floorMod(epochMillis, 86400000) * 1000000L;
        ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).putLong(0, nanosOfEpochDay).putInt(8, julianDay);
    }
}

