/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.ColumnDescriptorValuesWriter;
import io.trino.parquet.writer.valuewriter.RunLengthBitPackingHybridEncoder;
import java.io.IOException;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.io.ParquetEncodingException;

public class RunLengthBitPackingHybridValuesWriter
implements ColumnDescriptorValuesWriter {
    private final RunLengthBitPackingHybridEncoder encoder;

    public RunLengthBitPackingHybridValuesWriter(int bitWidth, int maxCapacityHint) {
        this.encoder = new RunLengthBitPackingHybridEncoder(bitWidth, maxCapacityHint);
    }

    @Override
    public void writeInteger(int value) {
        try {
            this.encoder.writeInt(value);
        }
        catch (IOException e) {
            throw new ParquetEncodingException((Throwable)e);
        }
    }

    @Override
    public void writeRepeatInteger(int value, int valueRepetitions) {
        try {
            this.encoder.writeRepeatedInteger(value, valueRepetitions);
        }
        catch (IOException e) {
            throw new ParquetEncodingException((Throwable)e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.encoder.getBufferedSize();
    }

    @Override
    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    @Override
    public BytesInput getBytes() {
        try {
            BytesInput rle = this.encoder.toBytes();
            return BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.fromInt((int)Math.toIntExact(rle.size())), rle});
        }
        catch (IOException e) {
            throw new ParquetEncodingException((Throwable)e);
        }
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.RLE;
    }

    @Override
    public void reset() {
        this.encoder.reset();
    }
}

