/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapHashTables;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.lang.reflect.Array;

public final class ReferenceCountMap
extends Long2IntOpenHashMap {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ReferenceCountMap.class);

    public int incrementAndGet(Object key) {
        return this.addTo(ReferenceCountMap.getHashCode(key), 1) + 1;
    }

    public int incrementAndGetWithExtraIdentity(Object key, long extraIdentity) {
        return this.addTo(ReferenceCountMap.getHashCode(key, (int)extraIdentity), 1) + 1;
    }

    public int decrementAndGet(Object key) {
        long hashCode = ReferenceCountMap.getHashCode(key);
        int previousCount = this.addTo(hashCode, -1);
        if (previousCount == 1) {
            this.remove(hashCode);
        }
        return previousCount - 1;
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((int[])this.value);
    }

    private static int getExtraIdentity(Object key) {
        int extraIdentity;
        if (key == null) {
            extraIdentity = 0;
        } else if (key instanceof Block) {
            Block block = (Block)key;
            extraIdentity = (int)block.getRetainedSizeInBytes();
        } else if (key instanceof Slice) {
            Slice slice = (Slice)key;
            extraIdentity = (int)slice.getRetainedSize();
        } else if (key.getClass().isArray()) {
            extraIdentity = Array.getLength(key);
        } else if (key instanceof MapHashTables) {
            MapHashTables mapHashTables = (MapHashTables)key;
            extraIdentity = (int)mapHashTables.getRetainedSizeInBytes();
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type for %s", key));
        }
        return extraIdentity;
    }

    private static long getHashCode(Object key) {
        return ReferenceCountMap.getHashCode(key, ReferenceCountMap.getExtraIdentity(key));
    }

    private static long getHashCode(Object key, int extraIdentity) {
        return ((long)System.identityHashCode(key) << 32) + (long)extraIdentity;
    }
}

