/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.metrics.MetricsConfig;
import alluxio.metrics.MetricsSystem;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.filesystem.alluxio.AlluxioCacheStats;
import io.trino.filesystem.alluxio.AlluxioFileSystemCache;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheConfig;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.ConsistentHashingHostAddressProvider;
import io.trino.filesystem.cache.ConsistentHashingHostAddressProviderConfig;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import io.trino.spi.catalog.CatalogName;
import java.util.Properties;
import org.weakref.jmx.guice.ExportBinder;

public class AlluxioFileSystemCacheModule
extends AbstractConfigurationAwareModule {
    private final boolean isCoordinator;

    public AlluxioFileSystemCacheModule(boolean isCoordinator) {
        this.isCoordinator = isCoordinator;
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(AlluxioFileSystemCacheConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ConsistentHashingHostAddressProviderConfig.class);
        binder.bind(AlluxioCacheStats.class).in(Scopes.SINGLETON);
        Provider catalogName = binder.getProvider(CatalogName.class);
        ExportBinder.newExporter((Binder)binder).export(AlluxioCacheStats.class).as(generator -> generator.generatedNameOf(AlluxioCacheStats.class, ((CatalogName)catalogName.get()).toString()));
        if (this.isCoordinator) {
            OptionalBinder.newOptionalBinder((Binder)binder, CachingHostAddressProvider.class).setBinding().to(ConsistentHashingHostAddressProvider.class).in(Scopes.SINGLETON);
        }
        binder.bind(TrinoFileSystemCache.class).to(AlluxioFileSystemCache.class).in(Scopes.SINGLETON);
        Properties metricProps = new Properties();
        metricProps.put("sink.jmx.class", "alluxio.metrics.sink.JmxSink");
        metricProps.put("sink.jmx.domain", "org.alluxio");
        MetricsSystem.startSinksFromConfig((MetricsConfig)new MetricsConfig(metricProps));
    }
}

