/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.token;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.nimbusds.oauth2.sdk.token.DPoPTokenError;
import com.nimbusds.oauth2.sdk.token.TokenSchemeError;
import com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.net.URI;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class AccessTokenParseUtils {
    public static void parseAndEnsureTypeFromJSONObject(JSONObject jsonObject, AccessTokenType type) throws ParseException {
        if (!new AccessTokenType(JSONObjectUtils.getNonBlankString(jsonObject, "token_type")).equals(type)) {
            throw new ParseException("The token type must be " + String.valueOf(type));
        }
    }

    public static String parseValueFromJSONObject(JSONObject params) throws ParseException {
        return JSONObjectUtils.getNonBlankString(params, "access_token");
    }

    public static long parseLifetimeFromJSONObject(JSONObject jsonObject) throws ParseException {
        if (jsonObject.containsKey((Object)"expires_in")) {
            if (jsonObject.get((Object)"expires_in") instanceof Number) {
                return JSONObjectUtils.getLong(jsonObject, "expires_in");
            }
            String lifetimeStr = JSONObjectUtils.getNonBlankString(jsonObject, "expires_in");
            try {
                return Long.parseLong(lifetimeStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("expires_in must be an integer");
            }
        }
        return 0L;
    }

    public static Scope parseScopeFromJSONObject(JSONObject jsonObject) throws ParseException {
        return Scope.parse(JSONObjectUtils.getString(jsonObject, "scope", null));
    }

    public static List<AuthorizationDetail> parseAuthorizationDetailsFromJSONObject(JSONObject jsonObject) throws ParseException {
        JSONArray jsonArray = JSONObjectUtils.getJSONArray(jsonObject, "authorization_details", null);
        if (jsonArray == null) {
            return null;
        }
        return AuthorizationDetail.parseList(JSONArrayUtils.toJSONObjectList(jsonArray));
    }

    public static TokenTypeURI parseIssuedTokenTypeFromJSONObject(JSONObject jsonObject) throws ParseException {
        String issuedTokenTypeString = JSONObjectUtils.getString(jsonObject, "issued_token_type", null);
        if (issuedTokenTypeString == null) {
            return null;
        }
        try {
            return TokenTypeURI.parse(issuedTokenTypeString);
        }
        catch (ParseException e) {
            throw new ParseException("Invalid issued_token_type", e);
        }
    }

    private static TokenSchemeError getTypedMissingTokenError(AccessTokenType type) {
        if (AccessTokenType.BEARER.equals(type)) {
            return BearerTokenError.MISSING_TOKEN;
        }
        if (AccessTokenType.DPOP.equals(type)) {
            return DPoPTokenError.MISSING_TOKEN;
        }
        return new GenericTokenSchemeError(type, null, null, 401);
    }

    private static TokenSchemeError getTypedInvalidRequestError(AccessTokenType type) {
        if (AccessTokenType.BEARER.equals(type)) {
            return BearerTokenError.INVALID_REQUEST;
        }
        if (AccessTokenType.DPOP.equals(type)) {
            return DPoPTokenError.INVALID_REQUEST;
        }
        return new GenericTokenSchemeError(type, "invalid_request", "Invalid request", 400);
    }

    public static String parseValueFromAuthorizationHeader(String header, AccessTokenType type) throws ParseException {
        if (StringUtils.isBlank(header)) {
            TokenSchemeError schemeError = AccessTokenParseUtils.getTypedMissingTokenError(type);
            throw new ParseException("Missing HTTP Authorization header", schemeError);
        }
        String[] parts = header.split("\\s", 2);
        if (parts.length != 2) {
            TokenSchemeError schemeError = AccessTokenParseUtils.getTypedInvalidRequestError(type);
            throw new ParseException("Invalid HTTP Authorization header value", schemeError);
        }
        if (!parts[0].equalsIgnoreCase(type.getValue())) {
            TokenSchemeError schemeError = AccessTokenParseUtils.getTypedInvalidRequestError(type);
            throw new ParseException("Token type must be " + String.valueOf(type), schemeError);
        }
        if (StringUtils.isBlank(parts[1])) {
            TokenSchemeError schemeError = AccessTokenParseUtils.getTypedInvalidRequestError(type);
            throw new ParseException("Invalid HTTP Authorization header value: Missing token", schemeError);
        }
        return parts[1];
    }

    public static String parseValueFromQueryParameters(Map<String, List<String>> parameters, AccessTokenType type) throws ParseException {
        if (!parameters.containsKey("access_token")) {
            TokenSchemeError schemeError = AccessTokenParseUtils.getTypedMissingTokenError(type);
            throw new ParseException("Missing access token parameter", schemeError);
        }
        String accessTokenValue = MultivaluedMapUtils.getFirstValue(parameters, "access_token");
        if (StringUtils.isBlank(accessTokenValue)) {
            TokenSchemeError schemeError = AccessTokenParseUtils.getTypedInvalidRequestError(type);
            throw new ParseException("Blank / empty access token", schemeError);
        }
        return accessTokenValue;
    }

    public static String parseValueFromQueryParameters(Map<String, List<String>> parameters) throws ParseException {
        String accessTokenValue = MultivaluedMapUtils.getFirstValue(parameters, "access_token");
        if (StringUtils.isBlank(accessTokenValue)) {
            throw new ParseException("Missing access token");
        }
        return accessTokenValue;
    }

    public static AccessTokenType determineAccessTokenTypeFromAuthorizationHeader(String header) throws ParseException {
        String[] parts = header.split("\\s", 2);
        if (parts.length < 2 || StringUtils.isBlank(parts[0]) || StringUtils.isBlank(parts[1])) {
            throw new ParseException("Invalid Authorization header");
        }
        if (parts[0].equalsIgnoreCase(AccessTokenType.BEARER.getValue())) {
            return AccessTokenType.BEARER;
        }
        if (parts[0].equalsIgnoreCase(AccessTokenType.DPOP.getValue())) {
            return AccessTokenType.DPOP;
        }
        return new AccessTokenType(parts[0]);
    }

    private AccessTokenParseUtils() {
    }

    private static class GenericTokenSchemeError
    extends TokenSchemeError {
        private static final long serialVersionUID = -8049139536364886132L;

        public GenericTokenSchemeError(AccessTokenType scheme, String code, String description, int httpStatusCode) {
            super(scheme, code, description, httpStatusCode, null, null, null);
        }

        @Override
        public TokenSchemeError setDescription(String description) {
            return this;
        }

        @Override
        public TokenSchemeError appendDescription(String text) {
            return this;
        }

        @Override
        public TokenSchemeError setHTTPStatusCode(int httpStatusCode) {
            return this;
        }

        @Override
        public TokenSchemeError setURI(URI uri) {
            return this;
        }

        @Override
        public TokenSchemeError setRealm(String realm) {
            return this;
        }

        @Override
        public TokenSchemeError setScope(Scope scope) {
            return this;
        }
    }
}

