/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Reconfigurable;
import alluxio.conf.ReconfigurableRegistry;
import alluxio.heartbeat.HeartbeatContext;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatTimer;
import alluxio.heartbeat.SleepIntervalSupplier;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.user.UserState;
import alluxio.util.CommonUtils;
import alluxio.util.SecurityUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Clock;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class HeartbeatThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatThread.class);
    private final String mThreadName;
    private final HeartbeatExecutor mExecutor;
    private final UserState mUserState;
    private HeartbeatTimer mTimer;
    private AlluxioConfiguration mConfiguration;
    private Status mStatus;

    @VisibleForTesting
    public static String generateThreadName(String executorName, String threadId) {
        if (threadId == null || threadId.isEmpty()) {
            return executorName;
        }
        return executorName + "-" + threadId;
    }

    public HeartbeatThread(String executorName, String threadId, HeartbeatExecutor executor, Supplier<SleepIntervalSupplier> intervalSupplier, AlluxioConfiguration conf, UserState userState, Clock clock) {
        this.mThreadName = HeartbeatThread.generateThreadName(executorName, threadId);
        this.mExecutor = (HeartbeatExecutor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        Class<? extends HeartbeatTimer> timerClass = HeartbeatContext.getTimerClass(executorName);
        this.mTimer = CommonUtils.createNewClassInstance(timerClass, new Class[]{String.class, Clock.class, Supplier.class}, new Object[]{this.mThreadName, clock, intervalSupplier});
        this.mConfiguration = conf;
        this.mUserState = userState;
        this.mStatus = Status.INIT;
        if (this.mTimer instanceof Reconfigurable) {
            ReconfigurableRegistry.register((Reconfigurable)((Object)this.mTimer));
        }
    }

    public HeartbeatThread(String executorName, HeartbeatExecutor executor, Supplier<SleepIntervalSupplier> intervalSupplier, AlluxioConfiguration conf, UserState userState) {
        this(executorName, null, executor, intervalSupplier, conf, userState, Clock.systemUTC());
    }

    public HeartbeatThread(String executorName, HeartbeatExecutor executor, Supplier<SleepIntervalSupplier> intervalSupplier, AlluxioConfiguration conf, UserState userState, Clock clock) {
        this(executorName, null, executor, intervalSupplier, conf, userState, clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long counter = 0L;
        try {
            if (SecurityUtils.isSecurityEnabled(this.mConfiguration) && AuthenticatedClientUser.get(this.mConfiguration) == null) {
                AuthenticatedClientUser.set(this.mUserState.getUser().getName());
            }
        }
        catch (IOException e) {
            LOG.error("Failed to set AuthenticatedClientUser in HeartbeatThread.");
        }
        Thread.currentThread().setName(this.mThreadName);
        try {
            while (!Thread.interrupted()) {
                this.mStatus = Status.WAITING;
                long limitTime = this.mTimer.tick();
                this.mStatus = Status.RUNNING;
                LOG.debug("{} #{} will run limited in {}s", new Object[]{this.mThreadName, counter++, limitTime / 1000L});
                this.mExecutor.heartbeat(limitTime);
            }
        }
        catch (InterruptedException limitTime) {
        }
        catch (Exception e) {
            LOG.error("Uncaught exception in heartbeat executor, Heartbeat Thread shutting down", (Throwable)e);
        }
        finally {
            this.mStatus = Status.STOPPED;
            if (this.mTimer instanceof Reconfigurable) {
                ReconfigurableRegistry.unregister((Reconfigurable)((Object)this.mTimer));
            }
            this.mExecutor.close();
        }
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public static enum Status {
        INIT,
        WAITING,
        RUNNING,
        STOPPED;

    }
}

