/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import io.prometheus.metrics.core.metrics.Histogram;
import io.prometheus.metrics.exporter.common.PrometheusHttpExchange;
import io.prometheus.metrics.exporter.common.PrometheusHttpRequest;
import io.prometheus.metrics.exporter.common.PrometheusHttpResponse;
import io.prometheus.metrics.exporter.common.PrometheusScrapeHandler;
import io.prometheus.metrics.exporter.servlet.jakarta.HttpExchangeAdapter;
import io.prometheus.metrics.instrumentation.jvm.JvmMetrics;
import io.prometheus.metrics.model.registry.Collector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.Unit;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.function.DoubleSupplier;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public final class MultiDimensionalMetricsSystem {
    public static final Histogram DATA_ACCESS = ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.builder().name("alluxio_data_access")).help("aggregated throughput of all the data access")).unit(Unit.BYTES)).labelNames(new String[]{"method"})).build();
    public static final Counter META_OPERATION = ((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_meta_operation").help("counter of rpc calls of the meta operations")).labelNames(new String[]{"op"})).build();
    public static final Counter UFS_DATA_ACCESS = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_ufs_data_access").help("amount of the ufs access")).unit(Unit.BYTES)).labelNames(new String[]{"method"})).build();
    public static final Counter CACHED_DATA_READ = ((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_cached_data_read").help("amount of the read cached data")).unit(Unit.BYTES)).build();
    public static final Counter EXTERNAL_DATA_READ = ((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_external_data_read").help("amount of the read data when cache missed on client")).unit(Unit.BYTES)).build();
    public static final Counter CACHED_EVICTED_DATA = ((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_cached_evicted_data").help("amount of the evicted data")).unit(Unit.BYTES)).build();
    public static final DoubleSupplier NULL_SUPPLIER;
    private static DoubleSupplier sCacheStorageSupplier;
    private static DoubleSupplier sCacheManagerLoadingPagesSupplier;
    public static final GaugeWithCallback CACHED_STORAGE;
    public static final GaugeWithCallback CACHED_CAPACITY;
    public static final GaugeWithCallback CACHE_MANAGER_LOADING_PAGES;
    public static final Counter DISTRIBUTED_LOAD_JOB_FAILURE;
    public static final Counter DISTRIBUTED_LOAD_JOB_SCANNED;
    public static final Counter DISTRIBUTED_LOAD_JOB_PROCESSED;
    public static final Counter DISTRIBUTED_LOAD_JOB_SKIPPED;
    public static final Counter DISTRIBUTED_LOAD_JOB_LOADED_BYTES;
    public static final Counter DISTRIBUTED_LOAD_JOB_DISPATCHED_SIZE;
    public static final Counter DISTRIBUTED_LOAD_WORKER_SUBTASKS_TOTAL;
    public static final Counter DISTRIBUTED_LOAD_WORKER_BYTES_LOADED_TOTAL;
    public static final Counter DISTRIBUTED_LOAD_WORKER_ERRORS_TOTAL;
    public static final Counter CLIENT_RPC_RETRY_ON_DIFFERENT_WORKERS;

    public static void initMetrics() {
        JvmMetrics.builder().register();
        if (CommonUtils.PROCESS_TYPE.get() != CommonUtils.ProcessType.WORKER && CommonUtils.PROCESS_TYPE.get() != CommonUtils.ProcessType.CLIENT) {
            return;
        }
        if (CommonUtils.PROCESS_TYPE.get() == CommonUtils.ProcessType.CLIENT) {
            PrometheusRegistry.defaultRegistry.register((Collector)EXTERNAL_DATA_READ);
        }
        PrometheusRegistry.defaultRegistry.register((Collector)DATA_ACCESS);
        PrometheusRegistry.defaultRegistry.register((Collector)UFS_DATA_ACCESS);
        PrometheusRegistry.defaultRegistry.register((Collector)META_OPERATION);
        PrometheusRegistry.defaultRegistry.register((Collector)CACHED_DATA_READ);
        PrometheusRegistry.defaultRegistry.register((Collector)CACHED_EVICTED_DATA);
        PrometheusRegistry.defaultRegistry.register((Collector)CACHED_STORAGE);
        PrometheusRegistry.defaultRegistry.register((Collector)CACHED_CAPACITY);
        PrometheusRegistry.defaultRegistry.register((Collector)CACHE_MANAGER_LOADING_PAGES);
    }

    public static void setCacheStorageSupplier(DoubleSupplier supplier) {
        sCacheStorageSupplier = supplier;
    }

    public static void setCacheManagerLoadingPagesSupplier(DoubleSupplier supplier) {
        sCacheManagerLoadingPagesSupplier = supplier;
    }

    static {
        sCacheStorageSupplier = NULL_SUPPLIER = () -> 0.0;
        sCacheManagerLoadingPagesSupplier = NULL_SUPPLIER;
        CACHED_STORAGE = ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("alluxio_cached_storage")).help("amount of the cached data")).unit(Unit.BYTES)).callback(callback -> callback.call(sCacheStorageSupplier.getAsDouble(), new String[0])).build();
        CACHED_CAPACITY = ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("alluxio_cached_capacity")).help("configured maximum cache storage")).unit(Unit.BYTES)).callback(callback -> {
            List<String> sizes = Configuration.global().getList(PropertyKey.WORKER_PAGE_STORE_SIZES);
            long sum = sizes.stream().map(FormatUtils::parseSpaceSize).reduce(0L, Long::sum);
            callback.call((double)sum, new String[0]);
        }).build();
        CACHE_MANAGER_LOADING_PAGES = ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("alluxio_cached_manager_loading_pages")).help("number of pages being loaded from UFS into the cache manager")).unit(Unit.BYTES)).callback(callback -> callback.call(sCacheManagerLoadingPagesSupplier.getAsDouble(), new String[0])).build();
        DISTRIBUTED_LOAD_JOB_FAILURE = (Counter)((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_distributed_load_job_failure").help("counter of the distributed load failure received on master")).labelNames(new String[]{"reason", "final_attempt", "worker"})).register();
        DISTRIBUTED_LOAD_JOB_SCANNED = (Counter)((Counter.Builder)Counter.builder().name("alluxio_distributed_load_job_scanned").help("counter of the inodes scanned in distributed load")).register();
        DISTRIBUTED_LOAD_JOB_PROCESSED = (Counter)((Counter.Builder)Counter.builder().name("alluxio_distributed_load_job_processed").help("counter of the non empty file copies loaded in distributed load")).register();
        DISTRIBUTED_LOAD_JOB_SKIPPED = (Counter)((Counter.Builder)Counter.builder().name("alluxio_distributed_load_job_skipped").help("counter of the inodes skipped in distributed load")).register();
        DISTRIBUTED_LOAD_JOB_LOADED_BYTES = (Counter)((Counter.Builder)Counter.builder().name("alluxio_distributed_load_job_loaded_bytes").help("counter of the bytes loaded in distributed load")).register();
        DISTRIBUTED_LOAD_JOB_DISPATCHED_SIZE = (Counter)((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_distributed_load_job_dispatched_size").help("distributed_load_job_batch_size")).labelNames(new String[]{"worker"})).register();
        DISTRIBUTED_LOAD_WORKER_SUBTASKS_TOTAL = (Counter)((Counter.Builder)Counter.builder().name("alluxio_distributed_worker_subtasks_total").help("counter of the total subtasks a worker processes")).register();
        DISTRIBUTED_LOAD_WORKER_BYTES_LOADED_TOTAL = (Counter)((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_distributed_worker_bytes_loaded_total").unit(Unit.BYTES)).help("counter of the total bytes loaded in distributed load of a worker")).register();
        DISTRIBUTED_LOAD_WORKER_ERRORS_TOTAL = (Counter)((Counter.Builder)Counter.builder().name("alluxio_distributed_worker_errors_total").help("counter of the total errors in distributed load of a worker")).register();
        CLIENT_RPC_RETRY_ON_DIFFERENT_WORKERS = ((Counter.Builder)((Counter.Builder)Counter.builder().name("client_rpc_retry_on_different_workers").help("counter of client retry on different workers if multi replica is enabled")).labelNames(new String[]{"op", "retry_count"})).build();
    }

    private static class ServletAdapter
    extends HttpExchangeAdapter {
        private final Request mRequest;
        private final Response mResponse;

        public ServletAdapter(HttpServletRequest request, HttpServletResponse response) {
            super(null, null);
            this.mRequest = new Request(request);
            this.mResponse = new Response(response);
        }

        public PrometheusHttpRequest getRequest() {
            return this.mRequest;
        }

        public PrometheusHttpResponse getResponse() {
            return this.mResponse;
        }

        public void handleException(IOException e) throws IOException {
            throw e;
        }

        public void handleException(RuntimeException e) {
            throw e;
        }

        public void close() {
        }

        private static class Response
        implements PrometheusHttpResponse {
            private final HttpServletResponse mResponse;

            public Response(HttpServletResponse response) {
                this.mResponse = response;
            }

            public void setHeader(String name, String value) {
                this.mResponse.setHeader(name, value);
            }

            public OutputStream sendHeadersAndGetBody(int statusCode, int contentLength) throws IOException {
                if (this.mResponse.getHeader("Content-Length") == null && contentLength > 0) {
                    this.mResponse.setContentLength(contentLength);
                }
                this.mResponse.setStatus(statusCode);
                return this.mResponse.getOutputStream();
            }
        }

        private static class Request
        implements PrometheusHttpRequest {
            private final HttpServletRequest mRequest;

            public Request(HttpServletRequest request) {
                this.mRequest = request;
            }

            public String getQueryString() {
                return this.mRequest.getQueryString();
            }

            public Enumeration<String> getHeaders(String name) {
                return this.mRequest.getHeaders(name);
            }

            public String getMethod() {
                return this.mRequest.getMethod();
            }
        }
    }

    public static class WebHandler
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private static final String SERVLET_PATH = "/metrics";
        private final PrometheusScrapeHandler mHandler = new PrometheusScrapeHandler(PrometheusProperties.get(), PrometheusRegistry.defaultRegistry);

        public static ServletContextHandler getHandler() {
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setContextPath(SERVLET_PATH);
            contextHandler.addServlet(new ServletHolder((Servlet)new WebHandler()), "/");
            return contextHandler;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.mHandler.handleRequest((PrometheusHttpExchange)new ServletAdapter(req, resp));
        }
    }
}

