/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclActions;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.AclEntryType;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ExtendedACLEntries {
    protected Map<String, AclActions> mNamedUserActions;
    protected Map<String, AclActions> mNamedGroupActions;
    protected AclActions mMaskActions;

    public ExtendedACLEntries() {
        this.mNamedUserActions = new TreeMap<String, AclActions>();
        this.mNamedGroupActions = new TreeMap<String, AclActions>();
        this.mMaskActions = new AclActions();
    }

    public ExtendedACLEntries(ExtendedACLEntries other) {
        this.mNamedUserActions = new TreeMap<String, AclActions>(other.mNamedUserActions);
        this.mNamedGroupActions = new TreeMap<String, AclActions>(other.mNamedGroupActions);
        this.mMaskActions = new AclActions(other.mMaskActions);
    }

    public List<AclEntry> getEntries() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Map.Entry<String, AclActions> kv : this.mNamedUserActions.entrySet()) {
            builder.add((Object)new AclEntry.Builder().setType(AclEntryType.NAMED_USER).setSubject(kv.getKey()).setActions(kv.getValue()).build());
        }
        for (Map.Entry<String, AclActions> kv : this.mNamedGroupActions.entrySet()) {
            builder.add((Object)new AclEntry.Builder().setType(AclEntryType.NAMED_GROUP).setSubject(kv.getKey()).setActions(kv.getValue()).build());
        }
        if (this.hasExtended()) {
            builder.add((Object)new AclEntry.Builder().setType(AclEntryType.MASK).setActions(this.mMaskActions).build());
        }
        return builder.build();
    }

    public Map<String, AclActions> getNamedUserActions() {
        return this.mNamedUserActions;
    }

    public Map<String, AclActions> getNamedGroupActions() {
        return this.mNamedGroupActions;
    }

    public boolean hasExtended() {
        return !this.mNamedUserActions.isEmpty() || !this.mNamedGroupActions.isEmpty();
    }

    public void removeEntry(AclEntry entry) {
        switch (entry.getType()) {
            case NAMED_USER: {
                this.mNamedUserActions.remove(entry.getSubject());
                return;
            }
            case NAMED_GROUP: {
                this.mNamedGroupActions.remove(entry.getSubject());
                return;
            }
            case MASK: {
                if (this.hasExtended()) {
                    throw new IllegalStateException("Deleting the mask for extended ACLs is not allowed. entry: " + entry);
                }
                this.mMaskActions = new AclActions();
                return;
            }
            case OWNING_USER: 
            case OWNING_GROUP: 
            case OTHER: {
                throw new IllegalStateException("Deleting base entry is not allowed. entry: " + entry);
            }
        }
        throw new IllegalStateException("Unknown ACL entry type: " + (Object)((Object)entry.getType()));
    }

    public void setEntry(AclEntry entry) {
        switch (entry.getType()) {
            case NAMED_USER: {
                this.mNamedUserActions.put(entry.getSubject(), entry.getActions());
                return;
            }
            case NAMED_GROUP: {
                this.mNamedGroupActions.put(entry.getSubject(), entry.getActions());
                return;
            }
            case MASK: {
                this.mMaskActions = entry.getActions();
                return;
            }
            case OWNING_USER: 
            case OWNING_GROUP: 
            case OTHER: {
                throw new IllegalStateException("Deleting base entry is not allowed. entry: " + entry);
            }
        }
        throw new IllegalStateException("Unknown ACL entry type: " + (Object)((Object)entry.getType()));
    }

    public AclActions getNamedUser(String user) {
        return this.mNamedUserActions.get(user);
    }

    public AclActions getNamedGroup(String group) {
        return this.mNamedGroupActions.get(group);
    }

    public AclActions getMask() {
        return this.mMaskActions;
    }

    public void updateMask(AclActions groupActions) {
        AclActions userAction;
        AclActions result = new AclActions(groupActions);
        for (Map.Entry<String, AclActions> kv : this.mNamedUserActions.entrySet()) {
            userAction = kv.getValue();
            result.merge(userAction);
            for (AclAction action : AclAction.values()) {
                if (!result.contains(action) && !userAction.contains(action)) continue;
                result.add(action);
            }
        }
        for (Map.Entry<String, AclActions> kv : this.mNamedGroupActions.entrySet()) {
            userAction = kv.getValue();
            result.merge(userAction);
            for (AclAction action : AclAction.values()) {
                if (!result.contains(action) && !userAction.contains(action)) continue;
                result.add(action);
            }
        }
        this.mMaskActions = result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtendedACLEntries)) {
            return false;
        }
        ExtendedACLEntries that = (ExtendedACLEntries)o;
        return this.mNamedUserActions.equals(that.mNamedUserActions) && this.mNamedGroupActions.equals(that.mNamedGroupActions) && this.mMaskActions.equals(that.mMaskActions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNamedUserActions, this.mNamedGroupActions, this.mMaskActions});
    }
}

