/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shell.CommandReturn;
import alluxio.shell.ScpCommand;
import alluxio.shell.ShellCommand;
import alluxio.shell.SshCommand;
import alluxio.util.FormatUtils;
import alluxio.util.OSUtils;
import alluxio.util.UnixMountInfo;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ShellUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ShellUtils.class);
    public static final String COMMON_SSH_OPTS = "-o StrictHostKeyChecking=no -o ConnectTimeout=5";
    public static final String SET_PERMISSION_COMMAND = "chmod";
    public static final String MOUNT_COMMAND = "mount";
    public static final String TOKEN_SEPARATOR_REGEX = "[ \t\n\r\f]";

    public static String[] getEffectiveGroupsForUserCommand(String user) {
        return new String[]{"id", "-gn", user};
    }

    public static String[] getAllGroupsForUserCommand(String user) {
        return new String[]{"id", "-Gn", user};
    }

    public static String[] getSetPermissionCommand(String perm, String filePath) {
        return new String[]{SET_PERMISSION_COMMAND, perm, filePath};
    }

    public static List<UnixMountInfo> getUnixMountInfo() throws IOException {
        Preconditions.checkState((OSUtils.isLinux() || OSUtils.isMacOS() ? 1 : 0) != 0);
        String output = ShellUtils.execCommand(MOUNT_COMMAND);
        ArrayList<UnixMountInfo> mountInfo = new ArrayList<UnixMountInfo>();
        for (String line : output.split("\n")) {
            mountInfo.add(ShellUtils.parseMountInfo(line));
        }
        return mountInfo;
    }

    public static UnixMountInfo parseMountInfo(String line) {
        String lineWithoutType;
        UnixMountInfo.Builder builder = new UnixMountInfo.Builder();
        Matcher matcher = Pattern.compile(".* (type \\w+ ).*").matcher(line);
        if (matcher.matches()) {
            String match = matcher.group(1);
            builder.setFsType(match.replace("type", "").trim());
            lineWithoutType = line.replace(match, "");
        } else {
            lineWithoutType = line;
        }
        matcher = Pattern.compile("(.*) on (.*) \\((.*)\\)").matcher(lineWithoutType);
        if (!matcher.matches()) {
            LOG.warn("Unable to parse output of '{}': {}", (Object)MOUNT_COMMAND, (Object)line);
            return builder.build();
        }
        builder.setDeviceSpec(matcher.group(1));
        builder.setMountPoint(matcher.group(2));
        builder.setOptions(ShellUtils.parseUnixMountOptions(matcher.group(3)));
        return builder.build();
    }

    private static UnixMountInfo.Options parseUnixMountOptions(String line) {
        UnixMountInfo.Options.Builder builder = new UnixMountInfo.Options.Builder();
        for (String option : line.split(",")) {
            Matcher matcher = Pattern.compile("(.*)=(.*)").matcher(option.trim());
            if (!matcher.matches() || !matcher.group(1).equalsIgnoreCase("size")) continue;
            try {
                builder.setSize(FormatUtils.parseSpaceSize(matcher.group(2)));
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Failed to parse mount point size", (Throwable)e);
            }
        }
        return builder.build();
    }

    public static boolean isMountingPoint(String path, String[] fsTypes) throws IOException {
        List<UnixMountInfo> infoList = ShellUtils.getUnixMountInfo();
        for (UnixMountInfo info : infoList) {
            Optional<String> mountPoint = info.getMountPoint();
            Optional<String> fsType = info.getFsType();
            if (!mountPoint.isPresent() || !((String)mountPoint.get()).equals(path) || !fsType.isPresent()) continue;
            for (String expectedType : fsTypes) {
                if (!((String)fsType.get()).equalsIgnoreCase(expectedType)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAlluxioRunning(String className) {
        String[] command = new String[]{"bash", "-c", "ps -Aww -o command | grep -i \"[j]ava\" | grep " + className};
        try {
            Process p = Runtime.getRuntime().exec(command);
            try (InputStreamReader input = new InputStreamReader(p.getInputStream());){
                if (input.read() < 0) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            System.err.format("Unable to check Alluxio status: %s.%n", e.getMessage());
            return false;
        }
    }

    public static String execCommand(String ... cmd) throws IOException {
        return new ShellCommand(cmd).run();
    }

    public static CommandReturn execCommandWithOutput(String ... cmd) throws IOException {
        return new ShellCommand(cmd).runWithOutput();
    }

    public static CommandReturn sshExecCommandWithOutput(String hostname, String ... cmd) throws IOException {
        return new SshCommand(hostname, cmd).runWithOutput();
    }

    public static CommandReturn scpCommandWithOutput(String hostname, String fromFile, String toFile, boolean isDir) throws IOException {
        return new ScpCommand(hostname, fromFile, toFile, isDir).runWithOutput();
    }

    public static CommandReturn execCmdWithBackup(ShellCommand cmd, ShellCommand backupCmd) throws IOException {
        CommandReturn cr = cmd.runWithOutput();
        if (cr.getExitCode() == 0 || backupCmd == null) {
            return cr;
        }
        return backupCmd.runWithOutput();
    }

    private ShellUtils() {
    }

    public static class ExitCodeException
    extends IOException {
        private static final long serialVersionUID = -6520494427049734809L;
        private final int mExitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.mExitCode = exitCode;
        }

        public int getExitCode() {
            return this.mExitCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ExitCodeException ");
            sb.append("exitCode=").append(this.mExitCode).append(": ");
            sb.append(super.getMessage());
            return sb.toString();
        }
    }
}

