/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorServiceUtils.class);

    public static void shutdownAndAwaitTermination(ExecutorService executorService) {
        ExecutorServiceUtils.shutdownAndAwaitTermination(executorService, 1000L);
    }

    public static void shutdownAndAwaitTermination(ExecutorService executorService, long timeoutMillis) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

