/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.conf;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.ConfigRedactor;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@.InterfaceAudience.Private
public class ConfigurationWithLogging
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationWithLogging.class);
    private final Logger log = LOG;
    private final ConfigRedactor redactor;

    public ConfigurationWithLogging(Configuration conf) {
        super(conf);
        this.redactor = new ConfigRedactor(conf);
    }

    @Override
    public String get(String name) {
        String value = super.get(name);
        this.log.info("Got {} = '{}'", (Object)name, (Object)this.redactor.redact(name, value));
        return value;
    }

    @Override
    public String get(String name, String defaultValue) {
        String value = super.get(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", new Object[]{name, this.redactor.redact(name, value), this.redactor.redact(name, defaultValue)});
        return value;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        boolean value = super.getBoolean(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", new Object[]{name, value, defaultValue});
        return value;
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        float value = super.getFloat(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", new Object[]{name, Float.valueOf(value), Float.valueOf(defaultValue)});
        return value;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        int value = super.getInt(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", new Object[]{name, value, defaultValue});
        return value;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        long value = super.getLong(name, defaultValue);
        this.log.info("Got {} = '{}' (default '{}')", new Object[]{name, value, defaultValue});
        return value;
    }

    @Override
    public void set(String name, String value, String source) {
        this.log.info("Set {} to '{}'{}", new Object[]{name, this.redactor.redact(name, value), source == null ? "" : " from " + source});
        super.set(name, value, source);
    }
}

