/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.Warehouse;
import com.linkedin.coral.hive.metastore.api.Database;
import com.linkedin.coral.hive.metastore.api.HiveObjectType;
import com.linkedin.coral.hive.metastore.api.MetaException;
import com.linkedin.coral.hive.metastore.api.Partition;
import com.linkedin.coral.hive.metastore.api.Table;

public class AcidEventListener
extends MetaStoreEventListener {
    private .TxnStore txnHandler;
    private Configuration conf;

    public AcidEventListener(Configuration configuration) {
        super(configuration);
        this.conf = configuration;
    }

    @Override
    public void onDropDatabase(.DropDatabaseEvent dbEvent) throws MetaException {
        this.txnHandler = this.getTxnHandler();
        this.txnHandler.cleanupRecords(HiveObjectType.DATABASE, dbEvent.getDatabase(), null, null);
    }

    @Override
    public void onDropTable(.DropTableEvent tableEvent) throws MetaException {
        if (.TxnUtils.isTransactionalTable((Table)tableEvent.getTable())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.cleanupRecords(HiveObjectType.TABLE, null, tableEvent.getTable(), null);
        }
    }

    @Override
    public void onDropPartition(.DropPartitionEvent partitionEvent) throws MetaException {
        if (.TxnUtils.isTransactionalTable((Table)partitionEvent.getTable())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.cleanupRecords(HiveObjectType.PARTITION, null, partitionEvent.getTable(), partitionEvent.getPartitionIterator());
        }
    }

    @Override
    public void onAlterTable(.AlterTableEvent tableEvent) throws MetaException {
        if (!.TxnUtils.isTransactionalTable((Table)tableEvent.getNewTable())) {
            return;
        }
        Table oldTable = tableEvent.getOldTable();
        Table newTable = tableEvent.getNewTable();
        if (!(oldTable.getCatName().equalsIgnoreCase(newTable.getCatName()) && oldTable.getDbName().equalsIgnoreCase(newTable.getDbName()) && oldTable.getTableName().equalsIgnoreCase(newTable.getTableName()))) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(oldTable.getCatName(), oldTable.getDbName(), oldTable.getTableName(), null, newTable.getCatName(), newTable.getDbName(), newTable.getTableName(), null);
        }
    }

    @Override
    public void onAlterPartition(.AlterPartitionEvent partitionEvent) throws MetaException {
        String newPartName;
        if (!.TxnUtils.isTransactionalTable((Table)partitionEvent.getTable())) {
            return;
        }
        Partition oldPart = partitionEvent.getOldPartition();
        Partition newPart = partitionEvent.getNewPartition();
        Table t = partitionEvent.getTable();
        String oldPartName = Warehouse.makePartName(t.getPartitionKeys(), oldPart.getValues());
        if (!oldPartName.equals(newPartName = Warehouse.makePartName(t.getPartitionKeys(), newPart.getValues()))) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(t.getCatName(), t.getDbName(), t.getTableName(), oldPartName, t.getCatName(), t.getDbName(), t.getTableName(), newPartName);
        }
    }

    @Override
    public void onAlterDatabase(.AlterDatabaseEvent dbEvent) throws MetaException {
        Database oldDb = dbEvent.getOldDatabase();
        Database newDb = dbEvent.getNewDatabase();
        if (!oldDb.getCatalogName().equalsIgnoreCase(newDb.getCatalogName()) || !oldDb.getName().equalsIgnoreCase(newDb.getName())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.onRename(oldDb.getCatalogName(), oldDb.getName(), null, null, newDb.getCatalogName(), newDb.getName(), null, null);
        }
    }

    private .TxnStore getTxnHandler() {
        boolean hackOn = .MetastoreConf.getBoolVar((Configuration)this.conf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.HIVE_IN_TEST) || .MetastoreConf.getBoolVar((Configuration)this.conf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST);
        String origTxnMgr = null;
        boolean origConcurrency = false;
        if (hackOn) {
            origTxnMgr = .MetastoreConf.getVar((Configuration)this.conf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.HIVE_TXN_MANAGER);
            origConcurrency = .MetastoreConf.getBoolVar((Configuration)this.conf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        }
        this.txnHandler = .TxnUtils.getTxnStore((Configuration)this.conf);
        if (hackOn) {
            .MetastoreConf.setVar((Configuration)this.conf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.HIVE_TXN_MANAGER, (String)origTxnMgr);
            .MetastoreConf.setBoolVar((Configuration)this.conf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)origConcurrency);
        }
        return this.txnHandler;
    }
}

