/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.thrift;

import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.AbstractDeserializer;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.SerDeException;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.SerDeStats;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.thrift.TReflectionUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.thrift.ThriftByteStreamTypedSerDe;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Writable;
import com.linkedin.coral.$internal.org.apache.thrift.protocol.TProtocolFactory;
import java.util.Properties;

public class ThriftDeserializer
extends AbstractDeserializer {
    private ThriftByteStreamTypedSerDe tsd;

    @Override
    public void initialize(Configuration job, Properties tbl) throws SerDeException {
        try {
            String className = tbl.getProperty("serialization.class");
            Class<?> recordClass = job.getClassByName(className);
            String protoName = tbl.getProperty("serialization.format");
            if (protoName == null) {
                protoName = "TBinaryProtocol";
            }
            protoName = protoName.replace("com.facebook.thrift.protocol", "com.linkedin.coral.$internal.org.apache.thrift.protocol");
            TProtocolFactory tp = TReflectionUtils.getProtocolFactoryByName(protoName);
            this.tsd = new ThriftByteStreamTypedSerDe(recordClass, tp, tp);
        }
        catch (Exception e) {
            throw new SerDeException(e);
        }
    }

    @Override
    public Object deserialize(Writable field) throws SerDeException {
        return this.tsd.deserialize(field);
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.tsd.getObjectInspector();
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }
}

