/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.esri.core.geometry;

import com.linkedin.coral.calcite.;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.AttributeStreamOfDbl;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.AttributeStreamOfInt32;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Envelope;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Geometry;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.GeometryCursor;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Line;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.MultiPath;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.MultiPathImpl;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Point;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Point2D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Polygon;

final class OperatorGeneralizeCursor
extends GeometryCursor {
    .ProgressTracker m_progressTracker;
    GeometryCursor m_geoms;
    double m_maxDeviation;
    boolean m_bRemoveDegenerateParts;

    public OperatorGeneralizeCursor(GeometryCursor geoms, double maxDeviation, boolean bRemoveDegenerateParts, .ProgressTracker progressTracker) {
        this.m_geoms = geoms;
        this.m_maxDeviation = maxDeviation;
        this.m_progressTracker = progressTracker;
        this.m_bRemoveDegenerateParts = bRemoveDegenerateParts;
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_geoms.next();
        if (geom == null) {
            return null;
        }
        return this.Generalize(geom);
    }

    @Override
    public int getGeometryID() {
        return this.m_geoms.getGeometryID();
    }

    private Geometry Generalize(Geometry geom) {
        Geometry.Type gt = geom.getType();
        if (Geometry.isPoint(gt.value())) {
            return geom;
        }
        if (gt == Geometry.Type.Envelope) {
            Polygon poly = new Polygon(geom.getDescription());
            poly.addEnvelope((Envelope)geom, false);
            return this.Generalize(poly);
        }
        if (geom.isEmpty()) {
            return geom;
        }
        MultiPath mp = (MultiPath)geom;
        MultiPath dstmp = (MultiPath)geom.createInstance();
        Line line = new Line();
        int npath = mp.getPathCount();
        for (int ipath = 0; ipath < npath; ++ipath) {
            this.GeneralizePath((MultiPathImpl)mp._getImpl(), ipath, (MultiPathImpl)dstmp._getImpl(), line);
        }
        return dstmp;
    }

    private void GeneralizePath(MultiPathImpl mpsrc, int ipath, MultiPathImpl mpdst, Line lineHelper) {
        int path_size;
        int rs_size;
        if (mpsrc.getPathSize(ipath) < 2) {
            return;
        }
        int start = mpsrc.getPathStart(ipath);
        int end = mpsrc.getPathEnd(ipath) - 1;
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)mpsrc.getAttributeStreamRef(0);
        boolean bClosed = mpsrc.isClosedPath(ipath);
        AttributeStreamOfInt32 stack = new AttributeStreamOfInt32(0);
        stack.reserve(mpsrc.getPathSize(ipath) + 1);
        AttributeStreamOfInt32 resultStack = new AttributeStreamOfInt32(0);
        resultStack.reserve(mpsrc.getPathSize(ipath) + 1);
        stack.add(bClosed ? start : end);
        stack.add(start);
        Point2D pt = new Point2D();
        while (stack.size() > 1) {
            int i1 = stack.getLast();
            stack.removeLast();
            int i2 = stack.getLast();
            mpsrc.getXY(i1, pt);
            lineHelper.setStartXY(pt);
            mpsrc.getXY(i2, pt);
            lineHelper.setEndXY(pt);
            int mid = this.FindGreatestDistance(lineHelper, pt, xy, i1, i2, end);
            if (mid >= 0) {
                stack.add(mid);
                stack.add(i1);
                continue;
            }
            resultStack.add(i1);
        }
        if (!bClosed) {
            resultStack.add(stack.get(0));
        }
        if ((rs_size = resultStack.size()) == (path_size = mpsrc.getPathSize(ipath)) && rs_size == stack.size()) {
            mpdst.addPath(mpsrc, ipath, true);
        } else if (resultStack.size() > 0) {
            int i;
            if (this.m_bRemoveDegenerateParts && resultStack.size() <= 2) {
                if (bClosed || resultStack.size() == 1) {
                    return;
                }
                double d = Point2D.distance(mpsrc.getXY(resultStack.get(0)), mpsrc.getXY(resultStack.get(1)));
                if (d <= this.m_maxDeviation) {
                    return;
                }
            }
            Point point = new Point();
            int n = resultStack.size();
            for (i = 0; i < n; ++i) {
                mpsrc.getPointByVal(resultStack.get(i), point);
                if (i == 0) {
                    mpdst.startPath(point);
                    continue;
                }
                mpdst.lineTo(point);
            }
            if (bClosed) {
                for (i = resultStack.size(); i < 3; ++i) {
                    mpdst.lineTo(point);
                }
                mpdst.closePathWithLine();
            }
        }
    }

    private int FindGreatestDistance(Line line, Point2D ptHelper, AttributeStreamOfDbl xy, int start, int end, int pathEnd) {
        int to = end - 1;
        if (end <= start) {
            to = pathEnd;
        }
        int mid = -1;
        double maxd = -1.0;
        for (int i = start + 1; i <= to; ++i) {
            xy.read(2 * i, ptHelper);
            double x1 = ptHelper.x;
            double y1 = ptHelper.y;
            double t = line.getClosestCoordinate(ptHelper, false);
            line.getCoord2D(t, ptHelper);
            ptHelper.x -= x1;
            ptHelper.y -= y1;
            double dist = ptHelper.length();
            if (!(dist > this.m_maxDeviation) || !(dist > maxd)) continue;
            mid = i;
            maxd = dist;
        }
        return mid;
    }
}

