/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.theta;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.NativeMemory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.ResizeFactor;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Util;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.theta.PreambleUtil;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.theta.UpdateSketch;

abstract class HeapUpdateSketch
extends UpdateSketch {
    final int lgNomLongs_;
    private final long seed_;
    private final float p_;
    private final ResizeFactor rf_;

    HeapUpdateSketch(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        this.lgNomLongs_ = Math.max(lgNomLongs, 4);
        this.seed_ = seed;
        this.p_ = p;
        this.rf_ = rf;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return this.rf_;
    }

    @Override
    int getLgNomLongs() {
        return this.lgNomLongs_;
    }

    @Override
    long getSeed() {
        return this.seed_;
    }

    @Override
    float getP() {
        return this.p_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.getSeed());
    }

    byte[] toByteArray(int preLongs, byte familyID) {
        if (this.isDirty()) {
            this.rebuild();
        }
        int preBytes = preLongs << 3 & 0x3F;
        int dataBytes = this.getCurrentDataLongs(false) << 3;
        byte[] byteArrOut = new byte[preBytes + dataBytes];
        NativeMemory memOut = new NativeMemory(byteArrOut);
        Object memObj = memOut.array();
        long memAdd = memOut.getCumulativeOffset(0L);
        int lgRf = this.getResizeFactor().lg() & 3;
        byte byte0 = (byte)(lgRf << 6 | preLongs);
        PreambleUtil.insertPreLongs(memObj, memAdd, byte0);
        PreambleUtil.insertSerVer(memObj, memAdd, 3);
        PreambleUtil.insertFamilyID(memObj, memAdd, familyID);
        PreambleUtil.insertLgNomLongs(memObj, memAdd, this.getLgNomLongs());
        PreambleUtil.insertLgArrLongs(memObj, memAdd, this.getLgArrLongs());
        PreambleUtil.insertSeedHash(memObj, memAdd, this.getSeedHash());
        PreambleUtil.insertCurCount(memObj, memAdd, this.getRetainedEntries(true));
        PreambleUtil.insertP(memObj, memAdd, this.getP());
        PreambleUtil.insertThetaLong(memObj, memAdd, this.getThetaLong());
        int flags = this.isEmpty() ? 4 : 0;
        PreambleUtil.insertFlags(memObj, memAdd, flags);
        int arrLongs = 1 << this.getLgArrLongs();
        long[] cache = this.getCache();
        memOut.putLongArray(preBytes, cache, 0, arrLongs);
        return byteArrOut;
    }
}

