/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class HiveTypeSystem
extends RelDataTypeSystemImpl {
    private static final int MAX_DECIMAL_PRECISION = 38;
    private static final int MAX_DECIMAL_SCALE = 38;
    private static final int DEFAULT_DECIMAL_PRECISION = 10;
    private static final int MAX_CHAR_PRECISION = Integer.MAX_VALUE;
    private static final int DEFAULT_VARCHAR_PRECISION = 65535;
    private static final int DEFAULT_CHAR_PRECISION = 255;
    private static final int MAX_BINARY_PRECISION = Integer.MAX_VALUE;
    private static final int MAX_TIMESTAMP_PRECISION = 9;
    private static final int DEFAULT_TINYINT_PRECISION = 3;
    private static final int DEFAULT_SMALLINT_PRECISION = 5;
    private static final int DEFAULT_INTEGER_PRECISION = 10;
    private static final int DEFAULT_BIGINT_PRECISION = 19;

    @Override
    public int getMaxScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericScale();
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 9;
            }
        }
        return -1;
    }

    @Override
    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case BINARY: 
            case VARBINARY: 
            case TIME: 
            case TIMESTAMP: {
                return -1;
            }
            case CHAR: {
                return 255;
            }
            case VARCHAR: {
                return 65535;
            }
            case DECIMAL: {
                return 10;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 2;
            }
            case TINYINT: {
                return 3;
            }
            case SMALLINT: {
                return 5;
            }
            case INTEGER: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
        }
        return -1;
    }

    @Override
    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case CHAR: 
            case VARCHAR: {
                return Integer.MAX_VALUE;
            }
            case BINARY: 
            case VARBINARY: {
                return Integer.MAX_VALUE;
            }
            case TIME: 
            case TIMESTAMP: {
                return 9;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 10;
            }
        }
        return -1;
    }

    @Override
    public int getMaxNumericScale() {
        return 38;
    }

    @Override
    public int getMaxNumericPrecision() {
        return 38;
    }

    @Override
    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        switch (argumentType.getSqlTypeName()) {
            case TINYINT: 
            case SMALLINT: {
                return this.nullableType(typeFactory, SqlTypeName.INTEGER);
            }
            case INTEGER: 
            case BIGINT: {
                return this.nullableType(typeFactory, SqlTypeName.BIGINT);
            }
            case REAL: 
            case FLOAT: 
            case DOUBLE: {
                return this.nullableType(typeFactory, SqlTypeName.DOUBLE);
            }
            case DECIMAL: {
                return this.nullableType(typeFactory, SqlTypeName.DECIMAL);
            }
        }
        return argumentType;
    }

    @Override
    public boolean shouldConvertRaggedUnionTypesToVarying() {
        return true;
    }

    @Override
    public boolean isSchemaCaseSensitive() {
        return false;
    }

    @Override
    public RelDataType deriveDecimalDivideType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2)) {
            if (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2)) {
                return super.deriveDecimalDivideType(typeFactory, type1, type2);
            }
            return this.nullableType(typeFactory, SqlTypeName.DOUBLE);
        }
        return null;
    }

    @Override
    public RelDataType deriveDecimalMultiplyType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2)) {
            if (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2)) {
                return super.deriveDecimalMultiplyType(typeFactory, type1, type2);
            }
            if (SqlTypeUtil.isBigint(type1) || SqlTypeUtil.isBigint(type2)) {
                return this.nullableType(typeFactory, SqlTypeName.BIGINT);
            }
        }
        return null;
    }

    private RelDataType nullableType(RelDataTypeFactory typeFactory, SqlTypeName typeName) {
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), true);
    }
}

