/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.SqlValidator;

public class TypeDerivationUtil {
    private final SqlValidator sqlValidator;
    private final List<SqlSelect> topSelectNodes = new ArrayList<SqlSelect>();

    public TypeDerivationUtil(SqlValidator sqlValidator, SqlNode topSqlNode) {
        this.sqlValidator = sqlValidator;
        topSqlNode.accept(new SqlNodePreprocessorForTypeDerivation());
    }

    public RelDataType getRelDataType(SqlNode sqlNode) {
        if (this.sqlValidator == null) {
            throw new RuntimeException("SqlValidator does not exist to derive the RelDataType for SqlNode: " + sqlNode);
        }
        RelDataType cachedDataType = this.sqlValidator.getValidatedNodeTypeIfKnown(sqlNode);
        if (cachedDataType != null) {
            return cachedDataType;
        }
        for (SqlSelect topSqlSelectNode : this.topSelectNodes) {
            SqlSelect dummySqlSelect = new SqlSelect(topSqlSelectNode.getParserPosition(), null, SqlNodeList.of(sqlNode), topSqlSelectNode.getFrom(), topSqlSelectNode.getWhere(), topSqlSelectNode.getGroup(), topSqlSelectNode.getHaving(), topSqlSelectNode.getWindowList(), topSqlSelectNode.getOrderList(), topSqlSelectNode.getOffset(), topSqlSelectNode.getFetch());
            try {
                this.sqlValidator.validate(dummySqlSelect);
                return this.sqlValidator.getValidatedNodeType(dummySqlSelect).getFieldList().get(0).getType();
            }
            catch (Throwable throwable) {
            }
        }
        try {
            SqlSelect dummySqlSelect = new SqlSelect(this.topSelectNodes.get(0).getParserPosition(), null, SqlNodeList.of(sqlNode), this.topSelectNodes.get(0), null, null, null, null, null, null, null);
            this.sqlValidator.validate(dummySqlSelect);
            return this.sqlValidator.getValidatedNodeType(sqlNode);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(String.format("Failed to derive the RelDataType for SqlNode: %s with topSqlNode: %s", sqlNode, this.topSelectNodes.get(0)));
        }
    }

    public RelDataType leastRestrictive(List<RelDataType> types) {
        return this.sqlValidator.getTypeFactory().leastRestrictive(types);
    }

    private class SqlNodePreprocessorForTypeDerivation
    extends SqlShuttle {
        private SqlNodePreprocessorForTypeDerivation() {
        }

        @Override
        public SqlNode visit(SqlCall sqlCall) {
            if (sqlCall instanceof SqlSelect) {
                if (((SqlSelect)sqlCall).getSelectList() == null) {
                    ArrayList<String> names = new ArrayList<String>();
                    names.add("*");
                    List<SqlParserPos> sqlParserPos = Collections.nCopies(names.size(), SqlParserPos.ZERO);
                    SqlIdentifier star = SqlIdentifier.star(names, SqlParserPos.ZERO, sqlParserPos);
                    ((SqlSelect)sqlCall).setSelectList(SqlNodeList.of(star));
                }
                TypeDerivationUtil.this.topSelectNodes.add((SqlSelect)sqlCall);
            }
            return super.visit(sqlCall);
        }
    }
}

