/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.linkedin.coral.calcite.$internal.com.google.common.base.Preconditions;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.HiveTable;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.common.functions.FunctionRegistry;
import com.linkedin.coral.common.functions.UnknownSqlFunctionException;
import com.linkedin.coral.hive.hive2rel.functions.HiveGenericUDFReturnTypeInference;
import com.linkedin.coral.hive.hive2rel.functions.HiveRLikeOperator;
import com.linkedin.coral.hive.hive2rel.functions.VersionedSqlUserDefinedFunction;
import com.linkedin.coral.hive.metastore.api.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class HiveFunctionResolver {
    private static final String VERSIONED_UDF_CLASS_NAME_PREFIX = "coral_udf_version_(\\d+|x)_(\\d+|x)_(\\d+|x)";
    public final FunctionRegistry registry;
    private final ConcurrentHashMap<String, Function> dynamicFunctionRegistry;
    private final List<SqlOperator> operators;

    public HiveFunctionResolver(FunctionRegistry registry, ConcurrentHashMap<String, Function> dynamicRegistry) {
        this.registry = registry;
        this.dynamicFunctionRegistry = dynamicRegistry;
        this.operators = new ArrayList<SqlOperator>(SqlStdOperatorTable.instance().getOperatorList());
        this.operators.add(HiveRLikeOperator.REGEXP);
        this.operators.add(HiveRLikeOperator.RLIKE);
    }

    public SqlOperator resolveUnaryOperator(String name) {
        if ("!".equals(name)) {
            return SqlStdOperatorTable.NOT;
        }
        List matches = this.operators.stream().filter(o -> o.getName().equalsIgnoreCase(name) && o instanceof SqlPrefixOperator).collect(Collectors.toList());
        com.google.common.base.Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0, (String)"%s operator %s", (Object[])new Object[]{matches.isEmpty() ? "Unknown" : "Ambiguous", name});
        return (SqlOperator)matches.get(0);
    }

    public SqlOperator resolveBinaryOperator(String name) {
        Function f;
        String lowerCaseOperator = name.toLowerCase();
        List matches = this.operators.stream().filter(o -> o.getName().toLowerCase().equals(lowerCaseOperator) && (o instanceof SqlBinaryOperator || o instanceof SqlSpecialOperator)).collect(Collectors.toList());
        if (matches.size() == 0 && (f = this.tryResolve(lowerCaseOperator, null, 2)) != null) {
            matches.add(f.getSqlOperator());
        }
        if (lowerCaseOperator.equals("+")) {
            return SqlStdOperatorTable.PLUS;
        }
        if (lowerCaseOperator.equals("-")) {
            return SqlStdOperatorTable.MINUS;
        }
        com.google.common.base.Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0, (String)"%s operator %s", (Object[])new Object[]{this.operators.isEmpty() ? "Unknown" : "Ambiguous", name});
        return (SqlOperator)matches.get(0);
    }

    public Function tryResolve(@Nonnull String originalViewTextFunctionName, @Nullable Table hiveTable, int numOfOperands) {
        com.google.common.base.Preconditions.checkNotNull((Object)originalViewTextFunctionName);
        Collection<Function> functions = this.registry.lookup(originalViewTextFunctionName);
        if (functions.isEmpty() && hiveTable != null) {
            functions = this.tryResolveAsDaliFunction(originalViewTextFunctionName, hiveTable, numOfOperands);
        }
        if (functions.isEmpty()) {
            throw new UnknownSqlFunctionException(originalViewTextFunctionName);
        }
        if (functions.size() == 1) {
            return functions.iterator().next();
        }
        return this.unresolvedFunction(functions.iterator().next().getSqlOperator().getName());
    }

    public Collection<Function> resolve(String functionName) {
        Collection<Function> staticLookup = this.registry.lookup(functionName);
        if (!staticLookup.isEmpty()) {
            return staticLookup;
        }
        ImmutableList<Function> dynamicLookup = ImmutableList.of();
        Function Function3 = this.dynamicFunctionRegistry.get(functionName);
        if (Function3 != null) {
            dynamicLookup = ImmutableList.of(Function3);
        }
        return dynamicLookup;
    }

    public Collection<Function> tryResolveAsDaliFunction(String originalViewTextFunctionName, @Nonnull Table table, int numOfOperands) {
        Preconditions.checkNotNull(table);
        String functionPrefix = String.format("%s_%s_", table.getDbName(), table.getTableName());
        if (!originalViewTextFunctionName.toLowerCase().startsWith(functionPrefix.toLowerCase())) {
            functionPrefix = "";
        }
        String funcBaseName = originalViewTextFunctionName.substring(functionPrefix.length());
        HiveTable hiveTable = new HiveTable(table);
        Map<String, String> functionParams = hiveTable.getDaliFunctionParams();
        String functionClassName = functionParams.get(funcBaseName);
        if (functionClassName == null) {
            return ImmutableList.of();
        }
        Collection<Function> functions = this.registry.lookup(this.removeVersioningPrefix(functionClassName));
        if (functions.isEmpty()) {
            Collection<Function> dynamicResolvedFunctions = this.resolveDaliFunctionDynamically(originalViewTextFunctionName, functionClassName, hiveTable, numOfOperands);
            if (dynamicResolvedFunctions.isEmpty()) {
                throw new UnknownSqlFunctionException(functionClassName);
            }
            return dynamicResolvedFunctions;
        }
        return functions.stream().map(f -> new Function(f.getFunctionName(), new VersionedSqlUserDefinedFunction((SqlUserDefinedFunction)f.getSqlOperator(), hiveTable.getDaliUdfDependencies(), originalViewTextFunctionName, functionClassName))).collect(Collectors.toList());
    }

    public void addDynamicFunctionToTheRegistry(String functionClassName, Function function) {
        if (!this.dynamicFunctionRegistry.contains(functionClassName)) {
            this.dynamicFunctionRegistry.put(functionClassName, function);
        }
    }

    @Nonnull
    private Collection<Function> resolveDaliFunctionDynamically(String originalViewTextFunctionName, String functionClassName, HiveTable hiveTable, int numOfOperands) {
        if (this.dynamicFunctionRegistry.contains(functionClassName)) {
            return ImmutableList.of(this.dynamicFunctionRegistry.get(originalViewTextFunctionName));
        }
        Function function = new Function(functionClassName, new VersionedSqlUserDefinedFunction(new SqlUserDefinedFunction(new SqlIdentifier(functionClassName, SqlParserPos.ZERO), (SqlReturnTypeInference)new HiveGenericUDFReturnTypeInference(functionClassName, hiveTable.getDaliUdfDependencies()), null, this.createSqlOperandTypeChecker(numOfOperands), null, null), hiveTable.getDaliUdfDependencies(), originalViewTextFunctionName, functionClassName));
        this.dynamicFunctionRegistry.put(functionClassName, function);
        return ImmutableList.of(function);
    }

    @Nonnull
    private Function unresolvedFunction(String functionName) {
        SqlIdentifier funcIdentifier = new SqlIdentifier(ImmutableList.of(functionName), SqlParserPos.ZERO);
        return new Function(functionName, new SqlUnresolvedFunction(funcIdentifier, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION));
    }

    @Nonnull
    private SqlOperandTypeChecker createSqlOperandTypeChecker(int numOfOperands) {
        ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
        for (int i = 0; i < numOfOperands; ++i) {
            families.add(SqlTypeFamily.ANY);
        }
        FamilyOperandTypeChecker sqlOperandTypeChecker = OperandTypes.family(families);
        return sqlOperandTypeChecker;
    }

    private String removeVersioningPrefix(String className) {
        String prefix;
        int firstDotIndex;
        if (className != null && !className.isEmpty() && (firstDotIndex = className.indexOf(46)) != -1 && (prefix = className.substring(0, firstDotIndex)).matches(VERSIONED_UDF_CLASS_NAME_PREFIX)) {
            return className.substring(firstDotIndex + 1);
        }
        return className;
    }
}

