/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.functions;

import java.util.Arrays;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class TrinoElementAtFunction
extends SqlSpecialOperator {
    public static final TrinoElementAtFunction INSTANCE = new TrinoElementAtFunction();
    private static final SqlSingleOperandTypeChecker ARRAY_OR_MAP = OperandTypes.or(OperandTypes.family(SqlTypeFamily.ARRAY), OperandTypes.family(SqlTypeFamily.MAP), OperandTypes.family(SqlTypeFamily.ANY));

    private TrinoElementAtFunction() {
        super("element_at", SqlKind.OTHER_FUNCTION, 100, true, null, null, null);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int ordinal, SqlSpecialOperator.TokenSequence list) {
        SqlNode left = list.node(ordinal - 1);
        SqlNode right = list.node(ordinal + 1);
        return new SqlSpecialOperator.ReduceResult(this, ordinal - 1, ordinal + 2, this.createCall(SqlParserPos.sum(Arrays.asList(left.getParserPosition(), right.getParserPosition(), list.pos(ordinal))), left, right));
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlUtil.unparseFunctionSyntax(this, writer, call);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        if (!ARRAY_OR_MAP.checkSingleOperandType(callBinding, left, 0, throwOnFailure)) {
            return false;
        }
        SqlSingleOperandTypeChecker checker = this.getChecker(callBinding);
        return checker.checkSingleOperandType(callBinding, right, 0, throwOnFailure);
    }

    private SqlSingleOperandTypeChecker getChecker(SqlCallBinding callBinding) {
        RelDataType operandType = callBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return OperandTypes.family(SqlTypeFamily.INTEGER);
            }
            case MAP: {
                return OperandTypes.family(operandType.getKeyType().getSqlTypeName().getFamily());
            }
            case ANY: 
            case DYNAMIC_STAR: {
                return OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.CHARACTER));
            }
        }
        throw callBinding.newValidationSignatureError();
    }

    @Override
    public String getAllowedSignatures(String name) {
        return "<ARRAY>[<INTEGER>]\n<MAP>[<VALUE>]";
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType operandType = opBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return typeFactory.createTypeWithNullability(operandType.getComponentType(), true);
            }
            case MAP: {
                return typeFactory.createTypeWithNullability(operandType.getValueType(), true);
            }
            case ANY: 
            case DYNAMIC_STAR: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
            }
        }
        throw new AssertionError();
    }
}

