/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.functions.CoralSqlUnnestOperator;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import com.linkedin.coral.trino.rel2trino.TrinoSqlDialect;
import com.linkedin.coral.trino.rel2trino.functions.TrinoArrayTransformFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;

public class UnnestOperatorTransformer
extends SqlCallTransformer {
    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator() instanceof CoralSqlUnnestOperator;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        CoralSqlUnnestOperator operator = (CoralSqlUnnestOperator)sqlCall.getOperator();
        Object unnestOperand = sqlCall.operand(0);
        if (operator.getRelDataType() != null) {
            String fieldName = ((SqlNode)unnestOperand).toSqlString(TrinoSqlDialect.INSTANCE).getSql();
            if (unnestOperand instanceof SqlIdentifier) {
                SqlIdentifier operand = (SqlIdentifier)unnestOperand;
                fieldName = operand.toSqlString(TrinoSqlDialect.INSTANCE).getSql();
            } else if (unnestOperand instanceof SqlCall && ((SqlCall)unnestOperand).getOperator().getName().equalsIgnoreCase("if")) {
                fieldName = ((SqlNode)unnestOperand).toSqlString(TrinoSqlDialect.INSTANCE).getSql();
            }
            SqlCharStringLiteral transformArgsLiteral = SqlLiteral.createCharString(String.format("%s, x -> ROW(x)", fieldName), SqlImplementor.POS);
            RelDataType recordType = operator.getRelDataType();
            RelRecordType transformDataType = new RelRecordType((List<RelDataTypeField>)ImmutableList.of((Object)new RelDataTypeFieldImpl("wrapper_field", 0, recordType)));
            unnestOperand = new TrinoArrayTransformFunction(transformDataType).createCall(SqlImplementor.POS, transformArgsLiteral);
        }
        return operator.createCall(SqlImplementor.POS, new ArrayList(Collections.singletonList(unnestOperand)).toArray(new SqlNode[0]));
    }
}

