/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;

class JoinNamespace
extends AbstractNamespace {
    private final SqlJoin join;

    JoinNamespace(SqlValidatorImpl validator, SqlJoin join) {
        super(validator, null);
        this.join = join;
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        RelDataType leftType = this.validator.getNamespace(this.join.getLeft()).getRowType();
        SqlNode right = this.join.getRight().getKind() == SqlKind.LATERAL ? ((SqlCall)this.join.getRight()).operand(0) : this.join.getRight();
        RelDataType rightType = this.validator.getNamespace(right).getRowType();
        RelDataTypeFactory typeFactory = this.validator.getTypeFactory();
        switch (this.join.getJoinType()) {
            case LEFT: {
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
            case RIGHT: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                break;
            }
            case FULL: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                rightType = typeFactory.createTypeWithNullability(rightType, true);
            }
        }
        return typeFactory.createJoinType(leftType, rightType);
    }

    @Override
    public SqlNode getNode() {
        return this.join;
    }
}

